/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.thrift.transport;

import java.util.Objects;
import org.apache.storm.thrift.TConfiguration;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.thrift.transport.TTransportException;

public abstract class TEndpointTransport
extends TTransport {
    protected long knownMessageSize;
    protected long remainingMessageSize;
    private TConfiguration _configuration;

    protected long getMaxMessageSize() {
        return this.getConfiguration().getMaxMessageSize();
    }

    public int getMaxFrameSize() {
        return this.getConfiguration().getMaxFrameSize();
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.getConfiguration().setMaxFrameSize(maxFrameSize);
    }

    @Override
    public TConfiguration getConfiguration() {
        return this._configuration;
    }

    public TEndpointTransport(TConfiguration config) throws TTransportException {
        this._configuration = Objects.isNull(config) ? new TConfiguration() : config;
        this.resetConsumedMessageSize(-1L);
    }

    protected void resetConsumedMessageSize(long newSize) throws TTransportException {
        if (newSize < 0L) {
            this.knownMessageSize = this.getMaxMessageSize();
            this.remainingMessageSize = this.getMaxMessageSize();
            return;
        }
        if (newSize > this.knownMessageSize) {
            throw new TTransportException(6, "Message size exceeds limit: " + this.getMaxMessageSize());
        }
        this.knownMessageSize = newSize;
        this.remainingMessageSize = newSize;
    }

    @Override
    public void updateKnownMessageSize(long size) throws TTransportException {
        long consumed = this.knownMessageSize - this.remainingMessageSize;
        this.resetConsumedMessageSize(size == 0L ? -1L : size);
        this.countConsumedMessageBytes(consumed);
    }

    @Override
    public void checkReadBytesAvailable(long numBytes) throws TTransportException {
        if (this.remainingMessageSize < numBytes) {
            throw new TTransportException(6, "Message size exceeds limit: " + this.getMaxMessageSize());
        }
    }

    protected void countConsumedMessageBytes(long numBytes) throws TTransportException {
        if (this.remainingMessageSize >= numBytes) {
            this.remainingMessageSize -= numBytes;
        } else {
            this.remainingMessageSize = 0L;
            throw new TTransportException(6, "Message size exceeds limit: " + this.getMaxMessageSize());
        }
    }
}

