/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class RequestMessage {
    private String gremlin;
    private Map<String, Object> fields;

    private RequestMessage(String gremlin, Map<String, Object> fields) {
        if (null == gremlin) {
            throw new IllegalArgumentException("RequestMessage requires gremlin argument");
        }
        this.gremlin = gremlin;
        this.fields = fields;
        this.fields.putIfAbsent("language", "gremlin-lang");
    }

    private RequestMessage() {
    }

    public <T> Optional<T> optionalField(String key) {
        Object o = this.fields.get(key);
        return o == null ? Optional.empty() : Optional.of(o);
    }

    public <T> T getField(String key) {
        return (T)this.fields.get(key);
    }

    public <T> T getFieldOrDefault(String key, T def) {
        return this.optionalField(key).orElse(def);
    }

    public String getGremlin() {
        return this.gremlin;
    }

    public Map<String, Object> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public RequestMessage trimMessage(int size) {
        this.gremlin = this.gremlin.substring(0, size) + "...";
        return this;
    }

    public static Builder from(RequestMessage msg) {
        Builder builder = RequestMessage.build(msg.gremlin);
        builder.fields.putAll(msg.getFields());
        if (msg.getFields().containsKey("bindings")) {
            builder.addBindings((Map)msg.getFields().get("bindings"));
        }
        return builder;
    }

    public static Builder from(RequestMessage msg, String gremlin) {
        Builder builder = RequestMessage.build(gremlin);
        builder.fields.putAll(msg.getFields());
        if (msg.getFields().containsKey("bindings")) {
            builder.addBindings((Map)msg.getFields().get("bindings"));
        }
        return builder;
    }

    public String toString() {
        return "RequestMessage{, fields=" + this.fields + ", gremlin=" + this.gremlin + '}';
    }

    public static Builder build(String gremlin) {
        return new Builder(gremlin);
    }

    public static final class Builder {
        private final String gremlin;
        private final Map<String, Object> bindings = new HashMap<String, Object>();
        private final Map<String, Object> fields = new HashMap<String, Object>();

        private Builder(String gremlin) {
            this.gremlin = gremlin;
        }

        public Builder addLanguage(String language) {
            Objects.requireNonNull(language, "language argument cannot be null.");
            this.fields.put("language", language);
            return this;
        }

        public Builder addBinding(String key, Object val) {
            this.bindings.put(key, val);
            return this;
        }

        public Builder addBindings(Map<String, Object> otherBindings) {
            Objects.requireNonNull(otherBindings, "bindings argument cannot be null.");
            this.bindings.putAll(otherBindings);
            return this;
        }

        public Builder addG(String g) {
            Objects.requireNonNull(g, "g argument cannot be null.");
            this.fields.put("g", g);
            return this;
        }

        public Builder addChunkSize(int chunkSize) {
            this.fields.put("batchSize", chunkSize);
            return this;
        }

        public Builder addMaterializeProperties(String materializeProps) {
            Objects.requireNonNull(materializeProps, "materializeProps argument cannot be null.");
            if (!materializeProps.equals("tokens") && !materializeProps.equals("all")) {
                throw new IllegalArgumentException("materializeProperties argument must be either token or all.");
            }
            this.fields.put("materializeProperties", materializeProps);
            return this;
        }

        public Builder addTimeoutMillis(long timeout) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout argument cannot be negative.");
            }
            this.fields.put("timeoutMs", timeout);
            return this;
        }

        public Builder addBulkResults(boolean bulking) {
            this.fields.put("bulkResults", String.valueOf(bulking));
            return this;
        }

        public RequestMessage create() {
            this.fields.put("bindings", this.bindings);
            return new RequestMessage(this.gremlin, this.fields);
        }
    }
}

