/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class JohnzonParameterizedType
implements ParameterizedType {
    private final Type rawType;
    private final Type[] types;

    public JohnzonParameterizedType(Type raw, Type ... types) {
        if (raw == null) {
            ParameterizedType userFinalType = this.findUserParameterizedType();
            this.rawType = userFinalType.getRawType();
            this.types = userFinalType.getActualTypeArguments();
        } else {
            this.rawType = raw;
            this.types = types;
        }
    }

    private ParameterizedType findUserParameterizedType() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (!ParameterizedType.class.isInstance(genericSuperclass)) {
            throw new IllegalArgumentException("raw can be null only for children classes");
        }
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(genericSuperclass);
        Type userType = pt.getActualTypeArguments()[0];
        if (!ParameterizedType.class.isInstance(userType)) {
            throw new IllegalArgumentException("You need to pass a parameterized type to Johnzon*Types");
        }
        return (ParameterizedType)ParameterizedType.class.cast(userType);
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.types.clone();
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        return Arrays.hashCode(this.types) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)obj;
            Type thatRawType = that.getRawType();
            return that.getOwnerType() == null && (this.rawType == null ? thatRawType == null : this.rawType.equals(thatRawType)) && Arrays.equals(this.types, that.getActualTypeArguments());
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Class)this.rawType).getSimpleName());
        Type[] actualTypes = this.getActualTypeArguments();
        if (actualTypes.length > 0) {
            buffer.append("<");
            int length = actualTypes.length;
            for (int i = 0; i < length; ++i) {
                buffer.append(actualTypes[i].toString());
                if (i == actualTypes.length - 1) continue;
                buffer.append(",");
            }
            buffer.append(">");
        }
        return buffer.toString();
    }
}

