/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ManagedConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.GeronimoConnectionEventListener;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

public class MCFConnectionInterceptor
implements ConnectionInterceptor {
    protected static final Logger log = Logger.getLogger(MCFConnectionInterceptor.class.getName());
    private ConnectionInterceptor stack;

    @Override
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        if (mci.getManagedConnection() != null) {
            return;
        }
        try {
            ManagedConnection mc = mci.getManagedConnectionFactory().createManagedConnection(mci.getSubject(), mci.getConnectionRequestInfo());
            mci.setManagedConnection(mc);
            GeronimoConnectionEventListener listener = new GeronimoConnectionEventListener(this.stack, mci);
            mci.setConnectionEventListener(listener);
            mc.addConnectionEventListener((ConnectionEventListener)listener);
        }
        catch (ResourceException re) {
            log.log(Level.SEVERE, "Error occurred creating ManagedConnection for " + connectionInfo, re);
            throw re;
        }
    }

    @Override
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        ManagedConnection mc = mci.getManagedConnection();
        try {
            mc.destroy();
        }
        catch (ResourceException resourceException) {
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
    }

    public void setStack(ConnectionInterceptor stack) {
        this.stack = stack;
    }

    @Override
    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[stack=").append(this.stack).append("]\n");
        s.append("<end>");
    }
}

