/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public abstract class AbstractChangesetDownloadTask
extends AbstractDownloadTask<Set<Changeset>> {
    private RunnableDownloadTask downloadTaskRunnable;

    protected final void setDownloadTask(RunnableDownloadTask downloadTask) {
        this.downloadTaskRunnable = downloadTask;
    }

    @Override
    public final Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return this.download();
    }

    public final Future<?> download() {
        return this.downloadTaskRunnable != null ? MainApplication.worker.submit(this.downloadTaskRunnable) : null;
    }

    @Override
    public final Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        return this.downloadTaskRunnable != null ? MainApplication.worker.submit(this.downloadTaskRunnable) : null;
    }

    @Override
    public final void cancel() {
        if (this.downloadTaskRunnable != null) {
            this.downloadTaskRunnable.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL url) {
        return null;
    }

    abstract class RunnableDownloadTask
    extends PleaseWaitRunnable {
        protected final OsmServerChangesetReader reader;
        protected final Set<Changeset> downloadedChangesets;
        protected Exception lastException;

        RunnableDownloadTask(Component parent, String title) {
            super(parent, title, false);
            this.reader = new OsmServerChangesetReader();
            this.downloadedChangesets = new HashSet<Changeset>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            AbstractChangesetDownloadTask.this.setCanceled(true);
            RunnableDownloadTask runnableDownloadTask = this;
            synchronized (runnableDownloadTask) {
                if (this.reader != null) {
                    this.reader.cancel();
                }
            }
        }

        protected final void rememberLastException(Exception e) {
            this.lastException = e;
            AbstractChangesetDownloadTask.this.setFailed(true);
        }

        protected final void updateChangesets() {
            Runnable r = () -> ChangesetCache.getInstance().update(this.downloadedChangesets);
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InterruptedException e) {
                    Logging.warn("InterruptedException in " + this.getClass().getSimpleName() + " while updating changeset cache");
                    Thread.currentThread().interrupt();
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof RuntimeException) {
                        BugReportExceptionHandler.handleException(t);
                    }
                    if (t instanceof Exception) {
                        ExceptionUtil.explainException(e);
                    }
                    BugReportExceptionHandler.handleException(t);
                }
            }
        }
    }
}

