/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;

public interface ManagedRouteGroupMBean
extends ManagedPerformanceCounterMBean {
    @ManagedAttribute(description="Route ID")
    public String getRouteGroup();

    @ManagedAttribute(description="Number of routes in this group")
    public int getGroupSize();

    @ManagedAttribute(description="The route IDs within this group")
    public String[] getGroupIds();

    @ManagedAttribute(description="Route State")
    public String getState();

    @ManagedAttribute(description="Route Uptime [human readable text]")
    public String getUptime();

    @ManagedAttribute(description="Route Uptime [milliseconds]")
    public long getUptimeMillis();

    @ManagedAttribute(description="Camel ID")
    public String getCamelId();

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName();

    @Override
    @ManagedAttribute(description="Number of completed exchanges")
    public long getExchangesCompleted();

    @Override
    @ManagedAttribute(description="Number of failed exchanges")
    public long getExchangesFailed();

    @Override
    @ManagedAttribute(description="Number of inflight exchanges")
    public long getExchangesInflight();

    @Override
    @ManagedAttribute(description="Number of failures handled")
    public long getFailuresHandled();

    @Override
    @ManagedAttribute(description="Number of redeliveries (internal only)")
    public long getRedeliveries();

    @Override
    @ManagedAttribute(description="Number of external initiated redeliveries (such as from JMS broker)")
    public long getExternalRedeliveries();

    @ManagedAttribute(description="Average load (inflight messages, not cpu) over the last minute")
    public String getLoad01();

    @ManagedAttribute(description="Average load (inflight messages, not cpu) over the last five minutes")
    public String getLoad05();

    @ManagedAttribute(description="Average load (inflight messages, not cpu) over the last fifteen minutes")
    public String getLoad15();

    @ManagedAttribute(description="Throughput message/second")
    public String getThroughput();

    @ManagedOperation(description="Start all routes")
    public void start() throws Exception;

    @ManagedOperation(description="Stop all routes")
    public void stop() throws Exception;
}

