/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.apache.custos.core.constants;

public final class Constants {

    public static final String REALM_AGENT = "custos-realm-agent";
    public static final String AGENT_CLIENT = "agent-client";
    public static final String OWNER_ID = "ownerId";
    public static final String DESCRIPTION = "description";

    public static final String ROLE_TYPE_REALM = "realm";
    public static final  String ROLE_TYPE_CLIENT = "client";


    public static final String AUTHORIZATION_CODE = "code";
    public static final String AUTHORIZATION_HEADER = "authorization";
    public static final String PASSWORD_GRANT_TYPE = "password";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET_BASIC = "client_secret_basic";


    public static final String SYSTEM = "SYSTEM";
    public static final String GATEWAY_ADMIN = "GATEWAY_ADMIN";
    public static final String USER_TOKEN = "user-token";
}
