/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.jdbc.core.ADBColumn;
import org.apache.asterix.jdbc.core.ADBConnection;
import org.apache.asterix.jdbc.core.ADBParameterMetaData;
import org.apache.asterix.jdbc.core.ADBProtocolBase;
import org.apache.asterix.jdbc.core.ADBResultSet;
import org.apache.asterix.jdbc.core.ADBResultSetMetaData;
import org.apache.asterix.jdbc.core.ADBStatement;

public class ADBPreparedStatement
extends ADBStatement
implements PreparedStatement {
    protected final String sql;
    protected final List<Object> args;
    protected final List<ADBColumn> resultColumns;

    public ADBPreparedStatement(ADBConnection connection, String sql) throws SQLException {
        super(connection);
        ADBProtocolBase.SubmitStatementOptions stmtOptions = this.createSubmitStatementOptions();
        stmtOptions.compileOnly = true;
        stmtOptions.timeoutSeconds = 0;
        ADBProtocolBase.QueryServiceResponse response = connection.protocol.submitStatement(sql, null, stmtOptions);
        int parameterCount = connection.protocol.getStatementParameterCount(response);
        boolean isQuery = connection.protocol.isStatementCategory(response, ADBProtocolBase.QueryServiceResponse.StatementCategory.QUERY);
        List columns = isQuery ? connection.protocol.getColumns(response) : Collections.emptyList();
        this.sql = sql;
        this.args = Arrays.asList(new Object[parameterCount]);
        this.resultColumns = columns;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return new ADBParameterMetaData(this, this.args.size());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new ADBResultSetMetaData(this, this.resultColumns);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        return this.executeQueryImpl(this.sql, this.args);
    }

    @Override
    public ADBResultSet executeQuery(String sql) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeQuery");
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.executeUpdateImpl(this.sql, this.args);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdateImpl(this.sql, this.args);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeLargeUpdate");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeLargeUpdate");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeLargeUpdate");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeLargeUpdate");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "executeUpdate");
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeImpl(this.sql, this.args);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "execute");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "execute");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "execute");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "execute");
    }

    @Override
    public void addBatch() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "addBatch");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        int n = this.args.size();
        for (int i = 0; i < n; ++i) {
            this.args.set(i, null);
        }
    }

    private int argIndex(int parameterIndex) throws SQLException {
        boolean ok;
        boolean bl = ok = 0 < parameterIndex && parameterIndex <= this.args.size();
        if (!ok) {
            throw this.getErrorReporter().errorParameterValueNotSupported("parameterIndex");
        }
        return parameterIndex - 1;
    }

    private void setArg(int parameterIndex, Object v) throws SQLException {
        this.args.set(this.argIndex(parameterIndex), v);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setByte(int parameterIndex, byte v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setShort(int parameterIndex, short v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setInt(int parameterIndex, int v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setLong(int parameterIndex, long v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setFloat(int parameterIndex, float v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, Float.valueOf(v));
    }

    @Override
    public void setDouble(int parameterIndex, double v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setString(int parameterIndex, String v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setNString(int parameterIndex, String v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setDate(int parameterIndex, Date v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setDate(int parameterIndex, Date v, Calendar cal) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, cal != null ? new ADBStatement.SqlCalendarDate(v, cal.getTimeZone()) : v);
    }

    @Override
    public void setTime(int parameterIndex, Time v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setTime(int parameterIndex, Time v, Calendar cal) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, cal != null ? new ADBStatement.SqlCalendarTime(v, cal.getTimeZone()) : v);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp v) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp v, Calendar cal) throws SQLException {
        this.checkClosed();
        this.setArg(parameterIndex, cal != null ? new ADBStatement.SqlCalendarTimestamp(v, cal.getTimeZone()) : v);
    }

    @Override
    public void setObject(int parameterIndex, Object v) throws SQLException {
        this.checkClosed();
        if (v != null && !ADBPreparedStatement.isSetObjectCompatible(v.getClass())) {
            throw this.getErrorReporter().errorParameterValueNotSupported("object");
        }
        this.setArg(parameterIndex, v);
    }

    @Override
    public void setObject(int parameterIndex, Object v, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, v);
    }

    @Override
    public void setObject(int parameterIndex, Object v, SQLType targetSqlType) throws SQLException {
        if (targetSqlType == null) {
            this.setObject(parameterIndex, v);
        } else {
            this.setObject(parameterIndex, v, targetSqlType.getVendorTypeNumber());
        }
    }

    @Override
    public void setObject(int parameterIndex, Object v, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, v, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object v, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (targetSqlType == null) {
            this.setObject(parameterIndex, v);
        } else {
            this.setObject(parameterIndex, v, targetSqlType.getVendorTypeNumber());
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] v) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setBytes");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setRef");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setRowId");
    }

    @Override
    public void setURL(int parameterIndex, URL v) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setURL");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream v) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setAsciiStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setAsciiStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream v, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setBinaryStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setBinaryStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setCharacterStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setCharacterStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setCharacterStream");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setNCharacterStream");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setNCharacterStream");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setUnicodeStream");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setArray");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setBlob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setBlob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setBlob");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setClob");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setNClob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setNClob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setNClob");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(PreparedStatement.class, "setSQLXML");
    }
}

