/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Spring AI Vector Store
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SpringAiVectorStoreEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Spring AI Vector Store component.
     */
    public interface SpringAiVectorStoreEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSpringAiVectorStoreEndpointBuilder advanced() {
            return (AdvancedSpringAiVectorStoreEndpointBuilder) this;
        }

        /**
         * Filter expression for metadata-based filtering in searches.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param filterExpression the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder filterExpression(String filterExpression) {
            doSetProperty("filterExpression", filterExpression);
            return this;
        }
        /**
         * The operation to perform on the vector store (ADD, DELETE,
         * SIMILARITY_SEARCH).
         * 
         * The option is a:
         * <code>org.apache.camel.component.springai.vectorstore.SpringAiVectorStoreOperation</code> type.
         * 
         * Default: ADD
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder operation(org.apache.camel.component.springai.vectorstore.SpringAiVectorStoreOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform on the vector store (ADD, DELETE,
         * SIMILARITY_SEARCH).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.springai.vectorstore.SpringAiVectorStoreOperation</code> type.
         * 
         * Default: ADD
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The minimum similarity score threshold (0-1) for similarity search.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Default: 0.0
         * Group: producer
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder similarityThreshold(double similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * The minimum similarity score threshold (0-1) for similarity search.
         * 
         * The option will be converted to a <code>double</code> type.
         * 
         * Default: 0.0
         * Group: producer
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder similarityThreshold(String similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * The maximum number of similar documents to return for similarity
         * search.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5
         * Group: producer
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder topK(int topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * The maximum number of similar documents to return for similarity
         * search.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5
         * Group: producer
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder topK(String topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * The VectorStore to use for vector operations.
         * 
         * The option is a:
         * <code>org.springframework.ai.vectorstore.VectorStore</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param vectorStore the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder vectorStore(org.springframework.ai.vectorstore.VectorStore vectorStore) {
            doSetProperty("vectorStore", vectorStore);
            return this;
        }
        /**
         * The VectorStore to use for vector operations.
         * 
         * The option will be converted to a
         * <code>org.springframework.ai.vectorstore.VectorStore</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param vectorStore the value to set
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder vectorStore(String vectorStore) {
            doSetProperty("vectorStore", vectorStore);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Spring AI Vector Store component.
     */
    public interface AdvancedSpringAiVectorStoreEndpointBuilder
            extends
                EndpointProducerBuilder {
        default SpringAiVectorStoreEndpointBuilder basic() {
            return (SpringAiVectorStoreEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiVectorStoreEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiVectorStoreEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface SpringAiVectorStoreBuilders {
        /**
         * Spring AI Vector Store (camel-spring-ai-vector-store)
         * Spring AI Vector Store
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-vector-store
         * 
         * @return the dsl builder for the headers' name.
         */
        default SpringAiVectorStoreHeaderNameBuilder springAiVectorStore() {
            return SpringAiVectorStoreHeaderNameBuilder.INSTANCE;
        }
        /**
         * Spring AI Vector Store (camel-spring-ai-vector-store)
         * Spring AI Vector Store
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-vector-store
         * 
         * Syntax: <code>spring-ai-vector-store:storeId</code>
         * 
         * Path parameter: storeId (required)
         * The id
         * 
         * @param path storeId
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder springAiVectorStore(String path) {
            return SpringAiVectorStoreEndpointBuilderFactory.endpointBuilder("spring-ai-vector-store", path);
        }
        /**
         * Spring AI Vector Store (camel-spring-ai-vector-store)
         * Spring AI Vector Store
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-vector-store
         * 
         * Syntax: <code>spring-ai-vector-store:storeId</code>
         * 
         * Path parameter: storeId (required)
         * The id
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path storeId
         * @return the dsl builder
         */
        default SpringAiVectorStoreEndpointBuilder springAiVectorStore(String componentName, String path) {
            return SpringAiVectorStoreEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Spring AI Vector Store component.
     */
    public static class SpringAiVectorStoreHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SpringAiVectorStoreHeaderNameBuilder INSTANCE = new SpringAiVectorStoreHeaderNameBuilder();

        /**
         * The operation to perform (ADD, DELETE, SIMILARITY_SEARCH).
         * 
         * The option is a: {@code
         * org.apache.camel.component.springai.vectorstore.SpringAiVectorStoreOperation} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiVectorStoreOperation}.
         */
        public String springAiVectorStoreOperation() {
            return "CamelSpringAiVectorStoreOperation";
        }
        /**
         * The maximum number of similar documents to return (topK).
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiVectorStoreTopK}.
         */
        public String springAiVectorStoreTopK() {
            return "CamelSpringAiVectorStoreTopK";
        }
        /**
         * The similarity threshold (0-1).
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringAiVectorStoreSimilarityThreshold}.
         */
        public String springAiVectorStoreSimilarityThreshold() {
            return "CamelSpringAiVectorStoreSimilarityThreshold";
        }
        /**
         * Filter expression for metadata-based filtering.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringAiVectorStoreFilterExpression}.
         */
        public String springAiVectorStoreFilterExpression() {
            return "CamelSpringAiVectorStoreFilterExpression";
        }
        /**
         * List of document IDs (input for DELETE, output for ADD and
         * SIMILARITY_SEARCH).
         * 
         * The option is a: {@code java.util.List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringAiVectorStoreDocumentIds}.
         */
        public String springAiVectorStoreDocumentIds() {
            return "CamelSpringAiVectorStoreDocumentIds";
        }
        /**
         * List of similar documents found.
         * 
         * The option is a: {@code
         * java.util.List<org.springframework.ai.document.Document>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringAiVectorStoreSimilarDocuments}.
         */
        public String springAiVectorStoreSimilarDocuments() {
            return "CamelSpringAiVectorStoreSimilarDocuments";
        }
        /**
         * Number of documents added.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringAiVectorStoreDocumentsAdded}.
         */
        public String springAiVectorStoreDocumentsAdded() {
            return "CamelSpringAiVectorStoreDocumentsAdded";
        }
        /**
         * Number of documents deleted.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringAiVectorStoreDocumentsDeleted}.
         */
        public String springAiVectorStoreDocumentsDeleted() {
            return "CamelSpringAiVectorStoreDocumentsDeleted";
        }
    }
    static SpringAiVectorStoreEndpointBuilder endpointBuilder(String componentName, String path) {
        class SpringAiVectorStoreEndpointBuilderImpl extends AbstractEndpointBuilder implements SpringAiVectorStoreEndpointBuilder, AdvancedSpringAiVectorStoreEndpointBuilder {
            public SpringAiVectorStoreEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SpringAiVectorStoreEndpointBuilderImpl(path);
    }
}