/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class AtomicSafeInitializerTest
extends AbstractConcurrentInitializerTest<Object> {
    private AtomicSafeInitializerTestImpl initializer;

    AtomicSafeInitializerTest() {
    }

    @Override
    protected ConcurrentInitializer<Object> createInitializer() {
        return this.initializer;
    }

    @BeforeEach
    public void setUp() {
        this.initializer = new AtomicSafeInitializerTestImpl();
    }

    @Test
    void testGetThatReturnsNullFirstTime() throws ConcurrentException {
        AtomicSafeInitializer<Object> initializer = new AtomicSafeInitializer<Object>(){
            final AtomicBoolean firstRun = new AtomicBoolean(true);

            protected Object initialize() {
                if (this.firstRun.getAndSet(false)) {
                    return null;
                }
                return new Object();
            }
        };
        Assertions.assertNull((Object)initializer.get());
        Assertions.assertNull((Object)initializer.get());
    }

    @ParameterizedTest
    @ValueSource(classes={IOException.class, Exception.class, FileSystemException.class, ReflectiveOperationException.class, ConcurrentException.class})
    @Timeout(value=5L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SAME_THREAD)
    void testInitializerThrowsChecked(Class<Exception> throwableClass) throws ConcurrentException {
        String message = "Initializing";
        AtomicSafeInitializer asi = ((AtomicSafeInitializer.Builder)AtomicSafeInitializer.builder().setInitializer(() -> {
            throw (Exception)throwableClass.getConstructor(String.class).newInstance("Initializing");
        })).get();
        String expected = throwableClass.getSimpleName() + ": " + "Initializing";
        Assertions.assertEquals((Object)expected, (Object)ExceptionUtils.getRootCauseMessage((Throwable)Assertions.assertThrows(ConcurrentException.class, () -> ((AtomicSafeInitializer)asi).get())));
        Assertions.assertEquals((Object)expected, (Object)ExceptionUtils.getRootCauseMessage((Throwable)Assertions.assertThrows(ConcurrentException.class, () -> ((AtomicSafeInitializer)asi).get())));
    }

    @ParameterizedTest
    @ValueSource(classes={IllegalStateException.class, IllegalArgumentException.class, NullPointerException.class, RuntimeException.class})
    @Timeout(value=5L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SAME_THREAD)
    void testInitializerThrowsUnchecked(Class<Exception> throwableClass) throws ConcurrentException {
        String message = "Initializing";
        AtomicSafeInitializer asi = ((AtomicSafeInitializer.Builder)AtomicSafeInitializer.builder().setInitializer(() -> {
            throw (Exception)throwableClass.getConstructor(String.class).newInstance("Initializing");
        })).get();
        Assertions.assertEquals((Object)"Initializing", (Object)((Exception)Assertions.assertThrows(throwableClass, () -> ((AtomicSafeInitializer)asi).get())).getMessage());
        Assertions.assertEquals((Object)"Initializing", (Object)((Exception)Assertions.assertThrows(throwableClass, () -> ((AtomicSafeInitializer)asi).get())).getMessage());
    }

    @Test
    void testNumberOfInitializeInvocations() throws ConcurrentException, InterruptedException {
        this.testGetConcurrent();
        Assertions.assertEquals((int)1, (int)this.initializer.initCounter.get(), (String)"Wrong number of invocations");
    }

    private static final class AtomicSafeInitializerTestImpl
    extends AtomicSafeInitializer<Object> {
        final AtomicInteger initCounter = new AtomicInteger();

        private AtomicSafeInitializerTestImpl() {
        }

        protected Object initialize() {
            this.initCounter.incrementAndGet();
            return new Object();
        }
    }
}

