/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BasicThreadFactoryTest
extends AbstractLangTest {
    private static final String PATTERN = "testThread-%d";
    private BasicThreadFactory.Builder builder;

    BasicThreadFactoryTest() {
    }

    private void checkDaemonFlag(boolean flag) {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        Thread t = new Thread();
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).daemon(flag).build();
        Assertions.assertSame((Object)t, (Object)factory.newThread(r), (String)"Wrong thread");
        Assertions.assertEquals((Object)flag, (Object)t.isDaemon(), (String)"Wrong daemon flag");
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    private void checkFactoryDefaults(BasicThreadFactory factory) {
        Assertions.assertNull((Object)factory.getNamingPattern(), (String)"Got a naming pattern");
        Assertions.assertNull((Object)factory.getUncaughtExceptionHandler(), (String)"Got an exception handler");
        Assertions.assertNull((Object)factory.getPriority(), (String)"Got a priority");
        Assertions.assertNull((Object)factory.getDaemonFlag(), (String)"Got a daemon flag");
        Assertions.assertNotNull((Object)factory.getWrappedFactory(), (String)"No wrapped factory");
    }

    @BeforeEach
    public void setUp() {
        this.builder = BasicThreadFactory.builder();
    }

    @Test
    void testBuildDefaults() {
        BasicThreadFactory factory = this.builder.build();
        this.checkFactoryDefaults(factory);
    }

    @Test
    void testBuilderDaemon() {
        this.builder.daemon();
        Assertions.assertTrue((boolean)this.builder.build().getDaemonFlag());
    }

    @Test
    void testBuilderDaemonBoolean() {
        this.builder.daemon(true);
        Assertions.assertTrue((boolean)this.builder.build().getDaemonFlag());
        this.builder.daemon(false);
        Assertions.assertFalse((boolean)this.builder.build().getDaemonFlag());
    }

    @Test
    void testBuilderReset() {
        ThreadFactory wrappedFactory = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Thread.UncaughtExceptionHandler exHandler = (Thread.UncaughtExceptionHandler)EasyMock.createMock(Thread.UncaughtExceptionHandler.class);
        EasyMock.replay((Object[])new Object[]{wrappedFactory, exHandler});
        this.builder.namingPattern(PATTERN).daemon(true).priority(10).uncaughtExceptionHandler(exHandler).wrappedFactory(wrappedFactory);
        this.builder.reset();
        BasicThreadFactory factory = this.builder.build();
        this.checkFactoryDefaults(factory);
        Assertions.assertNotSame((Object)wrappedFactory, (Object)factory.getWrappedFactory(), (String)"Wrapped factory not reset");
        EasyMock.verify((Object[])new Object[]{wrappedFactory, exHandler});
    }

    @Test
    void testBuilderResetAfterBuild() {
        this.builder.wrappedFactory((ThreadFactory)EasyMock.createNiceMock(ThreadFactory.class)).namingPattern(PATTERN).daemon(true).build();
        this.checkFactoryDefaults(this.builder.build());
    }

    @Test
    void testBuildNamingPatternNull() {
        LangAssertions.assertNullPointerException(() -> this.builder.namingPattern(null));
    }

    @Test
    void testBuildUncaughtExceptionHandlerNull() {
        LangAssertions.assertNullPointerException(() -> this.builder.uncaughtExceptionHandler(null));
    }

    @Test
    void testBuildWrappedFactoryNull() {
        LangAssertions.assertNullPointerException(() -> this.builder.wrappedFactory(null));
    }

    @Test
    void testNewThreadDaemonFalse() {
        this.checkDaemonFlag(false);
    }

    @Test
    void testNewThreadDaemonTrue() {
        this.checkDaemonFlag(true);
    }

    @Test
    void testNewThreadExHandler() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        Thread.UncaughtExceptionHandler handler = (Thread.UncaughtExceptionHandler)EasyMock.createMock(Thread.UncaughtExceptionHandler.class);
        Thread t = new Thread();
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r, handler});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).uncaughtExceptionHandler(handler).build();
        Assertions.assertSame((Object)t, (Object)factory.newThread(r), (String)"Wrong thread");
        Assertions.assertEquals((Object)handler, (Object)t.getUncaughtExceptionHandler(), (String)"Wrong exception handler");
        EasyMock.verify((Object[])new Object[]{wrapped, r, handler});
    }

    @Test
    void testNewThreadNamingPattern() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        int count = 12;
        for (int i = 0; i < 12; ++i) {
            EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)new Thread());
        }
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).namingPattern(PATTERN).build();
        for (int i = 0; i < 12; ++i) {
            Thread t = factory.newThread(r);
            Assertions.assertEquals((Object)String.format(PATTERN, i + 1), (Object)t.getName(), (String)"Wrong thread name");
            Assertions.assertEquals((long)(i + 1), (long)factory.getThreadCount(), (String)"Wrong thread count");
        }
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    @Test
    void testNewThreadNoDaemonFlag() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r1 = (Runnable)EasyMock.createMock(Runnable.class);
        Runnable r2 = (Runnable)EasyMock.createMock(Runnable.class);
        Thread t1 = new Thread();
        Thread t2 = new Thread();
        t1.setDaemon(true);
        EasyMock.expect((Object)wrapped.newThread(r1)).andReturn((Object)t1);
        EasyMock.expect((Object)wrapped.newThread(r2)).andReturn((Object)t2);
        EasyMock.replay((Object[])new Object[]{wrapped, r1, r2});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).build();
        Assertions.assertSame((Object)t1, (Object)factory.newThread(r1), (String)"Wrong thread 1");
        Assertions.assertTrue((boolean)t1.isDaemon(), (String)"No daemon thread");
        Assertions.assertSame((Object)t2, (Object)factory.newThread(r2), (String)"Wrong thread 2");
        Assertions.assertFalse((boolean)t2.isDaemon(), (String)"A daemon thread");
        EasyMock.verify((Object[])new Object[]{wrapped, r1, r2});
    }

    @Test
    void testNewThreadNoExHandler() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        Thread.UncaughtExceptionHandler handler = (Thread.UncaughtExceptionHandler)EasyMock.createMock(Thread.UncaughtExceptionHandler.class);
        Thread t = new Thread();
        t.setUncaughtExceptionHandler(handler);
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r, handler});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).build();
        Assertions.assertSame((Object)t, (Object)factory.newThread(r), (String)"Wrong thread");
        Assertions.assertEquals((Object)handler, (Object)t.getUncaughtExceptionHandler(), (String)"Wrong exception handler");
        EasyMock.verify((Object[])new Object[]{wrapped, r, handler});
    }

    @Test
    void testNewThreadNoNamingPattern() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        String name = "unchangedThreadName";
        Thread t = new Thread("unchangedThreadName");
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).build();
        Assertions.assertSame((Object)t, (Object)factory.newThread(r), (String)"Wrong thread");
        Assertions.assertEquals((Object)"unchangedThreadName", (Object)t.getName(), (String)"Name was changed");
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    @Test
    void testNewThreadNoPriority() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        int orgPriority = 6;
        Thread t = new Thread();
        t.setPriority(6);
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).build();
        Assertions.assertSame((Object)t, (Object)factory.newThread(r), (String)"Wrong thread");
        Assertions.assertEquals((int)6, (int)t.getPriority(), (String)"Wrong priority");
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }

    @Test
    void testNewThreadPriority() {
        ThreadFactory wrapped = (ThreadFactory)EasyMock.createMock(ThreadFactory.class);
        Runnable r = (Runnable)EasyMock.createMock(Runnable.class);
        Thread t = new Thread();
        EasyMock.expect((Object)wrapped.newThread(r)).andReturn((Object)t);
        EasyMock.replay((Object[])new Object[]{wrapped, r});
        int priority = 6;
        BasicThreadFactory factory = this.builder.wrappedFactory(wrapped).priority(6).build();
        Assertions.assertSame((Object)t, (Object)factory.newThread(r), (String)"Wrong thread");
        Assertions.assertEquals((int)6, (int)t.getPriority(), (String)"Wrong priority");
        EasyMock.verify((Object[])new Object[]{wrapped, r});
    }
}

