/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.io.Util;

public final class IOUtil {
    public static void readWrite(InputStream remoteInput, OutputStream remoteOutput, InputStream localInput, OutputStream localOutput) {
        Thread reader = new Thread(() -> {
            try {
                int ch;
                while (!Thread.interrupted() && (ch = localInput.read()) != -1) {
                    remoteOutput.write(ch);
                    remoteOutput.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        Thread writer = new Thread(() -> {
            try {
                Util.copyStream(remoteInput, localOutput);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        });
        writer.setPriority(Thread.currentThread().getPriority() + 1);
        writer.start();
        reader.setDaemon(true);
        reader.start();
        try {
            writer.join();
            reader.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

