/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.unparsers.PrimUnparser;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import org.apache.daffodil.runtime1.processors.unparsers.Unparser;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class HexBinaryUnparserBase
implements ToBriefXMLImpl,
Processor,
Unparser,
PrimProcessor,
PrimUnparser {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HexBinaryUnparserBase.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private final ElementRuntimeData context;

    public HexBinaryUnparserBase(ElementRuntimeData context) {
        this.context = context;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public abstract long getLengthInBits(UState var1);

    @Override
    public void unparse(UState state) {
        boolean ret;
        long l;
        DISimple node = state.currentInfosetNode().asSimple();
        Object object = node.dataValue();
        byte[] value = DataValue$.MODULE$.getByteArray$extension(object);
        long valueLengthInBytes = value.length;
        if (valueLengthInBytes > (long)state.tunable().maxHexBinaryLengthInBytes()) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.context().schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "Length of xs:hexBinary exceeds maximum of %s bytes: %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)state.tunable().maxHexBinaryLengthInBytes()), BoxesRunTime.boxToLong((long)valueLengthInBytes)}));
        }
        long lengthInBits = this.getLengthInBits(state);
        long lengthInBytes = (lengthInBits + 7L) / 8L;
        if (valueLengthInBytes > lengthInBytes) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.context().schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "Length of xs:hexBinary exceeds calculated length of %s bits: %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(valueLengthInBytes * 8L)), BoxesRunTime.boxToLong((long)lengthInBits)}));
        }
        if (lengthInBytes > valueLengthInBytes) {
            l = valueLengthInBytes * 8L;
        } else {
            if (lengthInBytes != valueLengthInBytes) {
                throw Assert$.MODULE$.abort("Invariant broken: lengthInBytes.==(valueLengthInBytes)");
            }
            l = lengthInBits;
        }
        long bitsFromValueToPut = l;
        DirectOrBufferedDataOutputStream dos = state.getDataOutputStream();
        if (bitsFromValueToPut > 0L && !(ret = dos.putByteArray(value, bitsFromValueToPut, state, dos.putByteArray$default$4()))) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.context().schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "Failed to write %d hexBinary bits", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)bitsFromValueToPut)}));
        }
        long nFillBits = lengthInBits - bitsFromValueToPut;
        if (nFillBits > 0L) {
            boolean ret2 = dos.skip(nFillBits, state);
            if (!ret2) {
                throw UnparseError$.MODULE$.apply(Maybe$.MODULE$.Nope(), Maybe$One$.MODULE$.apply(state.currentLocation()), "Failed to skip %d bits.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)nFillBits)}));
            }
            return;
        }
    }
}

