/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import java.util.List;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.cpc.GetEstimateAndErrorBoundsUDF;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetEstimateAndErrorBoundsUDFTest {
    @Test
    public void nullSketch() {
        List result = new GetEstimateAndErrorBoundsUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        CpcSketch sketch = new CpcSketch(12);
        List result = new GetEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)0.0);
    }

    @Test
    public void nonEmptySketchDefaultParams() {
        CpcSketch sketch = new CpcSketch(12);
        sketch.update(1L);
        sketch.update(2L);
        List result = new GetEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void nonEmptySketchExplicitKappa() {
        CpcSketch sketch = new CpcSketch(12);
        sketch.update(1L);
        sketch.update(2L);
        List result = new GetEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.toByteArray()), 2);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void customSeed() {
        long seed = 123L;
        CpcSketch sketch = new CpcSketch(12, 123L);
        sketch.update(1L);
        sketch.update(2L);
        List result = new GetEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.toByteArray()), 1, 123L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }
}

