/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.runners.dataflow.util.CloudKnownType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CloudObject
extends GenericJson
implements Cloneable {
    @Key(value="@type")
    private String className;

    public static CloudObject fromSpec(Map<String, Object> spec) {
        CloudObject result = new CloudObject();
        result.putAll(spec);
        if (result.className == null) {
            throw new RuntimeException("Unable to create an SDK object from " + spec + ": Object class not specified (missing \"" + "@type" + "\" field)");
        }
        return result;
    }

    public static CloudObject forClass(Class<?> cls) {
        CloudObject result = new CloudObject();
        result.className = ((Class)Preconditions.checkNotNull(cls)).getName();
        return result;
    }

    public static CloudObject forClassName(String className) {
        CloudObject result = new CloudObject();
        result.className = (String)Preconditions.checkNotNull((Object)className);
        return result;
    }

    public static CloudObject forString(String value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.TEXT.getUri());
        result.put("value", value);
        return result;
    }

    public static CloudObject forBoolean(Boolean value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.BOOLEAN.getUri());
        result.put("value", value);
        return result;
    }

    public static CloudObject forInteger(Long value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.INTEGER.getUri());
        result.put("value", value);
        return result;
    }

    public static CloudObject forInteger(Integer value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.INTEGER.getUri());
        result.put("value", value);
        return result;
    }

    public static CloudObject forFloat(Float value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.FLOAT.getUri());
        result.put("value", value);
        return result;
    }

    public static CloudObject forFloat(Double value) {
        CloudObject result = CloudObject.forClassName(CloudKnownType.FLOAT.getUri());
        result.put("value", value);
        return result;
    }

    public static CloudObject forKnownType(Object value) {
        @Nullable CloudKnownType ty = CloudKnownType.forClass(value.getClass());
        if (ty == null) {
            throw new RuntimeException("Unable to represent value via the Dataflow API: " + value);
        }
        CloudObject result = CloudObject.forClassName(ty.getUri());
        result.put("value", value);
        return result;
    }

    private CloudObject() {
    }

    public String getClassName() {
        return this.className;
    }

    public CloudObject clone() {
        return (CloudObject)super.clone();
    }

    public boolean equals(@Nullable Object otherObject) {
        if (!(otherObject instanceof CloudObject)) {
            return false;
        }
        CloudObject other = (CloudObject)otherObject;
        return Objects.equals(this.className, other.className) && super.equals(otherObject);
    }

    public int hashCode() {
        return Objects.hash(this.className, super.hashCode());
    }
}

