/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.memgroupby;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.memgroupby.Aggregate;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupByData;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupByMeta;

public class MemoryGroupBy
extends BaseTransform<MemoryGroupByMeta, MemoryGroupByData> {
    private static final Class<?> PKG = MemoryGroupByMeta.class;
    private boolean allNullsAreZero = false;
    private boolean minNullIsValued = false;

    public MemoryGroupBy(TransformMeta transformMeta, MemoryGroupByMeta meta, MemoryGroupByData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (this.first) {
            if (r == null && !((MemoryGroupByMeta)this.meta).isAlwaysGivingBackOneRow()) {
                this.setOutputDone();
                return false;
            }
            String val = this.getVariable("HOP_AGGREGATION_ALL_NULLS_ARE_ZERO", "N");
            this.allNullsAreZero = ValueMetaBase.convertStringToBoolean((String)val);
            val = this.getVariable("HOP_AGGREGATION_MIN_NULL_IS_VALUED", "N");
            this.minNullIsValued = ValueMetaBase.convertStringToBoolean((String)val);
            ((MemoryGroupByData)this.data).inputRowMeta = this.getInputRowMeta();
            if (((MemoryGroupByData)this.data).inputRowMeta == null) {
                ((MemoryGroupByData)this.data).inputRowMeta = this.getPipelineMeta().getPrevTransformFields((IVariables)this, this.getTransformMeta());
            }
            ((MemoryGroupByData)this.data).outputRowMeta = ((MemoryGroupByData)this.data).inputRowMeta.clone();
            ((MemoryGroupByMeta)this.meta).getFields(((MemoryGroupByData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((MemoryGroupByData)this.data).subjectnrs = new int[((MemoryGroupByMeta)this.meta).getSubjectField().length];
            ((MemoryGroupByData)this.data).groupnrs = new int[((MemoryGroupByMeta)this.meta).getGroupField().length];
            if (r != null) {
                int i;
                for (i = 0; i < ((MemoryGroupByMeta)this.meta).getSubjectField().length; ++i) {
                    ((MemoryGroupByData)this.data).subjectnrs[i] = ((MemoryGroupByMeta)this.meta).getAggregateType()[i] == 16 ? 0 : ((MemoryGroupByData)this.data).inputRowMeta.indexOfValue(((MemoryGroupByMeta)this.meta).getSubjectField()[i]);
                    if (((MemoryGroupByData)this.data).subjectnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"MemoryGroupBy.Log.AggregateSubjectFieldCouldNotFound", (String[])new String[]{((MemoryGroupByMeta)this.meta).getSubjectField()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                for (i = 0; i < ((MemoryGroupByMeta)this.meta).getGroupField().length; ++i) {
                    ((MemoryGroupByData)this.data).groupnrs[i] = ((MemoryGroupByData)this.data).inputRowMeta.indexOfValue(((MemoryGroupByMeta)this.meta).getGroupField()[i]);
                    if (((MemoryGroupByData)this.data).groupnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"MemoryGroupBy.Log.GroupFieldCouldNotFound", (String[])new String[]{((MemoryGroupByMeta)this.meta).getGroupField()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            ((MemoryGroupByData)this.data).valueMetaInteger = new ValueMetaInteger("count");
            ((MemoryGroupByData)this.data).valueMetaNumber = new ValueMetaNumber("sum");
            this.initGroupMeta(((MemoryGroupByData)this.data).inputRowMeta);
        }
        if (this.first) {
            this.newAggregate(r, null);
            ((MemoryGroupByData)this.data).groupAggMeta = new RowMeta();
            ((MemoryGroupByData)this.data).groupAggMeta.addRowMeta(((MemoryGroupByData)this.data).groupMeta);
            ((MemoryGroupByData)this.data).groupAggMeta.addRowMeta(((MemoryGroupByData)this.data).aggMeta);
        }
        if (r == null) {
            this.handleLastOfGroup();
            this.setOutputDone();
            return false;
        }
        if (this.first || ((MemoryGroupByData)this.data).newBatch) {
            this.first = false;
            ((MemoryGroupByData)this.data).newBatch = false;
        }
        this.addToAggregate(r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MemoryGroupBy.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private void handleLastOfGroup() throws HopException {
        for (MemoryGroupByData.HashEntry entry : ((MemoryGroupByData)this.data).map.keySet()) {
            int i;
            Aggregate aggregate = ((MemoryGroupByData)this.data).map.get(entry);
            Object[] aggregateResult = this.getAggregateResult(aggregate);
            Object[] outputRowData = RowDataUtil.allocateRowData((int)((MemoryGroupByData)this.data).outputRowMeta.size());
            int index = 0;
            for (i = 0; i < ((MemoryGroupByData)this.data).groupMeta.size(); ++i) {
                outputRowData[index++] = ((MemoryGroupByData)this.data).groupMeta.getValueMeta(i).convertToNormalStorageType(entry.getGroupData()[i]);
            }
            for (i = 0; i < ((MemoryGroupByData)this.data).aggMeta.size(); ++i) {
                outputRowData[index++] = ((MemoryGroupByData)this.data).aggMeta.getValueMeta(i).convertToNormalStorageType(aggregateResult[i]);
            }
            this.putRow(((MemoryGroupByData)this.data).outputRowMeta, outputRowData);
        }
        if (((MemoryGroupByData)this.data).map.isEmpty() && ((MemoryGroupByMeta)this.meta).isAlwaysGivingBackOneRow()) {
            int i;
            Object[] outputRowData = RowDataUtil.allocateRowData((int)((MemoryGroupByData)this.data).outputRowMeta.size());
            int index = 0;
            for (i = 0; i < ((MemoryGroupByData)this.data).groupMeta.size(); ++i) {
                outputRowData[index++] = null;
            }
            for (i = 0; i < ((MemoryGroupByData)this.data).aggMeta.size(); ++i) {
                outputRowData[index++] = ((MemoryGroupByMeta)this.meta).getAggregateType()[i] == 7 || ((MemoryGroupByMeta)this.meta).getAggregateType()[i] == 16 || ((MemoryGroupByMeta)this.meta).getAggregateType()[i] == 15 ? Long.valueOf(0L) : null;
            }
            this.putRow(((MemoryGroupByData)this.data).outputRowMeta, outputRowData);
        }
    }

    void addToAggregate(Object[] r) throws HopException {
        Object[] groupData = new Object[((MemoryGroupByData)this.data).groupMeta.size()];
        for (int i = 0; i < ((MemoryGroupByData)this.data).groupnrs.length; ++i) {
            groupData[i] = r[((MemoryGroupByData)this.data).groupnrs[i]];
        }
        MemoryGroupByData.HashEntry entry = ((MemoryGroupByData)this.data).getHashEntry(groupData);
        Aggregate aggregate = ((MemoryGroupByData)this.data).map.get(entry);
        if (aggregate == null) {
            aggregate = new Aggregate();
            this.newAggregate(r, aggregate);
            ((MemoryGroupByData)this.data).map.put(entry, aggregate);
        }
        block18: for (int i = 0; i < ((MemoryGroupByData)this.data).subjectnrs.length; ++i) {
            Object subj = r[((MemoryGroupByData)this.data).subjectnrs[i]];
            IValueMeta subjMeta = ((MemoryGroupByData)this.data).inputRowMeta.getValueMeta(((MemoryGroupByData)this.data).subjectnrs[i]);
            Object value = aggregate.agg[i];
            IValueMeta valueMeta = ((MemoryGroupByData)this.data).aggMeta.getValueMeta(i);
            switch (((MemoryGroupByMeta)this.meta).getAggregateType()[i]) {
                case 1: {
                    aggregate.agg[i] = ValueDataUtil.sum((IValueMeta)valueMeta, (Object)value, (IValueMeta)subjMeta, (Object)subj);
                    continue block18;
                }
                case 2: {
                    if (subjMeta.isNull(subj)) continue block18;
                    aggregate.agg[i] = ValueDataUtil.sum((IValueMeta)valueMeta, (Object)value, (IValueMeta)subjMeta, (Object)subj);
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block18;
                }
                case 3: 
                case 4: {
                    if (subjMeta.isNull(subj)) continue block18;
                    ((List)aggregate.agg[i]).add(subjMeta.getNumber(subj));
                    continue block18;
                }
                case 13: {
                    if (aggregate.mean == null) {
                        aggregate.mean = new double[((MemoryGroupByMeta)this.meta).getSubjectField().length];
                    }
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    double n2 = aggregate.counts[i];
                    double x = subjMeta.getNumber(subj);
                    double sum = value == null ? Double.valueOf(0.0) : (Double)value;
                    double mean = aggregate.mean[i];
                    double delta = x - mean;
                    aggregate.mean[i] = mean;
                    aggregate.agg[i] = sum += delta * (x - (mean += delta / n2));
                    continue block18;
                }
                case 15: {
                    if (aggregate.distinctObjs == null) {
                        aggregate.distinctObjs = new Set[((MemoryGroupByMeta)this.meta).getSubjectField().length];
                    }
                    if (aggregate.distinctObjs[i] == null) {
                        aggregate.distinctObjs[i] = new TreeSet<Object>();
                    }
                    if (!subjMeta.isNull(subj)) {
                        Object obj = subjMeta.convertToNormalStorageType(subj);
                        if (obj instanceof byte[]) {
                            obj = new String((byte[])obj);
                        }
                        if (!aggregate.distinctObjs[i].contains(obj)) {
                            aggregate.distinctObjs[i].add(obj);
                        }
                    }
                    aggregate.counts[i] = aggregate.distinctObjs[i].size();
                    continue block18;
                }
                case 7: {
                    if (subjMeta.isNull(subj)) continue block18;
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block18;
                }
                case 16: {
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block18;
                }
                case 5: {
                    boolean subjIsNull = subjMeta.isNull(subj);
                    boolean valueIsNull = valueMeta.isNull(value);
                    if (this.minNullIsValued || !subjIsNull && !valueIsNull) {
                        aggregate.agg[i] = subjMeta.compare(subj, valueMeta, value) < 0 ? subj : value;
                        continue block18;
                    }
                    if (!valueIsNull || subjIsNull) continue block18;
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 6: {
                    if (subjMeta.compare(subj, valueMeta, value) <= 0) continue block18;
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 9: {
                    if (subjMeta.isNull(subj) || value != null) continue block18;
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 10: {
                    if (subjMeta.isNull(subj)) continue block18;
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 11: {
                    if (aggregate.counts[i] != 0L) continue block18;
                    aggregate.agg[i] = subj;
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block18;
                }
                case 12: {
                    aggregate.agg[i] = subj;
                    continue block18;
                }
                case 8: {
                    if (subj == null) continue block18;
                    StringBuilder sb = (StringBuilder)value;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block18;
                }
                case 14: {
                    StringBuilder sb;
                    if (subj == null) continue block18;
                    String separator = "";
                    if (!Utils.isEmpty((CharSequence)((MemoryGroupByMeta)this.meta).getValueField()[i])) {
                        separator = this.resolve(((MemoryGroupByMeta)this.meta).getValueField()[i]);
                    }
                    if ((sb = (StringBuilder)value).length() > 0) {
                        sb.append(separator);
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block18;
                }
            }
        }
    }

    void newAggregate(Object[] r, Aggregate aggregate) throws HopException {
        int i;
        if (aggregate == null) {
            ((MemoryGroupByData)this.data).aggMeta = new RowMeta();
        } else {
            aggregate.counts = new long[((MemoryGroupByData)this.data).subjectnrs.length];
            for (i = 0; i < aggregate.counts.length; ++i) {
                aggregate.counts[i] = 0L;
            }
            aggregate.distinctObjs = null;
            aggregate.agg = new Object[((MemoryGroupByData)this.data).subjectnrs.length];
            aggregate.mean = new double[((MemoryGroupByData)this.data).subjectnrs.length];
        }
        for (i = 0; i < ((MemoryGroupByData)this.data).subjectnrs.length; ++i) {
            IValueMeta subjMeta = ((MemoryGroupByData)this.data).inputRowMeta.getValueMeta(((MemoryGroupByData)this.data).subjectnrs[i]);
            Serializable v = null;
            IValueMeta vMeta = null;
            switch (((MemoryGroupByMeta)this.meta).getAggregateType()[i]) {
                case 3: 
                case 4: {
                    vMeta = new ValueMetaNumber(((MemoryGroupByMeta)this.meta).getAggregateField()[i]);
                    v = new ArrayList();
                    break;
                }
                case 13: {
                    vMeta = new ValueMetaNumber(((MemoryGroupByMeta)this.meta).getAggregateField()[i]);
                    break;
                }
                case 7: 
                case 15: 
                case 16: {
                    vMeta = new ValueMetaInteger(((MemoryGroupByMeta)this.meta).getAggregateField()[i]);
                    break;
                }
                case 1: 
                case 2: {
                    vMeta = subjMeta.isNumeric() ? subjMeta.clone() : new ValueMetaNumber();
                    vMeta.setName(((MemoryGroupByMeta)this.meta).getAggregateField()[i]);
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    vMeta = subjMeta.clone();
                    vMeta.setName(((MemoryGroupByMeta)this.meta).getAggregateField()[i]);
                    v = r == null ? null : r[((MemoryGroupByData)this.data).subjectnrs[i]];
                    break;
                }
                case 8: {
                    vMeta = new ValueMetaString(((MemoryGroupByMeta)this.meta).getAggregateField()[i]);
                    v = new StringBuilder();
                    break;
                }
                case 14: {
                    vMeta = new ValueMetaString(((MemoryGroupByMeta)this.meta).getAggregateField()[i]);
                    v = new StringBuilder();
                    break;
                }
                default: {
                    throw new HopException("Unknown data type for aggregation : " + ((MemoryGroupByMeta)this.meta).getAggregateField()[i]);
                }
            }
            if (((MemoryGroupByMeta)this.meta).getAggregateType()[i] != 7 && ((MemoryGroupByMeta)this.meta).getAggregateType()[i] != 15 && ((MemoryGroupByMeta)this.meta).getAggregateType()[i] != 16) {
                vMeta.setLength(subjMeta.getLength(), subjMeta.getPrecision());
            }
            if (aggregate == null) {
                ((MemoryGroupByData)this.data).aggMeta.addValueMeta(vMeta);
                continue;
            }
            aggregate.agg[i] = v;
        }
    }

    private void initGroupMeta(IRowMeta previousRowMeta) throws HopValueException {
        ((MemoryGroupByData)this.data).groupMeta = new RowMeta();
        ((MemoryGroupByData)this.data).entryMeta = new RowMeta();
        for (int i = 0; i < ((MemoryGroupByData)this.data).groupnrs.length; ++i) {
            IValueMeta valueMeta = previousRowMeta.getValueMeta(((MemoryGroupByData)this.data).groupnrs[i]);
            ((MemoryGroupByData)this.data).groupMeta.addValueMeta(valueMeta);
            IValueMeta normalMeta = valueMeta.clone();
            normalMeta.setStorageType(0);
        }
    }

    Object[] getAggregateResult(Aggregate aggregate) throws HopValueException {
        Object[] result = new Object[((MemoryGroupByData)this.data).subjectnrs.length];
        if (((MemoryGroupByData)this.data).subjectnrs != null) {
            for (int i = 0; i < ((MemoryGroupByData)this.data).subjectnrs.length; ++i) {
                Object ag = aggregate.agg[i];
                switch (((MemoryGroupByMeta)this.meta).getAggregateType()[i]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ag = ValueDataUtil.divide((IValueMeta)((MemoryGroupByData)this.data).aggMeta.getValueMeta(i), (Object)ag, (IValueMeta)new ValueMetaInteger("c"), (Object)aggregate.counts[i]);
                        break;
                    }
                    case 3: 
                    case 4: {
                        double percentile = 50.0;
                        if (((MemoryGroupByMeta)this.meta).getAggregateType()[i] == 4) {
                            percentile = Double.parseDouble(((MemoryGroupByMeta)this.meta).getValueField()[i]);
                        }
                        List valuesList = (List)aggregate.agg[i];
                        double[] values = new double[valuesList.size()];
                        for (int v = 0; v < values.length; ++v) {
                            values[v] = (Double)valuesList.get(v);
                        }
                        ag = new Percentile().evaluate(values, percentile);
                        break;
                    }
                    case 7: 
                    case 15: 
                    case 16: {
                        ag = aggregate.counts[i];
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 13: {
                        double sum = (Double)ag / (double)aggregate.counts[i];
                        ag = Math.sqrt(sum);
                        break;
                    }
                    case 8: 
                    case 14: {
                        ag = ((StringBuilder)ag).toString();
                        break;
                    }
                }
                if (ag == null && this.allNullsAreZero) {
                    IValueMeta vm = ((MemoryGroupByData)this.data).aggMeta.getValueMeta(i);
                    ag = ValueDataUtil.getZeroForValueMetaType((IValueMeta)vm);
                }
                result[i] = ag;
            }
        }
        return result;
    }

    public boolean init() {
        if (super.init()) {
            ((MemoryGroupByData)this.data).map = new HashMap(5000);
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        ((MemoryGroupByData)this.data).clear();
    }

    public void batchComplete() throws HopException {
        this.handleLastOfGroup();
        ((MemoryGroupByData)this.data).map.clear();
        ((MemoryGroupByData)this.data).newBatch = true;
    }

    void setAllNullsAreZero(boolean allNullsAreZero) {
        this.allNullsAreZero = allNullsAreZero;
    }

    void setMinNullIsValued(boolean minNullIsValued) {
        this.minNullIsValued = minNullIsValued;
    }
}

