/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SparkException;
import org.apache.spark.api.python.Converter;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A2Q\u0001B\u0003\u0001\u000b=AQ!\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005\n)BQ!\f\u0001\u0005B9\u0012qCS1wCR{wK]5uC\ndWmQ8om\u0016\u0014H/\u001a:\u000b\u0005\u00199\u0011A\u00029zi\"|gN\u0003\u0002\t\u0013\u0005\u0019\u0011\r]5\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c2\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB!q\u0003\u0007\u000e\u001e\u001b\u0005)\u0011BA\r\u0006\u0005%\u0019uN\u001c<feR,'\u000f\u0005\u0002\u00127%\u0011AD\u0005\u0002\u0004\u0003:L\bC\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\tIwN\u0003\u0002#\u0017\u00051\u0001.\u00193p_BL!\u0001J\u0010\u0003\u0011]\u0013\u0018\u000e^1cY\u0016\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002QA\u0011q\u0003A\u0001\u0012G>tg/\u001a:u)><&/\u001b;bE2,GCA\u000f,\u0011\u0015a#\u00011\u0001\u001b\u0003\ry'M[\u0001\bG>tg/\u001a:u)\tir\u0006C\u0003-\u0007\u0001\u0007!\u0004")
public class JavaToWritableConverter
implements Converter<Object, Writable> {
    private Writable convertToWritable(Object obj) {
        IntWritable intWritable;
        Object object = obj;
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            intWritable = new IntWritable(Predef$.MODULE$.Integer2int(n));
        } else if (object instanceof Double) {
            Double d = (Double)object;
            intWritable = new DoubleWritable(Predef$.MODULE$.Double2double(d));
        } else if (object instanceof Long) {
            Long l = (Long)object;
            intWritable = new LongWritable(Predef$.MODULE$.Long2long(l));
        } else if (object instanceof Float) {
            Float f = (Float)object;
            intWritable = new FloatWritable(Predef$.MODULE$.Float2float(f));
        } else if (object instanceof String) {
            String string = (String)object;
            intWritable = new Text(string);
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            intWritable = new BooleanWritable(Predef$.MODULE$.Boolean2boolean(bl));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            intWritable = new BytesWritable(byArray);
        } else if (object == null) {
            intWritable = NullWritable.get();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            MapWritable mapWritable = new MapWritable();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Writable writable = mapWritable.put(this.convertToWritable(k), this.convertToWritable(v));
                return writable;
            });
            intWritable = mapWritable;
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            ArrayWritable arrayWriteable = new ArrayWritable(Writable.class);
            arrayWriteable.set((Writable[])Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)x$2 -> this.convertToWritable(x$2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Writable.class))));
            intWritable = arrayWriteable;
        } else {
            throw new SparkException(new StringBuilder(28).append("Data of type ").append(object.getClass().getName()).append(" cannot be used").toString());
        }
        return intWritable;
    }

    @Override
    public Writable convert(Object obj) {
        Writable writable;
        Object object = obj;
        Writable writable2 = object instanceof Writable ? (writable = (Writable)object) : this.convertToWritable(object);
        return writable2;
    }
}

