/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.MigratableResolver;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.storage.FallbackStorage$;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005uc!\u0002\f\u0018\u0001]y\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bI\u0002A\u0011A\u001a\t\u000f]\u0002!\u0019!C\u0005q!1\u0011\t\u0001Q\u0001\neBqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004J\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019y\u0005\u0001)A\u0005\u0019\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006BB/\u0001A\u0003%!\u000bC\u0003_\u0001\u0011\u0005q\fC\u0003q\u0001\u0011\u0005\u0011o\u0002\u0004}/!\u0005\u0011$ \u0004\u0007-]A\t!\u0007@\t\u000bIrA\u0011A@\t\u0013\u0005\u0005aB1A\u0005\u0002\u0005\r\u0001\u0002CA\u0006\u001d\u0001\u0006I!!\u0002\t\u000f\u00055a\u0002\"\u0001\u0002\u0010!9\u0011\u0011\u0004\b\u0005\u0002\u0005m\u0001bBA\u0015\u001d\u0011%\u00111\u0006\u0005\b\u0003\u000brA\u0011AA$\u0005=1\u0015\r\u001c7cC\u000e\\7\u000b^8sC\u001e,'B\u0001\r\u001a\u0003\u001d\u0019Ho\u001c:bO\u0016T!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(U5\t\u0001F\u0003\u0002*3\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002,Q\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u00020a5\t\u0011$\u0003\u000223\tI1\u000b]1sW\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Q2\u0004CA\u001b\u0001\u001b\u00059\u0002\"\u0002\u0017\u0003\u0001\u0004q\u0013\u0001\u00044bY2\u0014\u0017mY6QCRDW#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014A\u00014t\u0015\tq4$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0001n\u0012A\u0001U1uQ\u0006ia-\u00197mE\u0006\u001c7\u000eU1uQ\u0002\n!\u0002[1e_>\u00048i\u001c8g+\u0005!\u0005CA#H\u001b\u00051%B\u0001\u0017>\u0013\tAeIA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\fQ\u0006$wn\u001c9D_:4\u0007%\u0001\ngC2d'-Y2l\r&dWmU=ti\u0016lW#\u0001'\u0011\u0005ij\u0015B\u0001(<\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\u0014M\u0006dGNY1dW\u001aKG.Z*zgR,W\u000eI\u0001\u0006CB\u0004\u0018\nZ\u000b\u0002%B\u00111K\u0017\b\u0003)b\u0003\"!\u0016\u0012\u000e\u0003YS!aV\u0017\u0002\rq\u0012xn\u001c;?\u0013\tI&%\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-#\u0003\u0019\t\u0007\u000f]%eA\u0005!1m\u001c9z)\r\u00017m\u001b\t\u0003C\u0005L!A\u0019\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006I.\u0001\r!Z\u0001\u0011g\",hM\u001a7f\u00052|7m[%oM>\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\r\u0002\u000fMDWO\u001a4mK&\u0011!n\u001a\u0002\u0011'\",hM\u001a7f\u00052|7m[%oM>DQ\u0001\\\u0006A\u00025\f!AY7\u0011\u0005Ur\u0017BA8\u0018\u00051\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0003\u0019)\u00070[:ugR\u0019!/\u001e>\u0011\u0005\u0005\u001a\u0018B\u0001;#\u0005\u001d\u0011un\u001c7fC:DQA\u001e\u0007A\u0002]\f\u0011b\u001d5vM\u001adW-\u00133\u0011\u0005\u0005B\u0018BA=#\u0005\rIe\u000e\u001e\u0005\u0006w2\u0001\rAU\u0001\tM&dWM\\1nK\u0006ya)\u00197mE\u0006\u001c7n\u0015;pe\u0006<W\r\u0005\u00026\u001dM\u0019a\u0002\t\u0014\u0015\u0003u\f\u0011DR!M\u0019\n\u000b5iS0C\u0019>\u001b5jX'B\u001d\u0006;UIU0J\tV\u0011\u0011Q\u0001\t\u0004k\u0005\u001d\u0011bAA\u0005/\tq!\t\\8dW6\u000bg.Y4fe&#\u0017A\u0007$B\u00192\u0013\u0015iQ&`\u00052{5iS0N\u0003:\u000bu)\u0012*`\u0013\u0012\u0003\u0013AE4fi\u001a\u000bG\u000e\u001c2bG.\u001cFo\u001c:bO\u0016$B!!\u0005\u0002\u0018A!\u0011%a\u00055\u0013\r\t)B\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b1\u0012\u0002\u0019\u0001\u0018\u00029I,w-[:uKJ\u0014En\\2l\u001b\u0006t\u0017mZ3s\u0013\u001atU-\u001a3fIR)\u0001-!\b\u0002(!9\u0011qD\nA\u0002\u0005\u0005\u0012AB7bgR,'\u000fE\u00026\u0003GI1!!\n\u0018\u0005I\u0011En\\2l\u001b\u0006t\u0017mZ3s\u001b\u0006\u001cH/\u001a:\t\u000b1\u001a\u0002\u0019\u0001\u0018\u0002#I,\u0007o\u001c:u\u00052|7m[*uCR,8\u000fF\u0004s\u0003[\t\t$a\u000f\t\r\u0005=B\u00031\u0001n\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u0011\u001d\t\u0019\u0004\u0006a\u0001\u0003k\tqA\u00197pG.LE\rE\u00026\u0003oI1!!\u000f\u0018\u0005\u001d\u0011En\\2l\u0013\u0012Dq!!\u0010\u0015\u0001\u0004\ty$\u0001\u0006eCR\fG*\u001a8hi\"\u00042!IA!\u0013\r\t\u0019E\t\u0002\u0005\u0019>tw-\u0001\u0003sK\u0006$GCBA%\u00033\nY\u0006\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\r\t,hMZ3s\u0015\r\t\u0019&G\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t9&!\u0014\u0003\u001b5\u000bg.Y4fI\n+hMZ3s\u0011\u0015aS\u00031\u0001/\u0011\u001d\t\u0019$\u0006a\u0001\u0003k\u0001")
public class FallbackStorage
implements Logging {
    private final Path fallbackPath;
    private final Configuration hadoopConf;
    private final FileSystem fallbackFileSystem;
    private final String appId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static ManagedBuffer read(SparkConf sparkConf, BlockId blockId) {
        return FallbackStorage$.MODULE$.read(sparkConf, blockId);
    }

    public static void registerBlockManagerIfNeeded(BlockManagerMaster blockManagerMaster, SparkConf sparkConf) {
        FallbackStorage$.MODULE$.registerBlockManagerIfNeeded(blockManagerMaster, sparkConf);
    }

    public static Option<FallbackStorage> getFallbackStorage(SparkConf sparkConf) {
        return FallbackStorage$.MODULE$.getFallbackStorage(sparkConf);
    }

    public static BlockManagerId FALLBACK_BLOCK_MANAGER_ID() {
        return FallbackStorage$.MODULE$.FALLBACK_BLOCK_MANAGER_ID();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Path fallbackPath() {
        return this.fallbackPath;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileSystem fallbackFileSystem() {
        return this.fallbackFileSystem;
    }

    private String appId() {
        return this.appId;
    }

    public void copy(ShuffleBlockInfo shuffleBlockInfo, BlockManager bm) {
        int shuffleId = shuffleBlockInfo.shuffleId();
        long mapId = shuffleBlockInfo.mapId();
        MigratableResolver migratableResolver = bm.migratableResolver();
        if (migratableResolver instanceof IndexShuffleBlockResolver) {
            BoxedUnit boxedUnit;
            IndexShuffleBlockResolver indexShuffleBlockResolver = (IndexShuffleBlockResolver)migratableResolver;
            File indexFile = indexShuffleBlockResolver.getIndexFile(shuffleId, mapId, indexShuffleBlockResolver.getIndexFile$default$3());
            if (indexFile.exists()) {
                this.fallbackFileSystem().copyFromLocalFile(new Path(indexFile.getAbsolutePath()), new Path(this.fallbackPath(), new StringBuilder(2).append(this.appId()).append("/").append(shuffleId).append("/").append(indexFile.getName()).toString()));
                File dataFile = indexShuffleBlockResolver.getDataFile(shuffleId, mapId);
                if (dataFile.exists()) {
                    this.fallbackFileSystem().copyFromLocalFile(new Path(dataFile.getAbsolutePath()), new Path(this.fallbackPath(), new StringBuilder(2).append(this.appId()).append("/").append(shuffleId).append("/").append(dataFile.getName()).toString()));
                }
                int reduceId = IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
                ShuffleIndexBlockId indexBlockId = new ShuffleIndexBlockId(shuffleId, mapId, reduceId);
                FallbackStorage$.MODULE$.org$apache$spark$storage$FallbackStorage$$reportBlockStatus(bm, indexBlockId, indexFile.length());
                if (dataFile.exists()) {
                    ShuffleDataBlockId dataBlockId = new ShuffleDataBlockId(shuffleId, mapId, reduceId);
                    FallbackStorage$.MODULE$.org$apache$spark$storage$FallbackStorage$$reportBlockStatus(bm, dataBlockId, dataFile.length());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Unsupported Resolver: ").append(migratableResolver.getClass().getName()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean exists(int shuffleId, String filename) {
        return this.fallbackFileSystem().exists(new Path(this.fallbackPath(), new StringBuilder(2).append(this.appId()).append("/").append(shuffleId).append("/").append(filename).toString()));
    }

    public FallbackStorage(SparkConf conf) {
        Logging.$init$(this);
        Predef$.MODULE$.require(conf.contains("spark.app.id"));
        Predef$.MODULE$.require(((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).isDefined());
        this.fallbackPath = new Path((String)((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).get());
        this.hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(conf);
        this.fallbackFileSystem = FileSystem.get((URI)this.fallbackPath().toUri(), (Configuration)this.hadoopConf());
        this.appId = conf.getAppId();
    }
}

