/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.valuemapper;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapper;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapperData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="ValueMapper.Injection.", groups={"VALUES"})
@Transform(id="ValueMapper", image="valuemapper.svg", name="i18n::ValueMapper.Name", description="i18n::ValueMapper.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::ValueMapperMeta.keyword"}, documentationUrl="/pipeline/transforms/valuemapper.html")
public class ValueMapperMeta
extends BaseTransformMeta<ValueMapper, ValueMapperData> {
    private static final Class<?> PKG = ValueMapperMeta.class;
    @Injection(name="FIELDNAME")
    private String fieldToUse;
    @Injection(name="TARGET_FIELDNAME")
    private String targetField;
    @Injection(name="NON_MATCH_DEFAULT")
    private String nonMatchDefault;
    @Injection(name="SOURCE", group="VALUES")
    private String[] sourceValue;
    @Injection(name="TARGET", group="VALUES")
    private String[] targetValue;

    public String[] getSourceValue() {
        return this.sourceValue;
    }

    public void setSourceValue(String[] fieldName) {
        this.sourceValue = fieldName;
    }

    public String[] getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String[] fieldValue) {
        this.targetValue = fieldValue;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int count) {
        this.sourceValue = new String[count];
        this.targetValue = new String[count];
    }

    public Object clone() {
        ValueMapperMeta retval = (ValueMapperMeta)((Object)super.clone());
        int count = this.sourceValue.length;
        retval.allocate(count);
        System.arraycopy(this.sourceValue, 0, retval.sourceValue, 0, count);
        System.arraycopy(this.targetValue, 0, retval.targetValue, 0, count);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.fieldToUse = XmlHandler.getTagValue((Node)transformNode, (String)"field_to_use");
            this.targetField = XmlHandler.getTagValue((Node)transformNode, (String)"target_field");
            this.nonMatchDefault = XmlHandler.getTagValue((Node)transformNode, (String)"non_match_default");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int count = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.sourceValue[i] = XmlHandler.getTagValue((Node)fnode, (String)"source_value");
                this.targetValue[i] = XmlHandler.getTagValue((Node)fnode, (String)"target_value");
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ValueMapperMeta.RuntimeError.UnableToReadXML.VALUEMAPPER0004", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.sourceValue[i] = "field" + i;
            this.targetValue[i] = "";
        }
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValueMetaString extra = null;
        if (!Utils.isEmpty((CharSequence)this.getTargetField())) {
            extra = new ValueMetaString(this.getTargetField());
            int maxlen = -1;
            for (int i = 0; i < this.targetValue.length; ++i) {
                if (this.targetValue[i] == null || this.targetValue[i].length() <= maxlen) continue;
                maxlen = this.targetValue[i].length();
            }
            if (this.nonMatchDefault != null && this.nonMatchDefault.length() > maxlen) {
                maxlen = this.nonMatchDefault.length();
            }
            extra.setLength(maxlen);
            extra.setOrigin(name);
            r.addValueMeta((IValueMeta)extra);
        } else if (!Utils.isEmpty((CharSequence)this.getFieldToUse())) {
            extra = r.searchValueMeta(this.getFieldToUse());
        }
        if (extra != null) {
            extra.setStorageType(0);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XmlHandler.addTagValue((String)"field_to_use", (String)this.fieldToUse));
        retval.append("    ").append(XmlHandler.addTagValue((String)"target_field", (String)this.targetField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"non_match_default", (String)this.nonMatchDefault));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.sourceValue.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"source_value", (String)this.sourceValue[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"target_value", (String)this.targetValue[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    private String getNullOrEmpty(String str) {
        return str == null ? "" : str;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.NotReceivingFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.ReceivingFieldsFromPreviousTransforms", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.NotReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getFieldToUse() {
        return this.fieldToUse;
    }

    public void setFieldToUse(String fieldToUse) {
        this.fieldToUse = fieldToUse;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getNonMatchDefault() {
        return this.nonMatchDefault;
    }

    public void setNonMatchDefault(String nonMatchDefault) {
        this.nonMatchDefault = nonMatchDefault;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.sourceValue == null ? -1 : this.sourceValue.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] rtn = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.targetValue});
        this.targetValue = rtn[0];
    }
}

