/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblerFn
extends DoFn<KV<HopRow, KV<HopRow, HopRow>>, HopRow> {
    private String outputRowMetaJson;
    private String leftKRowMetaJson;
    private String leftVRowMetaJson;
    private String rightVRowMetaJson;
    private String counterName;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(AssemblerFn.class);
    private transient IRowMeta outputRowMeta;
    private transient IRowMeta leftKRowMeta;
    private transient IRowMeta leftVRowMeta;
    private transient IRowMeta rightVRowMeta;
    private transient Counter initCounter;
    private transient Counter writtenCounter;
    private transient Counter errorCounter;

    public AssemblerFn() {
    }

    public AssemblerFn(String outputRowMetaJson, String leftKRowMetaJson, String leftVRowMetaJson, String rightVRowMetaJson, String counterName, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.outputRowMetaJson = outputRowMetaJson;
        this.leftKRowMetaJson = leftKRowMetaJson;
        this.leftVRowMetaJson = leftVRowMetaJson;
        this.rightVRowMetaJson = rightVRowMetaJson;
        this.counterName = counterName;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.writtenCounter = Metrics.counter((String)"written", (String)this.counterName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.counterName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            this.outputRowMeta = JsonRowMeta.fromJson(this.outputRowMetaJson);
            this.leftKRowMeta = JsonRowMeta.fromJson(this.leftKRowMetaJson);
            this.leftVRowMeta = JsonRowMeta.fromJson(this.leftVRowMetaJson);
            this.rightVRowMeta = JsonRowMeta.fromJson(this.rightVRowMetaJson);
            Metrics.counter((String)"init", (String)this.counterName).inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error initializing assembling rows", (Throwable)e);
            throw new RuntimeException("Error initializing assembling output KV<row, KV<row, row>>", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            int i;
            KV element = (KV)processContext.element();
            KV value = (KV)element.getValue();
            HopRow key = (HopRow)element.getKey();
            HopRow leftValue = (HopRow)value.getKey();
            HopRow rightValue = (HopRow)value.getValue();
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.outputRowMeta.size());
            int index = 0;
            if (leftValue.allNull()) {
                index += this.leftVRowMeta.size();
            } else {
                for (i = 0; i < this.leftVRowMeta.size(); ++i) {
                    outputRow[index++] = leftValue.getRow()[i];
                }
            }
            if (leftValue.allNull()) {
                index += this.leftKRowMeta.size();
            } else {
                for (i = 0; i < this.leftKRowMeta.size(); ++i) {
                    outputRow[index++] = key.getRow()[i];
                }
            }
            if (rightValue.allNull()) {
                index += this.leftKRowMeta.size();
            } else {
                for (i = 0; i < this.leftKRowMeta.size(); ++i) {
                    outputRow[index++] = key.getRow()[i];
                }
            }
            if (rightValue.allNull()) {
                index += this.rightVRowMeta.size();
            } else {
                for (i = 0; i < this.rightVRowMeta.size(); ++i) {
                    outputRow[index++] = rightValue.getRow()[i];
                }
            }
            processContext.output((Object)new HopRow(outputRow));
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error assembling rows", (Throwable)e);
            throw new RuntimeException("Error assembling output KV<row, KV<row, row>>", e);
        }
    }
}

