/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.beam.metadata.FieldDefinition;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="file-definition", name="Beam File Definition", description="Describes a file layout in a Beam pipeline", image="ui/images/folder.svg", documentationUrl="/metadata-types/beam-file-definition.html")
public class FileDefinition
extends HopMetadataBase
implements Serializable,
IHopMetadata {
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty
    private List<FieldDefinition> fieldDefinitions;
    @HopMetadataProperty
    private String separator;
    @HopMetadataProperty
    private String enclosure;

    public FileDefinition() {
        this.fieldDefinitions = new ArrayList<FieldDefinition>();
    }

    public FileDefinition(String name, String description, List<FieldDefinition> fieldDefinitions, String separator, String enclosure) {
        this.name = name;
        this.description = description;
        this.fieldDefinitions = fieldDefinitions;
        this.separator = separator;
        this.enclosure = enclosure;
    }

    public IRowMeta getRowMeta() throws HopPluginException {
        RowMeta rowMeta = new RowMeta();
        for (FieldDefinition fieldDefinition : this.fieldDefinitions) {
            rowMeta.addValueMeta(fieldDefinition.getValueMeta());
        }
        return rowMeta;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFieldDefinitions(List<FieldDefinition> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }
}

