/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.io;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamOutputTransform;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.FieldDefinition;
import org.apache.hop.beam.metadata.FileDefinition;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.io.BeamOutput;
import org.apache.hop.beam.transforms.io.BeamOutputData;
import org.apache.hop.beam.transforms.io.BeamOutputDialog;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="BeamOutput", image="beam-output.svg", name="Beam Output", description="Describes a Beam Output", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/beamoutput.html")
public class BeamOutputMeta
extends BaseTransformMeta<BeamOutput, BeamOutputData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="output_location")
    private String outputLocation;
    @HopMetadataProperty(key="file_description_name")
    private String fileDefinitionName;
    @HopMetadataProperty(key="file_prefix")
    private String filePrefix;
    @HopMetadataProperty(key="file_suffix")
    private String fileSuffix;
    @HopMetadataProperty
    private boolean windowed;

    public String getDialogClassName() {
        return BeamOutputDialog.class.getName();
    }

    public FileDefinition loadFileDefinition(IHopMetadataProvider metadataProvider) throws HopTransformException {
        FileDefinition fileDefinition;
        if (StringUtils.isEmpty((String)this.fileDefinitionName)) {
            throw new HopTransformException("No file description name provided");
        }
        try {
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(FileDefinition.class);
            fileDefinition = (FileDefinition)serializer.load(this.fileDefinitionName);
        }
        catch (Exception e) {
            throw new HopTransformException("Unable to load file description '" + this.fileDefinitionName + "' from the metadata", (Throwable)e);
        }
        return fileDefinition;
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        FileDefinition outputFileDefinition = StringUtils.isEmpty((String)this.fileDefinitionName) ? this.getDefaultFileDefinition() : this.loadFileDefinition(metadataProvider);
        this.addAllFieldsToEmptyFileDefinition(rowMeta, outputFileDefinition);
        if (rowMeta == null || rowMeta.isEmpty()) {
            throw new HopException("No output fields found in the file definition or from previous transforms");
        }
        BeamOutputTransform beamOutputTransform = new BeamOutputTransform(transformMeta.getName(), variables.resolve(this.outputLocation), variables.resolve(this.filePrefix), variables.resolve(this.fileSuffix), variables.resolve(outputFileDefinition.getSeparator()), variables.resolve(outputFileDefinition.getEnclosure()), this.windowed, JsonRowMeta.toJson(rowMeta), transformPluginClasses, xpPluginClasses);
        if (previousTransforms.size() > 1) {
            throw new HopException("Combining data from multiple transforms is not supported yet!");
        }
        TransformMeta previousTransform = previousTransforms.get(0);
        input.apply((PTransform)beamOutputTransform);
        log.logBasic("Handled transform (OUTPUT) : " + transformMeta.getName() + ", gets data from " + previousTransform.getName());
    }

    private FileDefinition getDefaultFileDefinition() {
        FileDefinition fileDefinition = new FileDefinition();
        fileDefinition.setName("Default");
        fileDefinition.setEnclosure("\"");
        fileDefinition.setSeparator(",");
        return fileDefinition;
    }

    private void addAllFieldsToEmptyFileDefinition(IRowMeta rowMeta, FileDefinition fileDefinition) {
        if (fileDefinition.getFieldDefinitions().isEmpty()) {
            for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
                fileDefinition.getFieldDefinitions().add(new FieldDefinition(valueMeta.getName(), valueMeta.getTypeDesc(), valueMeta.getLength(), valueMeta.getPrecision(), valueMeta.getConversionMask()));
            }
        }
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public String getFileDefinitionName() {
        return this.fileDefinitionName;
    }

    public void setFileDefinitionName(String fileDefinitionName) {
        this.fileDefinitionName = fileDefinitionName;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public void setWindowed(boolean windowed) {
        this.windowed = windowed;
    }
}

