/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfileName;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import com.google.bigtable.repackaged.com.google.common.base.VerifyException;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

public final class AppProfile {
    private final com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile proto;

    @InternalApi
    public static AppProfile fromProto(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile proto) {
        return new AppProfile(proto);
    }

    private AppProfile(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile proto) {
        Preconditions.checkNotNull(proto);
        Preconditions.checkArgument(proto.hasSingleClusterRouting() || proto.hasMultiClusterRoutingUseAny(), "AppProfile must have a routing policy");
        Preconditions.checkArgument(!proto.getName().isEmpty(), "AppProfile must have a name");
        this.proto = proto;
    }

    public RoutingPolicy getPolicy() {
        if (this.proto.hasMultiClusterRoutingUseAny()) {
            return MultiClusterRoutingPolicy.of(ImmutableSet.copyOf(this.proto.getMultiClusterRoutingUseAny().getClusterIdsList()));
        }
        if (this.proto.hasSingleClusterRouting()) {
            return new SingleClusterRoutingPolicy(this.proto.getSingleClusterRouting());
        }
        throw new VerifyException();
    }

    public String getId() {
        AppProfileName fullName = Verify.verifyNotNull(AppProfileName.parse(this.proto.getName()), "Name can never be null", new Object[0]);
        return fullName.getAppProfile();
    }

    public String getInstanceId() {
        AppProfileName fullName = Verify.verifyNotNull(AppProfileName.parse(this.proto.getName()), "Name can never be null", new Object[0]);
        return fullName.getInstance();
    }

    public String getDescription() {
        return this.proto.getDescription();
    }

    com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppProfile that = (AppProfile)o;
        return Objects.equal(this.proto, that.proto);
    }

    public int hashCode() {
        return Objects.hashCode(this.proto);
    }

    public static class MultiClusterRoutingPolicy
    implements RoutingPolicy {
        private final AppProfile.MultiClusterRoutingUseAny proto;

        public static MultiClusterRoutingPolicy of() {
            return new MultiClusterRoutingPolicy(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance());
        }

        public static MultiClusterRoutingPolicy of(String ... clusterIds) {
            return MultiClusterRoutingPolicy.of(ImmutableSet.copyOf(clusterIds));
        }

        public static MultiClusterRoutingPolicy of(Set<String> clusterIds) {
            return new MultiClusterRoutingPolicy(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds(clusterIds).build());
        }

        public Set<String> getClusterIds() {
            return ImmutableSet.copyOf(this.proto.getClusterIdsList());
        }

        private MultiClusterRoutingPolicy(AppProfile.MultiClusterRoutingUseAny proto) {
            this.proto = proto;
        }

        @InternalApi
        AppProfile.MultiClusterRoutingUseAny toProto() {
            return this.proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiClusterRoutingPolicy that = (MultiClusterRoutingPolicy)o;
            return Objects.equal(this.proto, that.proto);
        }

        public int hashCode() {
            return Objects.hashCode(this.proto);
        }
    }

    public static class SingleClusterRoutingPolicy
    implements RoutingPolicy {
        private final AppProfile.SingleClusterRouting proto;

        @InternalApi
        public static SingleClusterRoutingPolicy fromProto(AppProfile.SingleClusterRouting proto) {
            return new SingleClusterRoutingPolicy(proto);
        }

        public static SingleClusterRoutingPolicy of(String clusterId) {
            return SingleClusterRoutingPolicy.of(clusterId, false);
        }

        public static SingleClusterRoutingPolicy of(String clusterId, boolean allowTransactionWrites) {
            return SingleClusterRoutingPolicy.fromProto(AppProfile.SingleClusterRouting.newBuilder().setClusterId(clusterId).setAllowTransactionalWrites(allowTransactionWrites).build());
        }

        private SingleClusterRoutingPolicy(AppProfile.SingleClusterRouting proto) {
            this.proto = proto;
        }

        public String getClusterId() {
            return this.proto.getClusterId();
        }

        public boolean getAllowTransactionalWrites() {
            return this.proto.getAllowTransactionalWrites();
        }

        @InternalApi
        AppProfile.SingleClusterRouting toProto() {
            return this.proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleClusterRoutingPolicy that = (SingleClusterRoutingPolicy)o;
            return Objects.equal(this.proto, that.proto);
        }

        public int hashCode() {
            return Objects.hashCode(this.proto);
        }
    }

    public static interface RoutingPolicy {
    }
}

