/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ChannelPrimer;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.bigtable.v2.TableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

@BetaApi(value="Channel priming is not currently stable and might change in the future")
class BigtableChannelPrimer
implements ChannelPrimer {
    private static Logger LOG = Logger.getLogger(BigtableChannelPrimer.class.toString());
    static ByteString PRIMING_ROW_KEY = ByteString.copyFromUtf8("nonexistent-priming-row");
    private static Duration PRIME_REQUEST_TIMEOUT = Duration.ofSeconds(30L);
    private final EnhancedBigtableStubSettings settingsTemplate;
    private final List<String> tableIds;

    static BigtableChannelPrimer create(Credentials credentials, String projectId, String instanceId, String appProfileId, List<String> tableIds) {
        EnhancedBigtableStubSettings.Builder builder = (EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)EnhancedBigtableStubSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId).setAppProfileId(appProfileId).setCredentialsProvider(FixedCredentialsProvider.create(credentials))).setExecutorProvider(InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(1).build());
        builder.readRowSettings().setRetrySettings(builder.readRowSettings().getRetrySettings().toBuilder().setMaxAttempts(1).setJittered(false).setInitialRpcTimeout(PRIME_REQUEST_TIMEOUT).setMaxRpcTimeout(PRIME_REQUEST_TIMEOUT).setTotalTimeout(PRIME_REQUEST_TIMEOUT).build());
        return new BigtableChannelPrimer(builder.build(), tableIds);
    }

    private BigtableChannelPrimer(EnhancedBigtableStubSettings settingsTemplate, List<String> tableIds) {
        Preconditions.checkNotNull(settingsTemplate, "settingsTemplate can't be null");
        this.settingsTemplate = settingsTemplate;
        this.tableIds = ImmutableList.copyOf(tableIds);
    }

    @Override
    public void primeChannel(ManagedChannel managedChannel) {
        try {
            this.primeChannelUnsafe(managedChannel);
        }
        catch (IOException | RuntimeException e) {
            LOG.warning(String.format("Unexpected error while trying to prime a channel: %s", e.getMessage()));
        }
    }

    private void primeChannelUnsafe(ManagedChannel managedChannel) throws IOException {
        if (this.tableIds.isEmpty()) {
            this.waitForChannelReady(managedChannel);
        } else {
            this.sendPrimeRequests(managedChannel);
        }
    }

    private void waitForChannelReady(ManagedChannel managedChannel) {
        ConnectivityState connectivityState;
        for (int i = 0; i < 30 && (connectivityState = managedChannel.getState(true)) != ConnectivityState.READY; ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void sendPrimeRequests(ManagedChannel managedChannel) throws IOException {
        EnhancedBigtableStubSettings primingSettings = ((EnhancedBigtableStubSettings.Builder)this.settingsTemplate.toBuilder().setTransportChannelProvider(FixedTransportChannelProvider.create(GrpcTransportChannel.create(managedChannel)))).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create(primingSettings);){
            HashMap<String, ApiFuture<Row>> primeFutures = new HashMap<String, ApiFuture<Row>>();
            for (String string : this.tableIds) {
                ApiFuture<Row> f = stub.createReadRowsRawCallable(new DefaultRowAdapter()).first().futureCall(ReadRowsRequest.newBuilder().setTableName(TableName.format(primingSettings.getProjectId(), primingSettings.getInstanceId(), string)).setAppProfileId(primingSettings.getAppProfileId()).setRows(RowSet.newBuilder().addRowKeys(PRIMING_ROW_KEY).build()).setFilter(RowFilter.newBuilder().setBlockAllFilter(true).build()).setRowsLimit(1L).build());
                primeFutures.put(string, f);
            }
            for (Map.Entry entry : primeFutures.entrySet()) {
                try {
                    ((ApiFuture)entry.getValue()).get();
                }
                catch (Throwable e) {
                    if (e instanceof ExecutionException) {
                        e = e.getCause();
                    }
                    LOG.warning(String.format("Failed to prime channel for table: %s: %s", entry.getKey(), e.getMessage()));
                }
            }
        }
    }
}

