/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.reframing;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamController;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.reframing.IncompleteStreamException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.reframing.Reframer;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.math.IntMath;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@InternalApi
public class ReframingResponseObserver<InnerT, OuterT>
extends StateCheckingResponseObserver<InnerT> {
    private final AtomicInteger lock = new AtomicInteger();
    private final ResponseObserver<OuterT> outerResponseObserver;
    private final Reframer<OuterT, InnerT> reframer;
    private StreamController innerController;
    private boolean hasStarted;
    private boolean autoFlowControl = true;
    private final AtomicInteger numRequested = new AtomicInteger();
    private final AtomicReference<Throwable> cancellation = new AtomicReference();
    private volatile boolean awaitingInner;
    private final AtomicReference<InnerT> newItem = new AtomicReference();
    private Throwable error;
    private volatile boolean done;
    private boolean finished;

    public ReframingResponseObserver(ResponseObserver<OuterT> observer, Reframer<OuterT, InnerT> reframer) {
        this.outerResponseObserver = observer;
        this.reframer = reframer;
    }

    @Override
    protected void onStartImpl(StreamController controller) {
        this.innerController = controller;
        this.innerController.disableAutoInboundFlowControl();
        this.outerResponseObserver.onStart(new StreamController(){

            @Override
            public void disableAutoInboundFlowControl() {
                Preconditions.checkState(!ReframingResponseObserver.this.hasStarted, "Can't disable automatic flow control once the stream has started");
                ReframingResponseObserver.this.autoFlowControl = false;
                ReframingResponseObserver.this.numRequested.set(0);
            }

            @Override
            public void request(int count) {
                ReframingResponseObserver.this.onRequest(count);
            }

            @Override
            public void cancel() {
                ReframingResponseObserver.this.onCancel();
            }
        });
        this.hasStarted = true;
        if (this.autoFlowControl) {
            this.numRequested.set(Integer.MAX_VALUE);
            this.deliver();
        }
    }

    private void onRequest(int count) {
        int newValue;
        int current;
        Preconditions.checkState(!this.autoFlowControl, "Auto flow control enabled");
        Preconditions.checkArgument(count > 0, "Count must be > 0");
        do {
            if ((current = this.numRequested.get()) != Integer.MAX_VALUE) continue;
            return;
        } while (!this.numRequested.compareAndSet(current, newValue = IntMath.saturatedAdd(current, count)));
        this.deliver();
    }

    private void onCancel() {
        if (this.cancellation.compareAndSet(null, new CancellationException("User cancelled stream"))) {
            this.innerController.cancel();
        }
        this.deliver();
    }

    @Override
    protected void onResponseImpl(InnerT response) {
        IllegalStateException error = null;
        if (!this.awaitingInner || !this.newItem.compareAndSet(null, response)) {
            error = new IllegalStateException("Received unsolicited response from upstream.");
            this.cancellation.compareAndSet(null, error);
        }
        this.deliver();
        if (error != null) {
            throw error;
        }
    }

    @Override
    protected void onErrorImpl(Throwable t) {
        this.error = t;
        this.done = true;
        this.deliver();
    }

    @Override
    protected void onCompleteImpl() {
        this.done = true;
        this.deliver();
    }

    private void deliver() {
        block4: {
            try {
                this.deliverUnsafe();
            }
            catch (Throwable t) {
                try {
                    this.innerController.cancel();
                }
                catch (Throwable cancelError) {
                    t.addSuppressed(new IllegalStateException("Failed to cancel upstream while recovering from an unexpected error", cancelError));
                }
                if (this.finished) break block4;
                this.outerResponseObserver.onError(t);
            }
        }
    }

    private void deliverUnsafe() {
        if (this.lock.getAndIncrement() != 0) {
            return;
        }
        do {
            int delivered;
            this.lock.lazySet(1);
            this.pollUpstream();
            if (this.maybeFinish()) {
                return;
            }
            int demandSnapshot = this.numRequested.get();
            for (delivered = 0; delivered < demandSnapshot; ++delivered) {
                if (this.reframer.hasFullFrame()) {
                } else {
                    if (this.awaitingInner) break;
                    this.awaitingInner = true;
                    this.innerController.request(1);
                    break;
                }
                this.outerResponseObserver.onResponse(this.reframer.pop());
                if (!this.maybeFinish()) continue;
                return;
            }
            if (delivered == 0) continue;
            this.numRequested.addAndGet(-delivered);
        } while (this.lock.decrementAndGet() != 0);
    }

    private void pollUpstream() {
        if (!this.awaitingInner) {
            return;
        }
        boolean localDone = this.done;
        Object newUpstreamItem = this.newItem.getAndSet(null);
        if (newUpstreamItem != null) {
            this.reframer.push(newUpstreamItem);
            this.awaitingInner = false;
        } else if (localDone) {
            this.awaitingInner = false;
        }
    }

    private boolean maybeFinish() {
        Throwable localError = this.cancellation.get();
        if (localError != null) {
            this.finished = true;
            this.outerResponseObserver.onError(localError);
            return true;
        }
        if (this.done && !this.reframer.hasFullFrame() && !this.awaitingInner) {
            this.finished = true;
            if (this.error != null) {
                this.outerResponseObserver.onError(this.error);
            } else if (this.reframer.hasPartialFrame()) {
                this.outerResponseObserver.onError(new IncompleteStreamException());
            } else {
                this.outerResponseObserver.onComplete();
            }
            return true;
        }
        return false;
    }
}

