/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.implcore.tags;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.opencensus.common.Scope;
import com.google.bigtable.repackaged.io.opencensus.implcore.tags.CurrentTagMapUtils;
import com.google.bigtable.repackaged.io.opencensus.implcore.tags.TagMapImpl;
import com.google.bigtable.repackaged.io.opencensus.implcore.tags.TagValueWithMetadata;
import com.google.bigtable.repackaged.io.opencensus.tags.TagContextBuilder;
import com.google.bigtable.repackaged.io.opencensus.tags.TagKey;
import com.google.bigtable.repackaged.io.opencensus.tags.TagMetadata;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import java.util.HashMap;
import java.util.Map;

final class TagMapBuilderImpl
extends TagContextBuilder {
    private static final TagMetadata METADATA_UNLIMITED_PROPAGATION = TagMetadata.create(TagMetadata.TagTtl.UNLIMITED_PROPAGATION);
    private final Map<TagKey, TagValueWithMetadata> tags;

    TagMapBuilderImpl(Map<TagKey, TagValueWithMetadata> tags) {
        this.tags = new HashMap<TagKey, TagValueWithMetadata>(tags);
    }

    TagMapBuilderImpl() {
        this.tags = new HashMap<TagKey, TagValueWithMetadata>();
    }

    @Override
    public TagMapBuilderImpl put(TagKey key, TagValue value) {
        this.put(key, value, METADATA_UNLIMITED_PROPAGATION);
        return this;
    }

    @Override
    public TagContextBuilder put(TagKey key, TagValue value, TagMetadata tagMetadata) {
        TagValueWithMetadata valueWithMetadata = TagValueWithMetadata.create(Preconditions.checkNotNull(value, "value"), Preconditions.checkNotNull(tagMetadata, "tagMetadata"));
        this.tags.put(Preconditions.checkNotNull(key, "key"), valueWithMetadata);
        return this;
    }

    @Override
    public TagMapBuilderImpl remove(TagKey key) {
        this.tags.remove(Preconditions.checkNotNull(key, "key"));
        return this;
    }

    @Override
    public TagMapImpl build() {
        return new TagMapImpl(this.tags);
    }

    @Override
    public Scope buildScoped() {
        return CurrentTagMapUtils.withTagMap(this.build());
    }
}

