/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.metrics.export;

import com.google.bigtable.repackaged.io.opencensus.internal.Utils;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.AutoValue_Summary;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.AutoValue_Summary_Snapshot;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.AutoValue_Summary_Snapshot_ValueAtPercentile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Summary {
    Summary() {
    }

    public static Summary create(@Nullable Long count, @Nullable Double sum, Snapshot snapshot) {
        Summary.checkCountAndSum(count, sum);
        Utils.checkNotNull(snapshot, "snapshot");
        return new AutoValue_Summary(count, sum, snapshot);
    }

    @Nullable
    public abstract Long getCount();

    @Nullable
    public abstract Double getSum();

    public abstract Snapshot getSnapshot();

    private static void checkCountAndSum(@Nullable Long count, @Nullable Double sum) {
        Utils.checkArgument(count == null || count >= 0L, "count must be non-negative.");
        Utils.checkArgument(sum == null || sum >= 0.0, "sum must be non-negative.");
        if (count != null && count == 0L) {
            Utils.checkArgument(sum == null || sum == 0.0, "sum must be 0 if count is 0.");
        }
    }

    @Immutable
    public static abstract class Snapshot {
        @Nullable
        public abstract Long getCount();

        @Nullable
        public abstract Double getSum();

        public abstract List<ValueAtPercentile> getValueAtPercentiles();

        public static Snapshot create(@Nullable Long count, @Nullable Double sum, List<ValueAtPercentile> valueAtPercentiles) {
            Summary.checkCountAndSum(count, sum);
            Utils.checkListElementNotNull(Utils.checkNotNull(valueAtPercentiles, "valueAtPercentiles"), "valueAtPercentile");
            return new AutoValue_Summary_Snapshot(count, sum, Collections.unmodifiableList(new ArrayList<ValueAtPercentile>(valueAtPercentiles)));
        }

        @Immutable
        public static abstract class ValueAtPercentile {
            public abstract double getPercentile();

            public abstract double getValue();

            public static ValueAtPercentile create(double percentile, double value) {
                Utils.checkArgument(0.0 < percentile && percentile <= 100.0, "percentile must be in the interval (0.0, 100.0]");
                Utils.checkArgument(value >= 0.0, "value must be non-negative");
                return new AutoValue_Summary_Snapshot_ValueAtPercentile(percentile, value);
            }
        }
    }
}

