/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.threeten.bp.format;

import com.google.bigtable.repackaged.org.threeten.bp.DateTimeException;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;
import com.google.bigtable.repackaged.org.threeten.bp.ZoneId;
import com.google.bigtable.repackaged.org.threeten.bp.ZoneOffset;
import com.google.bigtable.repackaged.org.threeten.bp.chrono.ChronoLocalDate;
import com.google.bigtable.repackaged.org.threeten.bp.chrono.Chronology;
import com.google.bigtable.repackaged.org.threeten.bp.chrono.IsoChronology;
import com.google.bigtable.repackaged.org.threeten.bp.format.DateTimeFormatter;
import com.google.bigtable.repackaged.org.threeten.bp.format.DecimalStyle;
import com.google.bigtable.repackaged.org.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import com.google.bigtable.repackaged.org.threeten.bp.jdk8.Jdk8Methods;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.ChronoField;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.TemporalAccessor;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.TemporalField;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.TemporalQueries;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.TemporalQuery;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.ValueRange;
import java.util.Locale;

final class DateTimePrintContext {
    private TemporalAccessor temporal;
    private Locale locale;
    private DecimalStyle symbols;
    private int optional;

    DateTimePrintContext(TemporalAccessor temporal, DateTimeFormatter formatter) {
        this.temporal = DateTimePrintContext.adjust(temporal, formatter);
        this.locale = formatter.getLocale();
        this.symbols = formatter.getDecimalStyle();
    }

    DateTimePrintContext(TemporalAccessor temporal, Locale locale, DecimalStyle symbols) {
        this.temporal = temporal;
        this.locale = locale;
        this.symbols = symbols;
    }

    private static TemporalAccessor adjust(final TemporalAccessor temporal, DateTimeFormatter formatter) {
        ChronoLocalDate effectiveDate;
        ZoneId effectiveZone;
        Chronology overrideChrono = formatter.getChronology();
        ZoneId overrideZone = formatter.getZone();
        if (overrideChrono == null && overrideZone == null) {
            return temporal;
        }
        Chronology temporalChrono = temporal.query(TemporalQueries.chronology());
        ZoneId temporalZone = temporal.query(TemporalQueries.zoneId());
        if (Jdk8Methods.equals(temporalChrono, overrideChrono)) {
            overrideChrono = null;
        }
        if (Jdk8Methods.equals(temporalZone, overrideZone)) {
            overrideZone = null;
        }
        if (overrideChrono == null && overrideZone == null) {
            return temporal;
        }
        final Chronology effectiveChrono = overrideChrono != null ? overrideChrono : temporalChrono;
        ZoneId zoneId = effectiveZone = overrideZone != null ? overrideZone : temporalZone;
        if (overrideZone != null) {
            if (temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
                Chronology chrono = effectiveChrono != null ? effectiveChrono : IsoChronology.INSTANCE;
                return chrono.zonedDateTime(Instant.from(temporal), overrideZone);
            }
            ZoneId normalizedOffset = overrideZone.normalized();
            ZoneOffset temporalOffset = temporal.query(TemporalQueries.offset());
            if (normalizedOffset instanceof ZoneOffset && temporalOffset != null && !normalizedOffset.equals(temporalOffset)) {
                throw new DateTimeException("Invalid override zone for temporal: " + overrideZone + " " + temporal);
            }
        }
        if (overrideChrono != null) {
            if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
                effectiveDate = effectiveChrono.date(temporal);
            } else {
                if (overrideChrono != IsoChronology.INSTANCE || temporalChrono != null) {
                    for (ChronoField f : ChronoField.values()) {
                        if (!f.isDateBased() || !temporal.isSupported(f)) continue;
                        throw new DateTimeException("Invalid override chronology for temporal: " + overrideChrono + " " + temporal);
                    }
                }
                effectiveDate = null;
            }
        } else {
            effectiveDate = null;
        }
        return new DefaultInterfaceTemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField field) {
                if (effectiveDate != null && field.isDateBased()) {
                    return effectiveDate.isSupported(field);
                }
                return temporal.isSupported(field);
            }

            @Override
            public ValueRange range(TemporalField field) {
                if (effectiveDate != null && field.isDateBased()) {
                    return effectiveDate.range(field);
                }
                return temporal.range(field);
            }

            @Override
            public long getLong(TemporalField field) {
                if (effectiveDate != null && field.isDateBased()) {
                    return effectiveDate.getLong(field);
                }
                return temporal.getLong(field);
            }

            @Override
            public <R> R query(TemporalQuery<R> query) {
                if (query == TemporalQueries.chronology()) {
                    return (R)effectiveChrono;
                }
                if (query == TemporalQueries.zoneId()) {
                    return (R)effectiveZone;
                }
                if (query == TemporalQueries.precision()) {
                    return temporal.query(query);
                }
                return query.queryFrom(this);
            }
        };
    }

    TemporalAccessor getTemporal() {
        return this.temporal;
    }

    Locale getLocale() {
        return this.locale;
    }

    DecimalStyle getSymbols() {
        return this.symbols;
    }

    void startOptional() {
        ++this.optional;
    }

    void endOptional() {
        --this.optional;
    }

    <R> R getValue(TemporalQuery<R> query) {
        R result = this.temporal.query(query);
        if (result == null && this.optional == 0) {
            throw new DateTimeException("Unable to extract value: " + this.temporal.getClass());
        }
        return result;
    }

    Long getValue(TemporalField field) {
        try {
            return this.temporal.getLong(field);
        }
        catch (DateTimeException ex) {
            if (this.optional > 0) {
                return null;
            }
            throw ex;
        }
    }

    public String toString() {
        return this.temporal.toString();
    }

    void setDateTime(TemporalAccessor temporal) {
        Jdk8Methods.requireNonNull(temporal, "temporal");
        this.temporal = temporal;
    }

    void setLocale(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        this.locale = locale;
    }
}

