/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;

@InternalApi(value="For internal usage only")
public class QualifierFilterAdapter
extends TypedFilterAdapterBase<QualifierFilter> {
    private static final FilterSupportStatus SINGLE_FAMILY_REQUIRED = FilterSupportStatus.newNotSupported("QualifierFilter must have a single column family specified in the Scan when not using CompareOp.EQUAL.");
    private static final FilterSupportStatus UNSUPPORTED_COMPARABLE = FilterSupportStatus.newNotSupported("QualifierFilter must have a BinaryComparator with any CompareOp or a RegexStringComparator with a EQUAL COmpareOp.");

    @Override
    public Filters.Filter adapt(FilterAdapterContext context, QualifierFilter filter) throws IOException {
        if (filter.getComparator() instanceof RegexStringComparator) {
            return QualifierFilterAdapter.adaptRegexStringComparator(filter.getOperator(), (RegexStringComparator)filter.getComparator());
        }
        if (filter.getComparator() instanceof BinaryComparator) {
            return this.adaptBinaryComparator(context, filter.getOperator(), (BinaryComparator)filter.getComparator());
        }
        throw new IllegalStateException(String.format("Cannot adapt comparator %s", filter.getComparator().getClass().getCanonicalName()));
    }

    private Filters.Filter adaptBinaryComparator(FilterAdapterContext context, CompareFilter.CompareOp compareOp, BinaryComparator comparator) throws IOException {
        ByteString value = ByteString.copyFrom(comparator.getValue());
        switch (compareOp) {
            case LESS: {
                return (Filters.Filter)Filters.FILTERS.qualifier().rangeWithinFamily(FilterAdapterHelper.getSingleFamilyName(context)).endOpen(value);
            }
            case LESS_OR_EQUAL: {
                return (Filters.Filter)Filters.FILTERS.qualifier().rangeWithinFamily(FilterAdapterHelper.getSingleFamilyName(context)).endClosed(value);
            }
            case EQUAL: {
                return Filters.FILTERS.qualifier().regex(ReaderExpressionHelper.quoteRegularExpression(comparator.getValue()));
            }
            case NOT_EQUAL: {
                String familyName = FilterAdapterHelper.getSingleFamilyName(context);
                return Filters.FILTERS.interleave().filter((Filters.Filter)Filters.FILTERS.qualifier().rangeWithinFamily(familyName).endOpen(value)).filter((Filters.Filter)Filters.FILTERS.qualifier().rangeWithinFamily(familyName).startOpen(value));
            }
            case GREATER_OR_EQUAL: {
                return (Filters.Filter)Filters.FILTERS.qualifier().rangeWithinFamily(FilterAdapterHelper.getSingleFamilyName(context)).startClosed(value);
            }
            case GREATER: {
                return (Filters.Filter)Filters.FILTERS.qualifier().rangeWithinFamily(FilterAdapterHelper.getSingleFamilyName(context)).startOpen(value);
            }
            case NO_OP: {
                return Filters.FILTERS.block();
            }
        }
        throw new IllegalStateException(String.format("Cannot handle unknown compare op %s", compareOp));
    }

    private static Filters.Filter adaptRegexStringComparator(CompareFilter.CompareOp compareOp, RegexStringComparator comparator) {
        String pattern = FilterAdapterHelper.extractRegexPattern(comparator);
        switch (compareOp) {
            case EQUAL: {
                return Filters.FILTERS.qualifier().regex(pattern);
            }
            case NO_OP: {
                return Filters.FILTERS.pass();
            }
        }
        throw new IllegalStateException(String.format("Cannot adapt regex filter with compare op %s", compareOp));
    }

    private static boolean isRegexAndSupported(QualifierFilter filter) {
        return filter.getComparator() instanceof RegexStringComparator && CompareFilter.CompareOp.EQUAL.equals((Object)filter.getOperator());
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, QualifierFilter filter) {
        if (!CompareFilter.CompareOp.EQUAL.equals((Object)filter.getOperator()) && filter.getComparator() instanceof BinaryComparator && context.getScan().numFamilies() != 1) {
            return SINGLE_FAMILY_REQUIRED;
        }
        if (!(filter.getComparator() instanceof BinaryComparator) && !QualifierFilterAdapter.isRegexAndSupported(filter)) {
            return UNSUPPORTED_COMPARABLE;
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

