/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.util.ReflectionUtil;
import org.w3c.dom.Node;

public class XmlMetadataUtil {
    public static String serializeObjectToXml(Object object) throws HopException {
        Object xml = "";
        ArrayList<Field> fields = new ArrayList<Field>(ReflectionUtil.findAllFields(object.getClass()));
        Collections.sort(fields, Comparator.comparing(Field::getName));
        for (Field field : fields) {
            Class<?> fieldType;
            HopMetadataProperty property;
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isVolatile(field.getModifiers()) || (property = field.getAnnotation(HopMetadataProperty.class)) == null) continue;
            String groupKey = property.groupKey();
            String tag = property.key();
            if (StringUtils.isEmpty((String)tag)) {
                tag = field.getName();
            }
            boolean isBoolean = Boolean.class.equals(fieldType = field.getType()) || Boolean.TYPE.equals(fieldType);
            boolean isPassword = property.password();
            boolean storeWithCode = property.storeWithCode();
            Object value = ReflectionUtil.getFieldValue(object, field.getName(), isBoolean);
            if (value == null) continue;
            if (property.storeWithName()) {
                xml = (String)xml + XmlHandler.addTagValue(tag, ((IHopMetadata)value).getName());
                continue;
            }
            xml = (String)xml + XmlMetadataUtil.serializeObjectToXml(value, groupKey, tag, isPassword, storeWithCode);
        }
        return xml;
    }

    private static String serializeObjectToXml(Object value, String groupKey, String tag, boolean password, boolean storeWithCode) throws HopException {
        Object xml = "";
        if (value == null) {
            xml = (String)xml + XmlHandler.addTagValue(tag, (String)null);
        } else if (value instanceof String) {
            xml = password ? (String)xml + XmlHandler.addTagValue(tag, Encr.encryptPasswordIfNotUsingVariables((String)value)) : (String)xml + XmlHandler.addTagValue(tag, (String)value);
        } else if (value instanceof Boolean) {
            xml = (String)xml + XmlHandler.addTagValue(tag, (boolean)((Boolean)value));
        } else if (value instanceof Integer) {
            xml = (String)xml + XmlHandler.addTagValue(tag, (int)((Integer)value));
        } else if (value instanceof Long) {
            xml = (String)xml + XmlHandler.addTagValue(tag, (Long)value);
        } else if (value instanceof Date) {
            xml = (String)xml + XmlHandler.addTagValue(tag, (Date)value);
        } else if (value.getClass().isEnum()) {
            xml = storeWithCode ? (String)xml + XmlHandler.addTagValue(tag, ((IEnumHasCode)value).getCode()) : (String)xml + XmlHandler.addTagValue(tag, ((Enum)value).name());
        } else if (value instanceof List) {
            if (StringUtils.isNotEmpty((String)groupKey)) {
                xml = (String)xml + XmlHandler.openTag(groupKey) + Const.CR;
            }
            List listItems = (List)value;
            for (Object listItem : listItems) {
                xml = (String)xml + XmlMetadataUtil.serializeObjectToXml(listItem, groupKey, tag, password, storeWithCode);
            }
            if (StringUtils.isNotEmpty((String)groupKey)) {
                xml = (String)xml + XmlHandler.closeTag(groupKey) + Const.CR;
            }
        } else {
            xml = (String)xml + XmlHandler.openTag(tag) + Const.CR;
            xml = (String)xml + XmlMetadataUtil.serializeObjectToXml(value);
            xml = (String)xml + XmlHandler.closeTag(tag) + Const.CR;
        }
        return xml;
    }

    public static <T> T deSerializeFromXml(Node node, Class<? extends T> clazz, IHopMetadataProvider metadataProvider) throws HopXmlException {
        return XmlMetadataUtil.deSerializeFromXml(node, clazz, null, metadataProvider);
    }

    public static <T> T deSerializeFromXml(Node node, Class<? extends T> clazz, T object, IHopMetadataProvider metadataProvider) throws HopXmlException {
        if (object == null) {
            try {
                object = clazz.newInstance();
            }
            catch (Exception e) {
                throw new HopXmlException("Unable to create a new instance of class " + clazz.getName() + " while de-serializing XML: make sure you have a public empty constructor for this class.", e);
            }
        }
        Set<Field> fields = ReflectionUtil.findAllFields(clazz);
        for (Field field : fields) {
            HopMetadataProperty property;
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isVolatile(field.getModifiers()) || (property = field.getAnnotation(HopMetadataProperty.class)) == null) continue;
            String tag = property.key();
            String groupKey = property.groupKey();
            if (StringUtils.isEmpty((String)tag)) {
                tag = field.getName();
            }
            Class<?> fieldType = field.getType();
            boolean defaultBoolean = property.defaultBoolean();
            boolean storeWithName = property.storeWithName();
            boolean password = property.password();
            boolean storeWithCode = property.storeWithCode();
            Node tagNode = XmlHandler.getSubNode(node, tag);
            Node groupNode = StringUtils.isEmpty((String)groupKey) ? node : XmlHandler.getSubNode(node, groupKey);
            Object value = XmlMetadataUtil.deSerializeFromXml(fieldType, groupNode, tagNode, tag, field, defaultBoolean, storeWithName, metadataProvider, password, storeWithCode);
            try {
                if (value == null) continue;
                ReflectionUtil.setFieldValue(object, field.getName(), fieldType, value);
            }
            catch (HopException e) {
                throw new HopXmlException("Unable to set value " + value + " on field " + field.getName() + " in class " + fieldType.getName(), e);
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object deSerializeFromXml(Class<?> fieldType, Node groupNode, Node elementNode, String tag, Field field, boolean defaultBoolean, boolean storeWithName, IHopMetadataProvider metadataProvider, boolean password, boolean storeWithCode) throws HopXmlException {
        String elementString = XmlHandler.getNodeValue(elementNode);
        if (storeWithName) {
            if (StringUtils.isEmpty((String)elementString)) {
                return null;
            }
            try {
                return metadataProvider.getSerializer(fieldType).load(elementString);
            }
            catch (Exception e) {
                throw new HopXmlException("Unable to load reference by name '" + elementString + "' for type " + fieldType.getName() + ". Does this class implement IHopMetadata?", e);
            }
        }
        if (fieldType.equals(String.class)) {
            if (elementNode == null) return null;
            if (!password) return elementString;
            return Encr.decryptPasswordOptionallyEncrypted(elementString);
        }
        if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
            if (elementNode == null) return null;
            return Integer.valueOf(elementString);
        }
        if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
            if (elementNode == null) return null;
            return Long.valueOf(elementString);
        }
        if (fieldType.equals(Date.class)) {
            if (elementNode == null) return null;
            return XmlHandler.stringToDate(elementString);
        }
        if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
            if (elementNode == null) return defaultBoolean;
            return "y".equalsIgnoreCase(elementString) || "true".equalsIgnoreCase(elementString);
        }
        if (fieldType.isEnum()) {
            Class<?> enumerationClass = field.getType();
            if (!StringUtils.isNotEmpty((String)elementString)) return null;
            if (!storeWithCode) return Enum.valueOf(enumerationClass, elementString);
            try {
                IEnumHasCode[] values;
                for (IEnumHasCode value : values = (IEnumHasCode[])enumerationClass.getEnumConstants()) {
                    if (!value.getCode().equals(elementString)) continue;
                    return value;
                }
                return null;
            }
            catch (Exception e) {
                throw new HopXmlException("Unable to get values() of enumeration to look up code value " + elementString, e);
            }
        } else {
            if (!fieldType.equals(List.class)) return XmlMetadataUtil.deSerializeFromXml(elementNode, fieldType, metadataProvider);
            ArrayList<Object> list = new ArrayList<Object>();
            List<Node> itemNodes = XmlHandler.getNodes(groupNode, tag);
            for (Node itemNode : itemNodes) {
                ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                Class listClass = (Class)parameterizedType.getActualTypeArguments()[0];
                try {
                    Object newItem = XmlMetadataUtil.deSerializeFromXml(listClass, null, itemNode, null, null, false, false, metadataProvider, password, storeWithCode);
                    list.add(newItem);
                }
                catch (Exception e) {
                    throw new HopXmlException("Unable to instantiate a new instance of class " + listClass.getName() + ": make sure there is an empty public constructor available to allow XML de-serialization", e);
                }
            }
            return list;
        }
    }
}

