/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dorisbulkloader;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class RecordBuffer {
    private final BlockingQueue<ByteBuffer> writeQueue;
    private final BlockingQueue<ByteBuffer> readQueue;
    private ByteBuffer currentWriteBuffer;
    private ByteBuffer currentReadBuffer;
    private final int bufferSize;
    private final int bufferCount;
    private long writeLength = 0L;

    public RecordBuffer(int bufferSize, int bufferCount) {
        this.writeQueue = new ArrayBlockingQueue<ByteBuffer>(bufferCount);
        for (int index = 0; index < bufferCount; ++index) {
            this.writeQueue.add(ByteBuffer.allocate(bufferSize));
        }
        this.readQueue = new LinkedBlockingDeque<ByteBuffer>();
        this.bufferSize = bufferSize;
        this.bufferCount = bufferCount;
    }

    public long getWriteLength() {
        return this.writeLength;
    }

    public void startBufferData() {
        this.writeLength = 0L;
    }

    public void write(byte[] buf) throws InterruptedException {
        this.writeLength += (long)buf.length;
        int wPos = 0;
        do {
            if (this.currentWriteBuffer == null) {
                this.currentWriteBuffer = this.writeQueue.take();
            }
            int available = this.currentWriteBuffer.remaining();
            int nWrite = Math.min(available, buf.length - wPos);
            this.currentWriteBuffer.put(buf, wPos, nWrite);
            wPos += nWrite;
            if (this.currentWriteBuffer.remaining() != 0) continue;
            this.currentWriteBuffer.flip();
            this.readQueue.put(this.currentWriteBuffer);
            this.currentWriteBuffer = null;
        } while (wPos != buf.length);
    }

    public boolean canWrite(long writeLength) {
        return this.writeLength + writeLength <= (long)(this.bufferSize * this.bufferCount);
    }

    public int read(byte[] buf, int start, int length) throws InterruptedException {
        if (this.currentReadBuffer == null) {
            this.currentReadBuffer = this.readQueue.take();
        }
        int available = this.currentReadBuffer.remaining();
        int nRead = Math.min(available, length);
        this.currentReadBuffer.get(buf, start, nRead);
        if (this.currentReadBuffer.remaining() == 0) {
            this.recycleBuffer(this.currentReadBuffer);
            this.currentReadBuffer = null;
        }
        return nRead;
    }

    private void recycleBuffer(ByteBuffer buffer) throws InterruptedException {
        buffer.clear();
        this.writeQueue.put(buffer);
    }

    public void stopBufferData() throws InterruptedException {
        if (this.currentWriteBuffer != null) {
            this.currentWriteBuffer.flip();
            this.readQueue.put(this.currentWriteBuffer);
            this.currentWriteBuffer = null;
        }
    }

    public int getWriteQueueSize() {
        return this.writeQueue.size();
    }

    public int getReadQueueSize() {
        return this.readQueue.size();
    }

    public void clearRecordBuffer() throws InterruptedException {
        int readLen;
        byte[] buffer = new byte[4096];
        for (long remaining = this.writeLength; remaining > 0L && (readLen = this.read(buffer, 0, (int)Math.min(4096L, remaining))) != -1; remaining -= (long)readLen) {
        }
    }
}

