/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.tracing.ApiTracer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.threeten.bp.Duration;

class CompositeTracer
implements ApiTracer {
    private final List<ApiTracer> children;

    CompositeTracer(List<ApiTracer> children) {
        this.children = ImmutableList.copyOf(children);
    }

    public ApiTracer.Scope inScope() {
        final ArrayList<ApiTracer.Scope> childScopes = new ArrayList<ApiTracer.Scope>(this.children.size());
        for (ApiTracer child : this.children) {
            childScopes.add(child.inScope());
        }
        return new ApiTracer.Scope(){

            public void close() {
                for (ApiTracer.Scope childScope : childScopes) {
                    childScope.close();
                }
            }
        };
    }

    public void operationSucceeded() {
        for (ApiTracer child : this.children) {
            child.operationSucceeded();
        }
    }

    public void operationCancelled() {
        for (ApiTracer child : this.children) {
            child.operationCancelled();
        }
    }

    public void operationFailed(Throwable error) {
        for (ApiTracer child : this.children) {
            child.operationFailed(error);
        }
    }

    public void connectionSelected(String id) {
        for (ApiTracer child : this.children) {
            child.connectionSelected(id);
        }
    }

    public void attemptStarted(int attemptNumber) {
        for (ApiTracer child : this.children) {
            child.attemptStarted(attemptNumber);
        }
    }

    public void attemptSucceeded() {
        for (ApiTracer child : this.children) {
            child.attemptSucceeded();
        }
    }

    public void attemptCancelled() {
        for (ApiTracer child : this.children) {
            child.attemptCancelled();
        }
    }

    public void attemptFailed(Throwable error, Duration delay) {
        for (ApiTracer child : this.children) {
            child.attemptFailed(error, delay);
        }
    }

    public void attemptFailedRetriesExhausted(Throwable error) {
        for (ApiTracer child : this.children) {
            child.attemptFailedRetriesExhausted(error);
        }
    }

    public void attemptPermanentFailure(Throwable error) {
        for (ApiTracer child : this.children) {
            child.attemptPermanentFailure(error);
        }
    }

    public void lroStartFailed(Throwable error) {
        for (ApiTracer child : this.children) {
            child.lroStartFailed(error);
        }
    }

    public void lroStartSucceeded() {
        for (ApiTracer child : this.children) {
            child.lroStartSucceeded();
        }
    }

    public void responseReceived() {
        for (ApiTracer child : this.children) {
            child.responseReceived();
        }
    }

    public void requestSent() {
        for (ApiTracer child : this.children) {
            child.requestSent();
        }
    }

    public void batchRequestSent(long elementCount, long requestSize) {
        for (ApiTracer child : this.children) {
            child.batchRequestSent(elementCount, requestSize);
        }
    }
}

