/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class HashBasedRouterPolicy
extends AbstractRouterPolicy {
    @Override
    public void reinitialize(FederationPolicyInitializationContext federationPolicyContext) throws FederationPolicyInitializationException {
        FederationPolicyInitializationContextValidator.validate(federationPolicyContext, this.getClass().getCanonicalName());
        this.setPolicyContext(federationPolicyContext);
    }

    @Override
    public SubClusterId getHomeSubcluster(ApplicationSubmissionContext appSubmissionContext, List<SubClusterId> blackListSubClusters) throws YarnException {
        Map<SubClusterId, SubClusterInfo> activeSubclusters = this.getActiveSubclusters();
        FederationPolicyUtils.validateSubClusterAvailability(new ArrayList<SubClusterId>(activeSubclusters.keySet()), blackListSubClusters);
        if (blackListSubClusters != null) {
            for (SubClusterId scId : blackListSubClusters) {
                activeSubclusters.remove(scId);
            }
        }
        this.validate(appSubmissionContext);
        int chosenPosition = Math.abs(appSubmissionContext.getQueue().hashCode() % activeSubclusters.size());
        ArrayList<SubClusterId> list = new ArrayList<SubClusterId>(activeSubclusters.keySet());
        Collections.sort(list);
        return (SubClusterId)list.get(chosenPosition);
    }
}

