/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;

class DirectWriteViewVisitor
extends Pipeline.PipelineVisitor.Defaults {
    static final String DIRECT_WRITE_VIEW_URN = "beam:directrunner:transforms:write_view:v1";
    private Set<PCollectionView<?>> viewsToWrite;

    DirectWriteViewVisitor() {
    }

    @Override
    public void enterPipeline(Pipeline p) {
        this.viewsToWrite = new HashSet();
    }

    @Override
    public void leavePipeline(Pipeline p) {
        for (PCollectionView<?> view : this.viewsToWrite) {
            this.visitView(view);
        }
    }

    @Override
    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        if (node.getTransform() instanceof ParDo.MultiOutput) {
            ParDo.MultiOutput parDo = (ParDo.MultiOutput)node.getTransform();
            this.viewsToWrite.addAll(parDo.getSideInputs().values());
        }
    }

    private <ElemT, ViewT> void visitView(PCollectionView<ViewT> view) {
        PCollection<?> collectionToMaterialize = view.getPCollection();
        collectionToMaterialize.apply("GroupAndWriteView", new GroupAndWriteView(view));
    }

    static final class WriteView<ElemT, ViewT>
    extends PTransform<PCollection<Iterable<ElemT>>, PCollection<Iterable<ElemT>>> {
        private final PCollectionView<ViewT> view;

        WriteView(PCollectionView<ViewT> view) {
            this.view = view;
        }

        @Override
        public PCollection<Iterable<ElemT>> expand(PCollection<Iterable<ElemT>> input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), input.getWindowingStrategy(), input.isBounded(), input.getCoder());
        }

        public PCollectionView<ViewT> getView() {
            return this.view;
        }
    }

    private static class GroupAndWriteView<ElemT, ViewT>
    extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
        private final PCollectionView<ViewT> view;

        private GroupAndWriteView(PCollectionView<ViewT> view) {
            this.view = view;
        }

        @Override
        public PCollection<ElemT> expand(PCollection<ElemT> input) {
            ((PCollection)((PCollection)((PCollection)input.apply("Key by null", WithKeys.of((Void)null))).setCoder(KvCoder.of(VoidCoder.of(), input.getCoder())).apply("GBK", GroupByKey.create())).apply("Get values", Values.create())).apply("WriteView", new WriteView(this.view));
            return input;
        }
    }
}

