/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.coalesce;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.coalesce.CoalesceField;
import org.apache.hop.pipeline.transforms.coalesce.CoalesceMeta;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterOrderedListDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CoalesceDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = CoalesceMeta.class;
    private final CoalesceMeta input;
    private Button wEmptyStrings;
    private TableView wFields;
    private String[] fieldNames;

    public CoalesceDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (CoalesceMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CoalesceDialog.Shell.Title", (String[])new String[0]));
        this.shell.setMinimumSize(500, 300);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.props.setLook((Control)this.shell);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        wlTransformName.setLayoutData((Object)new FormDataBuilder().right(middle, -margin).result());
        this.props.setLook((Control)wlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.wTransformName.addListener(24, e -> this.input.setChanged());
        this.wTransformName.setLayoutData((Object)new FormDataBuilder().left((Control)wlTransformName, 0).top((Control)wlTransformName, 0, 0x1000000).right().result());
        this.props.setLook((Control)this.wTransformName);
        this.wEmptyStrings = new Button((Composite)this.shell, 32);
        this.wEmptyStrings.setText(BaseMessages.getString(PKG, (String)"CoalesceDialog.Shell.EmptyStringsAsNulls", (String[])new String[0]));
        this.wEmptyStrings.setLayoutData((Object)new FormDataBuilder().left((Control)this.wTransformName, 0).top((Control)this.wTransformName, margin * 2).result());
        this.wEmptyStrings.addListener(13, e -> this.input.setChanged());
        this.props.setLook((Control)this.wEmptyStrings);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"CoalesceDialog.Fields.Label", (String[])new String[0]));
        wlFields.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wEmptyStrings, margin * 2).result());
        this.props.setLook((Control)wlFields);
        SelectionAdapter pathSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterOrderedListDialog dialog = new EnterOrderedListDialog(CoalesceDialog.this.shell, 4096, CoalesceDialog.this.fieldNames);
                String fields = CoalesceDialog.this.wFields.getActiveTableItem().getText(CoalesceDialog.this.wFields.getActiveTableColumn());
                String[] elements = fields.split("\\s*,\\s*");
                dialog.addToSelection(elements);
                CharSequence[] result = dialog.open();
                if (result != null) {
                    CoalesceDialog.this.wFields.getActiveTableItem().setText(CoalesceDialog.this.wFields.getActiveTableColumn(), String.join((CharSequence)", ", result));
                }
            }
        };
        ColumnInfo[] columns = new ColumnInfo[4];
        columns[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CoalesceDialog.ColumnInfo.Name.Label", (String[])new String[0]), 1, false);
        columns[0].setToolTip(BaseMessages.getString(PKG, (String)"CoalesceDialog.ColumnInfo.Name.Tooltip", (String[])new String[0]));
        columns[0].setUsingVariables(true);
        columns[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CoalesceDialog.ColumnInfo.Type.Label", (String[])new String[0]), 2, ValueMetaBase.getTypes());
        columns[1].setToolTip(BaseMessages.getString(PKG, (String)"CoalesceDialog.ColumnInfo.Type.Tooltip", (String[])new String[0]));
        columns[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CoalesceDialog.ColumnInfo.RemoveInputFields.Label", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])});
        columns[2].setToolTip(BaseMessages.getString(PKG, (String)"CoalesceDialog.ColumnInfo.RemoveInputFields.Tooltip", (String[])new String[0]));
        columns[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CoalesceDialog.ColumnInfo.InputFields.Label", (String[])new String[0]), 6, false);
        columns[3].setToolTip(BaseMessages.getString(PKG, (String)"CoalesceDialog.ColumnInfo.InputFields.Tooltip", (String[])new String[0]));
        columns[3].setUsingVariables(true);
        columns[3].setTextVarButtonSelectionListener((SelectionListener)pathSelection);
        this.wFields = new TableView(this.getVariables(), (Composite)this.shell, 67588, columns, this.input.getFields().size(), e -> this.input.setChanged(), this.props);
        this.wFields.setLayoutData((Object)new FormDataBuilder().left().right(100, 0).top((Control)wlFields, 4).bottom((Control)this.wOk, margin * 2).result());
        this.wFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{3, 20, 10, 5, 52}));
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransformMeta transformMeta = CoalesceDialog.this.pipelineMeta.findTransform(CoalesceDialog.this.transformName);
                if (transformMeta != null) {
                    try {
                        IRowMeta row = CoalesceDialog.this.pipelineMeta.getPrevTransformFields(CoalesceDialog.this.variables, transformMeta);
                        CoalesceDialog.this.fieldNames = new String[row.size()];
                        for (int i = 0; i < row.size(); ++i) {
                            CoalesceDialog.this.fieldNames[i] = row.getValueMeta(i).getName();
                        }
                        Const.sortStrings((String[])CoalesceDialog.this.fieldNames);
                    }
                    catch (HopException e) {
                        CoalesceDialog.this.logError(BaseMessages.getString(PKG, (String)"CoalesceDialog.Log.UnableToFindInput", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wEmptyStrings.setSelection(this.input.isTreatEmptyStringsAsNulls());
        List<CoalesceField> coalesces = this.input.getFields();
        for (int i = 0; i < coalesces.size(); ++i) {
            CoalesceField coalesce = coalesces.get(i);
            TableItem item = this.wFields.getTable().getItem(i);
            item.setText(1, StringUtils.stripToEmpty((String)coalesce.getName()));
            item.setText(2, StringUtils.stripToEmpty((String)coalesce.getType()));
            item.setText(3, CoalesceDialog.getStringFromBoolean(coalesce.isRemoveFields()));
            item.setText(4, StringUtils.stripToEmpty((String)coalesce.getInputFields()));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setTreatEmptyStringsAsNulls(this.wEmptyStrings.getSelection());
        int count = this.wFields.nrNonEmpty();
        ArrayList<CoalesceField> coalesces = new ArrayList<CoalesceField>(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            CoalesceField coalesce = new CoalesceField();
            coalesce.setName(item.getText(1));
            coalesce.setType(item.getText(2));
            coalesce.setRemoveFields(CoalesceDialog.getBooleanFromString(item.getText(3)));
            coalesce.setInputFields(StringUtils.stripToNull((String)item.getText(4)));
            coalesces.add(coalesce);
        }
        this.input.setFields(coalesces);
        this.dispose();
    }

    private static boolean getBooleanFromString(String s) {
        if (Utils.isEmpty((CharSequence)s)) {
            return false;
        }
        return BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equals(s);
    }

    private static String getStringFromBoolean(boolean b) {
        return b ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
    }
}

