/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getserversequence;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getserversequence.GetServerSequence;
import org.apache.hop.pipeline.transforms.getserversequence.GetServerSequenceData;
import org.w3c.dom.Node;

@Transform(id="GetServerSequence", image="get-server-sequence.svg", name="i18n::GetServerSequence.Name", description="i18n::GetServerSequence.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::GetServerSequenceMeta.keyword"}, documentationUrl="/pipeline/transforms/getserversequence.html")
public class GetServerSequenceMeta
extends BaseTransformMeta<GetServerSequence, GetServerSequenceData> {
    private static final Class<?> PKG = GetServerSequenceMeta.class;
    private String valuename;
    private String hopServerName;
    private String sequenceName;
    private String increment;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.valuename = XmlHandler.getTagValue((Node)transformNode, (String)"valuename");
            this.hopServerName = XmlHandler.getTagValue((Node)transformNode, (String)"server");
            this.sequenceName = XmlHandler.getTagValue((Node)transformNode, (String)"seqname");
            this.increment = XmlHandler.getTagValue((Node)transformNode, (String)"increment");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"GetSequenceMeta.Exception.ErrorLoadingTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.valuename = "id";
        this.hopServerName = "";
        this.sequenceName = "Server Sequence Name -- To be configured";
        this.increment = "10000";
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaInteger v = new ValueMetaInteger(this.valuename);
        v.setOrigin(name);
        row.addValueMeta((IValueMeta)v);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("      ").append(XmlHandler.addTagValue((String)"valuename", (String)this.valuename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"server", (String)this.hopServerName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"seqname", (String)this.sequenceName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"increment", (String)this.increment));
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSequenceMeta.CheckResult.TransformIsReceving.Title", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSequenceMeta.CheckResult.NoInputReceived.Title", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getValuename() {
        return this.valuename;
    }

    public void setValuename(String valuename) {
        this.valuename = valuename;
    }

    public String getHopServerName() {
        return this.hopServerName;
    }

    public void setHopServerName(String hopServerName) {
        this.hopServerName = hopServerName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getIncrement() {
        return this.increment;
    }

    public void setIncrement(String increment) {
        this.increment = increment;
    }
}

