/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.widget.ComboVar;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public abstract class WidgetUtils {
    private WidgetUtils() {
    }

    public static void setFormLayout(Composite composite, int margin) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = margin;
        formLayout.marginHeight = margin;
        composite.setLayout((Layout)formLayout);
    }

    public static ComboVar createFieldDropDown(Composite parentComposite, PropsUi props, IVariables variables, BaseTransformMeta transformMeta, FormData formData) {
        PipelineMeta pipelineMeta = transformMeta.getParentTransformMeta().getParentPipelineMeta();
        ComboVar fieldDropDownCombo = new ComboVar(variables, parentComposite, 18436);
        props.setLook((Control)fieldDropDownCombo);
        fieldDropDownCombo.addModifyListener(e -> transformMeta.setChanged());
        fieldDropDownCombo.setLayoutData(formData);
        Listener focusListener = e -> {
            String current = fieldDropDownCombo.getText();
            fieldDropDownCombo.getCComboWidget().removeAll();
            fieldDropDownCombo.setText(current);
            try {
                IRowMeta rmi = pipelineMeta.getPrevTransformFields(variables, transformMeta.getParentTransformMeta().getName());
                List ls = rmi.getValueMetaList();
                for (Object l : ls) {
                    ValueMetaBase vmb = (ValueMetaBase)l;
                    fieldDropDownCombo.add(vmb.getName());
                }
            }
            catch (HopTransformException ex) {
                transformMeta.logDebug(ex.getMessage(), new Object[]{ex});
            }
        };
        fieldDropDownCombo.getCComboWidget().addListener(15, focusListener);
        return fieldDropDownCombo;
    }

    public static FormData formDataBelow(Control anchorControl, int width, int pixelsBetweenAnchor) {
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(0, 0);
        fdMessageField.top = new FormAttachment(anchorControl, pixelsBetweenAnchor);
        fdMessageField.right = new FormAttachment(0, width);
        return fdMessageField;
    }

    public static CTabFolder createTabFolder(Composite composite, FormData fd, String ... titles) {
        Composite container = new Composite(composite, 0);
        WidgetUtils.setFormLayout(container, 0);
        container.setLayoutData((Object)fd);
        CTabFolder tabFolder = new CTabFolder(container, 0);
        tabFolder.setLayoutData((Object)new FormDataBuilder().fullSize().result());
        for (String title : titles) {
            if (title.length() < 8) {
                title = StringUtils.rightPad((String)title, (int)8);
            }
            Composite tab = new Composite((Composite)tabFolder, 0);
            WidgetUtils.setFormLayout(tab, 10);
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setText(title);
            tabItem.setControl((Control)tab);
        }
        tabFolder.setSelection(0);
        return tabFolder;
    }

    public static FormData firstColumn(Control top) {
        return new FormDataBuilder().top(top, 10).percentWidth(47).result();
    }

    public static FormData secondColumn(Control top) {
        return new FormDataBuilder().top(top, 10).right().left(53, 0).result();
    }
}

