/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnterStringDialog
extends Dialog {
    private static final Class<?> PKG = EnterStringDialog.class;
    private Text wString;
    private TextVar wStringVar;
    private final IVariables variables;
    private boolean allowVariables;
    private Button wOk;
    private Shell shell;
    private String string;
    private String shellText;
    private String lineText;
    private PropsUi props = PropsUi.getInstance();
    private boolean mandatory;
    private char echoChar = '\u0000';

    public EnterStringDialog(Shell parent, String string, String shellText, String lineText) {
        this(parent, string, shellText, lineText, false, null);
    }

    public EnterStringDialog(Shell parent, String string, String shellText, String lineText, boolean allowVariables, IVariables variables) {
        super(parent, 0);
        this.string = string;
        this.shellText = shellText;
        this.lineText = lineText;
        this.allowVariables = allowVariables;
        this.variables = variables;
    }

    public String open() {
        Object lastControl;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 268503152);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.shell.setText(this.shellText);
        int margin = this.props.getMargin();
        Label wlString = new Label((Composite)this.shell, 0);
        wlString.setText(this.lineText);
        this.props.setLook((Control)wlString);
        FormData fdlString = new FormData();
        fdlString.left = new FormAttachment(0, 0);
        fdlString.top = new FormAttachment(0, margin);
        wlString.setLayoutData((Object)fdlString);
        if (this.allowVariables) {
            this.wStringVar = new TextVar(this.variables, (Composite)this.shell, 18436);
            this.wStringVar.setText(this.string);
            this.props.setLook((Control)this.wStringVar);
            lastControl = this.wStringVar;
        } else {
            this.wString = new Text((Composite)this.shell, 18436);
            this.wString.setText(this.string);
            this.props.setLook((Control)this.wString);
            lastControl = this.wString;
        }
        if (this.echoChar != '\u0000') {
            this.wString.setEchoChar(this.echoChar);
        }
        FormData fdString = new FormData();
        fdString.left = new FormAttachment(0, 0);
        fdString.top = new FormAttachment((Control)wlString, margin);
        fdString.right = new FormAttachment(100, -margin);
        if (this.allowVariables) {
            this.wStringVar.setLayoutData(fdString);
            this.wStringVar.addModifyListener(arg0 -> this.setFlags());
        } else {
            this.wString.setLayoutData((Object)fdString);
            this.wString.addModifyListener(arg0 -> this.setFlags());
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOk, wCancel}, margin, (Control)lastControl);
        this.wOk.addListener(13, e -> this.ok());
        wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.string;
    }

    protected void setFlags() {
        String string = this.allowVariables ? this.wStringVar.getText() : this.wString.getText();
        boolean enabled = !this.mandatory || !Utils.isEmpty((CharSequence)string);
        this.wOk.setEnabled(enabled);
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.allowVariables) {
            this.wStringVar.setText(Const.NVL((String)this.string, (String)""));
            this.wStringVar.selectAll();
        } else {
            this.wString.setText(Const.NVL((String)this.string, (String)""));
            this.wString.selectAll();
        }
        this.setFlags();
    }

    private void cancel() {
        this.string = null;
        this.dispose();
    }

    private void ok() {
        this.string = this.allowVariables ? this.wStringVar.getText() : this.wString.getText();
        this.dispose();
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char echoChar) {
        this.echoChar = echoChar;
    }
}

