/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.SwtUniversalImage;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginTypeListener;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaPluginType;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.ManagedColor;
import org.apache.hop.ui.core.gui.ManagedFont;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.hopgui.ISingletonProvider;
import org.apache.hop.ui.hopgui.ImplementationLoader;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class GuiResource {
    private static ILogChannel log = LogChannel.UI;
    private Display display;
    private double zoomFactor;
    private ManagedColor colorBackground;
    private ManagedColor colorGraph;
    private ManagedColor colorTab;
    private ManagedColor colorRed;
    private ManagedColor colorSuccessGreen;
    private ManagedColor colorBlueCustomGrid;
    private ManagedColor colorGreen;
    private ManagedColor colorBlue;
    private ManagedColor colorOrange;
    private ManagedColor colorYellow;
    private ManagedColor colorMagenta;
    private ManagedColor colorPurpule;
    private ManagedColor colorIndigo;
    private ManagedColor colorBlack;
    private ManagedColor colorGray;
    private ManagedColor colorDarkGray;
    private ManagedColor colorLightGray;
    private ManagedColor colorDemoGray;
    private ManagedColor colorWhite;
    private ManagedColor colorDirectory;
    private ManagedColor colorHop;
    private ManagedColor colorLight;
    private ManagedColor colorCream;
    private ManagedColor colorLightBlue;
    private ManagedColor colorCrystalText;
    private ManagedColor colorHopDefault;
    private ManagedColor colorHopTrue;
    private ManagedColor colorDeprecated;
    private ManagedFont fontGraph;
    private ManagedFont fontNote;
    private ManagedFont fontFixed;
    private ManagedFont fontMedium;
    private ManagedFont fontMediumBold;
    private ManagedFont fontLarge;
    private ManagedFont fontTiny;
    private ManagedFont fontSmall;
    private ManagedFont fontBold;
    private Map<String, SwtUniversalImage> imagesTransforms = new Hashtable<String, SwtUniversalImage>();
    private Map<String, SwtUniversalImage> imagesActions;
    private Map<String, Image> imagesValueMeta;
    private SwtUniversalImage imageLogo;
    private SwtUniversalImage imageDisabledHop;
    private SwtUniversalImage imageDatabase;
    private SwtUniversalImage imageData;
    private SwtUniversalImage imagePreview;
    private SwtUniversalImage imageMissing;
    private SwtUniversalImage imageDeprecated;
    private SwtUniversalImage imageVariable;
    private SwtUniversalImage imagePipeline;
    private SwtUniversalImage imagePartitionSchema;
    private SwtUniversalImage imageWorkflow;
    private SwtUniversalImage imageArrowDefault;
    private SwtUniversalImage imageArrowTrue;
    private SwtUniversalImage imageArrowFalse;
    private SwtUniversalImage imageArrowError;
    private SwtUniversalImage imageArrowDisabled;
    private SwtUniversalImage imageArrowCandidate;
    private SwtUniversalImage imageBol;
    private SwtUniversalImage imageServer;
    private SwtUniversalImage imageArrow;
    private SwtUniversalImage imageFolder;
    private SwtUniversalImage imageFile;
    private SwtUniversalImage imageFolderConnections;
    private SwtUniversalImage imageEdit;
    private SwtUniversalImage imageClearText;
    private SwtUniversalImage imageCopyRows;
    private SwtUniversalImage imageCopyRowsDisabled;
    private SwtUniversalImage imageFailure;
    private SwtUniversalImage imageSuccess;
    private SwtUniversalImage imageError;
    private SwtUniversalImage imageErrorDisabled;
    private SwtUniversalImage imageInfo;
    private SwtUniversalImage imageInfoDisabled;
    private SwtUniversalImage imageWarning;
    private SwtUniversalImage imageInput;
    private SwtUniversalImage imageOutput;
    private SwtUniversalImage imageTarget;
    private SwtUniversalImage imageTargetDisabled;
    private SwtUniversalImage imageLocked;
    private SwtUniversalImage imageTrue;
    private SwtUniversalImage imageTrueDisabled;
    private SwtUniversalImage imageFalse;
    private SwtUniversalImage imageFalseDisabled;
    private SwtUniversalImage imageContextMenu;
    private SwtUniversalImage imageUnconditional;
    private SwtUniversalImage imageUnconditionalDisabled;
    private SwtUniversalImage imageParallel;
    private SwtUniversalImage imageParallelDisabled;
    private SwtUniversalImage imageBusy;
    private SwtUniversalImage imageInject;
    private SwtUniversalImage imageBalance;
    private SwtUniversalImage imageCheckpoint;
    private Image imageEmpty;
    private Image imageExpandAll;
    private Image imageCollapseAll;
    private Image imageAdd;
    private Image imageCopy;
    private Image imageCancel;
    private Image imageCut;
    private Image imageDuplicate;
    private Image imagePaste;
    private Image imageTable;
    private Image imageSchema;
    private Image imageSynonym;
    private Image imageView;
    private Image imageCalendar;
    private Image imageLabel;
    private Image imageFunction;
    private Image imageUser;
    private Image imageEditOption;
    private Image imageColor;
    private Image imageNote;
    private Image imageResetOption;
    private Image imageShowLog;
    private Image imageShowGrid;
    private Image imageShowHistory;
    private Image imageShowPerf;
    private Image imageShow;
    private Image imageHide;
    private Image imageShowSelected;
    private Image imageShowAll;
    private Image imageClosePanel;
    private Image imageMaximizePanel;
    private Image imageMinimizePanel;
    private Image imageShowErrorLines;
    private Image imageShowResults;
    private Image imageHideResults;
    private Image imageSearch;
    private Image imageRegEx;
    private Image imageAddAll;
    private Image imageAddSingle;
    private Image imageRemoveAll;
    private Image imageRemoveSingle;
    private Image imageNavigateBack;
    private Image imageNavigateForward;
    private Image imageNavigateUp;
    private Image imageRefresh;
    private Image imageHome;
    private Image imagePrint;
    private Image imageHelp;
    private Image imageClose;
    private Image imageDelete;
    private Image imagePause;
    private Image imageRun;
    private Image imageStop;
    private Image imageNew;
    private Image imageDown;
    private Image imageUp;
    private Map<String, Image> imageMap;
    private Map<RGB, Color> colorMap;
    private Clipboard clipboard;
    private static final ISingletonProvider PROVIDER = (ISingletonProvider)ImplementationLoader.newInstance(GuiResource.class);

    protected GuiResource() {
        this(Display.getCurrent());
    }

    private GuiResource(Display display) {
        this.display = display;
        this.getResources();
        display.addListener(12, event -> this.dispose(false));
        this.clipboard = null;
        PluginRegistry.getInstance().addPluginListener(TransformPluginType.class, new IPluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                GuiResource.this.loadTransformImages();
            }

            public void pluginRemoved(Object serviceObject) {
                GuiResource.this.loadTransformImages();
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
        PluginRegistry.getInstance().addPluginListener(ActionPluginType.class, new IPluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                GuiResource.this.loadWorkflowActionImages();
            }

            public void pluginRemoved(Object serviceObject) {
                GuiResource.this.loadWorkflowActionImages();
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
    }

    public static final GuiResource getInstance() {
        return (GuiResource)PROVIDER.getInstanceInternal();
    }

    public void reload() {
        this.dispose(true);
        this.getResources();
    }

    private void getResources() {
        PropsUi props = PropsUi.getInstance();
        this.zoomFactor = props.getZoomFactor();
        this.imageMap = new HashMap<String, Image>();
        this.colorMap = new HashMap<RGB, Color>();
        this.colorBackground = new ManagedColor(this.display, props.contrastColor(new RGB(240, 240, 240)));
        this.colorGraph = new ManagedColor(this.display, props.contrastColor(new RGB(255, 255, 255)));
        this.colorTab = new ManagedColor(this.display, props.contrastColor(new RGB(128, 128, 128)));
        this.colorSuccessGreen = new ManagedColor(this.display, props.contrastColor(0, 139, 0));
        this.colorRed = new ManagedColor(this.display, props.contrastColor(255, 0, 0));
        this.colorGreen = new ManagedColor(this.display, props.contrastColor(0, 255, 0));
        this.colorBlue = new ManagedColor(this.display, props.contrastColor(0, 0, 255));
        this.colorYellow = new ManagedColor(this.display, props.contrastColor(255, 255, 0));
        this.colorMagenta = new ManagedColor(this.display, props.contrastColor(255, 0, 255));
        this.colorPurpule = new ManagedColor(this.display, props.contrastColor(128, 0, 128));
        this.colorIndigo = new ManagedColor(this.display, props.contrastColor(75, 0, 130));
        this.colorOrange = new ManagedColor(this.display, props.contrastColor(255, 165, 0));
        this.colorBlueCustomGrid = new ManagedColor(this.display, props.contrastColor(240, 248, 255));
        this.colorWhite = new ManagedColor(this.display, props.contrastColor(254, 254, 254));
        this.colorDemoGray = new ManagedColor(this.display, props.contrastColor(240, 240, 240));
        this.colorLightGray = new ManagedColor(this.display, props.contrastColor(225, 225, 225));
        this.colorGray = new ManagedColor(this.display, props.contrastColor(215, 215, 215));
        this.colorDarkGray = new ManagedColor(this.display, props.contrastColor(100, 100, 100));
        this.colorBlack = new ManagedColor(this.display, props.contrastColor(0, 0, 0));
        this.colorLightBlue = new ManagedColor(this.display, props.contrastColor(135, 206, 250));
        this.colorDirectory = new ManagedColor(this.display, props.contrastColor(0, 0, 255));
        this.colorHop = new ManagedColor(this.display, props.contrastColor(188, 198, 82));
        this.colorLight = new ManagedColor(this.display, props.contrastColor(238, 248, 152));
        this.colorCream = new ManagedColor(this.display, props.contrastColor(248, 246, 231));
        this.colorCrystalText = new ManagedColor(this.display, props.contrastColor(61, 99, 128));
        this.colorHopDefault = new ManagedColor(this.display, props.contrastColor(61, 99, 128));
        this.colorHopTrue = new ManagedColor(this.display, props.contrastColor(12, 178, 15));
        this.colorDeprecated = new ManagedColor(this.display, props.contrastColor(246, 196, 56));
        this.loadFonts();
        this.loadCommonImages();
        this.loadTransformImages();
        this.loadWorkflowActionImages();
        this.loadValueMetaImages();
    }

    private void dispose(boolean reload) {
        this.colorBackground.dispose();
        this.colorGraph.dispose();
        this.colorTab.dispose();
        this.colorRed.dispose();
        this.colorSuccessGreen.dispose();
        this.colorGreen.dispose();
        this.colorBlue.dispose();
        this.colorGray.dispose();
        this.colorYellow.dispose();
        this.colorMagenta.dispose();
        this.colorPurpule.dispose();
        this.colorIndigo.dispose();
        this.colorOrange.dispose();
        this.colorBlueCustomGrid.dispose();
        this.colorWhite.dispose();
        this.colorDemoGray.dispose();
        this.colorLightGray.dispose();
        this.colorDarkGray.dispose();
        this.colorBlack.dispose();
        this.colorLightBlue.dispose();
        this.colorDirectory.dispose();
        this.colorHop.dispose();
        this.colorLight.dispose();
        this.colorCream.dispose();
        this.disposeColors(this.colorMap.values());
        if (!reload) {
            this.fontGraph.dispose();
            this.fontNote.dispose();
            this.fontFixed.dispose();
            this.fontMedium.dispose();
            this.fontMediumBold.dispose();
            this.fontLarge.dispose();
            this.fontTiny.dispose();
            this.fontSmall.dispose();
            this.fontBold.dispose();
            this.imageLogo.dispose();
            this.imageDisabledHop.dispose();
            this.imageDatabase.dispose();
            this.imageData.dispose();
            this.imageAdd.dispose();
            this.imageTable.dispose();
            this.imagePreview.dispose();
            this.imageSchema.dispose();
            this.imageSynonym.dispose();
            this.imageView.dispose();
            this.imageLabel.dispose();
            this.imageFunction.dispose();
            this.imageCancel.dispose();
            this.imageCopy.dispose();
            this.imageCut.dispose();
            this.imageDuplicate.dispose();
            this.imagePaste.dispose();
            this.imageBol.dispose();
            this.imageCalendar.dispose();
            this.imageServer.dispose();
            this.imageArrow.dispose();
            this.imageFile.dispose();
            this.imageFolder.dispose();
            this.imageMissing.dispose();
            this.imageVariable.dispose();
            this.imagePipeline.dispose();
            this.imagePartitionSchema.dispose();
            this.imageWorkflow.dispose();
            this.imageUser.dispose();
            this.imageFolderConnections.dispose();
            this.imageShowResults.dispose();
            this.imageHideResults.dispose();
            this.imageCollapseAll.dispose();
            this.imageCopyRows.dispose();
            this.imageCopyRowsDisabled.dispose();
            this.imageError.dispose();
            this.imageErrorDisabled.dispose();
            this.imageInfo.dispose();
            this.imageInfoDisabled.dispose();
            this.imageWarning.dispose();
            this.imageClearText.dispose();
            this.imageDeprecated.dispose();
            this.imageExpandAll.dispose();
            this.imageSearch.dispose();
            this.imageRegEx.dispose();
            this.imageNew.dispose();
            this.imageEdit.dispose();
            this.imageLocked.dispose();
            this.imageInput.dispose();
            this.imageOutput.dispose();
            this.imageTarget.dispose();
            this.imageTargetDisabled.dispose();
            this.imageTrue.dispose();
            this.imageTrueDisabled.dispose();
            this.imageFalse.dispose();
            this.imageFalseDisabled.dispose();
            this.imageFailure.dispose();
            this.imageSuccess.dispose();
            this.imageContextMenu.dispose();
            this.imageParallel.dispose();
            this.imageParallelDisabled.dispose();
            this.imageUnconditional.dispose();
            this.imageUnconditionalDisabled.dispose();
            this.imageBusy.dispose();
            this.imageInject.dispose();
            this.imageBalance.dispose();
            this.imageCheckpoint.dispose();
            this.imageHelp.dispose();
            this.imageAddAll.dispose();
            this.imageAddSingle.dispose();
            this.imageRemoveAll.dispose();
            this.imageRemoveSingle.dispose();
            this.imageNavigateBack.dispose();
            this.imageNavigateForward.dispose();
            this.imageNavigateUp.dispose();
            this.imageRefresh.dispose();
            this.imageHome.dispose();
            this.imagePrint.dispose();
            this.imageClose.dispose();
            this.imageDelete.dispose();
            this.imagePause.dispose();
            this.imageRun.dispose();
            this.imageStop.dispose();
            this.imageSearch.dispose();
            this.imageDown.dispose();
            this.imageUp.dispose();
            this.imageArrowDefault.dispose();
            this.imageArrowTrue.dispose();
            this.imageArrowFalse.dispose();
            this.imageArrowError.dispose();
            this.imageArrowDisabled.dispose();
            this.imageArrowCandidate.dispose();
            this.disposeImage(this.imageNote);
            this.disposeImage(this.imageColor);
            this.disposeImage(this.imageEditOption);
            this.disposeImage(this.imageResetOption);
            this.disposeImage(this.imageShowLog);
            this.disposeImage(this.imageShowGrid);
            this.disposeImage(this.imageShowHistory);
            this.disposeImage(this.imageShowPerf);
            this.disposeImage(this.imageShow);
            this.disposeImage(this.imageHide);
            this.disposeImage(this.imageShowSelected);
            this.disposeImage(this.imageShowAll);
            this.disposeImage(this.imageClosePanel);
            this.disposeImage(this.imageMaximizePanel);
            this.disposeImage(this.imageMinimizePanel);
            this.disposeImage(this.imageShowErrorLines);
            this.disposeUniversalImages(this.imagesActions.values());
            this.disposeUniversalImages(this.imagesTransforms.values());
            this.disposeImages(this.imageMap.values());
            this.disposeImages(this.imagesValueMeta.values());
        }
    }

    private void disposeImages(Collection<Image> c) {
        for (Image image : c) {
            this.disposeImage(image);
        }
    }

    private void disposeUniversalImages(Collection<SwtUniversalImage> c) {
        for (SwtUniversalImage image : c) {
            image.dispose();
        }
    }

    private void disposeColors(Collection<Color> colors) {
        for (Color color : colors) {
            color.dispose();
        }
    }

    private void disposeImage(Image image) {
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransformImages() {
        this.imagesTransforms.clear();
        PluginRegistry registry = PluginRegistry.getInstance();
        List transforms = registry.getPlugins(TransformPluginType.class);
        for (IPlugin transform : transforms) {
            if (this.imagesTransforms.get(transform.getIds()[0]) != null) continue;
            SwtUniversalImage image = null;
            String filename = transform.getImageFile();
            try {
                ClassLoader classLoader = registry.getClassLoader(transform);
                image = SwtSvgImageUtil.getUniversalImage(this.display, classLoader, filename);
            }
            catch (Throwable t) {
                log.logError("Error occurred loading image [" + filename + "] for plugin " + transform, t);
            }
            finally {
                if (image == null) {
                    log.logError("Unable to load image file [" + filename + "] for plugin " + transform);
                    image = SwtSvgImageUtil.getMissingImage(this.display);
                }
            }
            this.imagesTransforms.put(transform.getIds()[0], image);
        }
    }

    private void loadFonts() {
        PropsUi props = PropsUi.getInstance();
        this.fontGraph = new ManagedFont(this.display, props.getGraphFont());
        this.fontNote = new ManagedFont(this.display, props.getNoteFont());
        this.fontFixed = new ManagedFont(this.display, props.getFixedFont());
        FontData mediumFontData = new FontData(props.getGraphFont().getName(), (int)Math.round((double)props.getGraphFont().getHeight() * 1.2), props.getGraphFont().getStyle());
        this.fontMedium = new ManagedFont(this.display, mediumFontData);
        FontData mediumFontBoldData = new FontData(props.getGraphFont().getName(), (int)Math.round((double)props.getGraphFont().getHeight() * 1.2), props.getGraphFont().getStyle() | 1);
        this.fontMediumBold = new ManagedFont(this.display, mediumFontBoldData);
        FontData largeFontData = new FontData(props.getGraphFont().getName(), mediumFontData.getHeight() + 2, props.getGraphFont().getStyle());
        this.fontLarge = new ManagedFont(this.display, largeFontData);
        FontData tinyFontData = new FontData(props.getGraphFont().getName(), mediumFontData.getHeight() - 2, props.getGraphFont().getStyle());
        this.fontTiny = new ManagedFont(this.display, tinyFontData);
        FontData smallFontData = new FontData(props.getGraphFont().getName(), mediumFontData.getHeight() - 1, props.getGraphFont().getStyle());
        this.fontSmall = new ManagedFont(this.display, smallFontData);
        FontData boldFontData = new FontData(props.getDefaultFontData().getName(), props.getDefaultFontData().getHeight(), props.getDefaultFontData().getStyle() | 1);
        this.fontBold = new ManagedFont(this.display, boldFontData);
    }

    public Image loadAsResource(Display display, String location, int size) {
        Image image;
        SwtUniversalImage img = SwtSvgImageUtil.getUniversalImage(display, this.getClass().getClassLoader(), location);
        if (size > 0) {
            int newSize = (int)Math.round((double)size * this.zoomFactor);
            image = new Image((Device)display, img.getAsBitmapForSize((Device)display, newSize, newSize), 0);
        } else {
            image = new Image((Device)display, img.getAsBitmap((Device)display), 0);
        }
        img.dispose();
        return image;
    }

    public Image loadAsResource(Display display, String location, int width, int height) {
        SwtUniversalImage img = SwtSvgImageUtil.getImageAsResource(display, location);
        int newWidth = (int)Math.round((double)width * this.zoomFactor);
        int newHeight = (int)Math.round((double)height * this.zoomFactor);
        Image image = new Image((Device)display, img.getAsBitmapForSize((Device)display, newWidth, newHeight), 0);
        img.dispose();
        return image;
    }

    private void loadCommonImages() {
        this.imageEmpty = new Image((Device)this.display, 16, 16);
        this.imageAdd = this.loadAsResource(this.display, "ui/images/add.svg", 16);
        this.imageAddAll = this.loadAsResource(this.display, "ui/images/add_all.svg", 16);
        this.imageAddSingle = this.loadAsResource(this.display, "ui/images/add_single.svg", 16);
        this.imageCalendar = this.loadAsResource(this.display, "ui/images/calendar.svg", 16);
        this.imageClosePanel = this.loadAsResource(this.display, "ui/images/close-panel.svg", 16);
        this.imageCollapseAll = this.loadAsResource(this.display, "ui/images/collapse-all.svg", 16);
        this.imageColor = this.loadAsResource(this.display, "ui/images/edit_option.svg", 16);
        this.imageCancel = this.loadAsResource(this.display, "ui/images/cancel.svg", 16);
        this.imageCopy = this.loadAsResource(this.display, "ui/images/copy.svg", 16);
        this.imageCut = this.loadAsResource(this.display, "ui/images/cut.svg", 16);
        this.imageDuplicate = this.loadAsResource(this.display, "ui/images/duplicate.svg", 16);
        this.imagePaste = this.loadAsResource(this.display, "ui/images/paste.svg", 16);
        this.imageEditOption = this.loadAsResource(this.display, "ui/images/edit_option.svg", 16);
        this.imageExpandAll = this.loadAsResource(this.display, "ui/images/expand-all.svg", 16);
        this.imageLabel = this.loadAsResource(this.display, "ui/images/label.svg", 16);
        this.imageFunction = this.loadAsResource(this.display, "ui/images/function.svg", 16);
        this.imageNavigateBack = this.loadAsResource(this.display, "ui/images/navigate-back.svg", 16);
        this.imageNavigateForward = this.loadAsResource(this.display, "ui/images/navigate-forward.svg", 16);
        this.imageNavigateUp = this.loadAsResource(this.display, "ui/images/navigate-up.svg", 16);
        this.imageHelp = this.loadAsResource(this.display, "ui/images/help.svg", 16);
        this.imageHide = this.loadAsResource(this.display, "ui/images/hide.svg", 16);
        this.imageHideResults = this.loadAsResource(this.display, "ui/images/hide-results.svg", 16);
        this.imageHome = this.loadAsResource(this.display, "ui/images/home.svg", 16);
        this.imageMaximizePanel = this.loadAsResource(this.display, "ui/images/maximize-panel.svg", 16);
        this.imageMinimizePanel = this.loadAsResource(this.display, "ui/images/minimize-panel.svg", 16);
        this.imageNew = this.loadAsResource(this.display, "ui/images/new.svg", 16);
        this.imageNote = this.loadAsResource(this.display, "ui/images/note.svg", 16);
        this.imagePrint = this.loadAsResource(this.display, "ui/images/print.svg", 16);
        this.imageRefresh = this.loadAsResource(this.display, "ui/images/refresh.svg", 16);
        this.imageRegEx = this.loadAsResource(this.display, "ui/images/regex.svg", 16);
        this.imageRemoveAll = this.loadAsResource(this.display, "ui/images/remove_all.svg", 16);
        this.imageRemoveSingle = this.loadAsResource(this.display, "ui/images/remove_single.svg", 16);
        this.imageResetOption = this.loadAsResource(this.display, "ui/images/reset_option.svg", 16);
        this.imageSchema = this.loadAsResource(this.display, "ui/images/user.svg", 16);
        this.imageSearch = this.loadAsResource(this.display, "ui/images/search.svg", 16);
        this.imageShowAll = this.loadAsResource(this.display, "ui/images/show-all.svg", 16);
        this.imageShowErrorLines = this.loadAsResource(this.display, "ui/images/show-error-lines.svg", 16);
        this.imageShowGrid = this.loadAsResource(this.display, "ui/images/show-grid.svg", 16);
        this.imageShowHistory = this.loadAsResource(this.display, "ui/images/show-history.svg", 16);
        this.imageShow = this.loadAsResource(this.display, "ui/images/show.svg", 16);
        this.imageShowLog = this.loadAsResource(this.display, "ui/images/log.svg", 16);
        this.imageShowPerf = this.loadAsResource(this.display, "ui/images/show-perf.svg", 16);
        this.imageShowResults = this.loadAsResource(this.display, "ui/images/show-results.svg", 16);
        this.imageShowSelected = this.loadAsResource(this.display, "ui/images/show-selected.svg", 16);
        this.imageSynonym = this.loadAsResource(this.display, "ui/images/view.svg", 16);
        this.imageTable = this.loadAsResource(this.display, "ui/images/table.svg", 16);
        this.imageUser = this.loadAsResource(this.display, "ui/images/user.svg", 16);
        this.imageClose = this.loadAsResource(this.display, "ui/images/close.svg", 16);
        this.imageDelete = this.loadAsResource(this.display, "ui/images/delete.svg", 16);
        this.imagePause = this.loadAsResource(this.display, "ui/images/pause.svg", 16);
        this.imageRun = this.loadAsResource(this.display, "ui/images/run.svg", 16);
        this.imageStop = this.loadAsResource(this.display, "ui/images/stop.svg", 16);
        this.imageView = this.loadAsResource(this.display, "ui/images/view.svg", 16);
        this.imageDown = this.loadAsResource(this.display, "ui/images/down.svg", 16);
        this.imageUp = this.loadAsResource(this.display, "ui/images/up.svg", 16);
        this.imageLogo = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/logo_icon.svg");
        this.imagePipeline = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/pipeline.svg");
        this.imageWorkflow = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/workflow.svg");
        this.imageServer = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/server.svg");
        this.imagePreview = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/preview.svg");
        this.imageTrue = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/true.svg");
        this.imageTrueDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/true-disabled.svg");
        this.imageFalse = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/false.svg");
        this.imageFalseDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/false-disabled.svg");
        this.imageVariable = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/variable.svg");
        this.imageFile = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/file.svg");
        this.imageFolder = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/folder.svg");
        this.imagePartitionSchema = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/partition_schema.svg");
        this.imageDatabase = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/database.svg");
        this.imageData = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/data.svg");
        this.imageEdit = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/edit.svg");
        this.imageMissing = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/missing.svg");
        this.imageDeprecated = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/deprecated.svg");
        this.imageLocked = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/lock.svg");
        this.imageBol = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/bol.svg");
        this.imageClearText = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/clear-text.svg");
        this.imageCopyRows = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/copy-rows.svg");
        this.imageCopyRowsDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/copy-rows-disabled.svg");
        this.imageFailure = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/failure.svg");
        this.imageSuccess = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/success.svg");
        this.imageError = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/error.svg");
        this.imageErrorDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/error-disabled.svg");
        this.imageInfo = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/info.svg");
        this.imageInfoDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/info-disabled.svg");
        this.imageWarning = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/warning.svg");
        this.imageEdit = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/edit.svg");
        this.imageInput = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/input.svg");
        this.imageOutput = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/output.svg");
        this.imageTarget = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/target.svg");
        this.imageTargetDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/target-disabled.svg");
        this.imageContextMenu = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/context_menu.svg");
        this.imageParallel = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/parallel-hop.svg");
        this.imageParallelDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/parallel-hop-disabled.svg");
        this.imageUnconditional = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/unconditional.svg");
        this.imageUnconditionalDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/unconditional-disabled.svg");
        this.imageBusy = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/busy.svg");
        this.imageInject = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/inject.svg");
        this.imageBalance = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/scales.svg");
        this.imageCheckpoint = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/checkpoint.svg");
        this.imageArrow = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/arrow.svg");
        this.imageFolderConnections = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/folder_connection.svg");
        this.imageDisabledHop = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/DHOP.svg");
        this.imageArrowDefault = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/hop-arrow-default.svg");
        this.imageArrowTrue = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/hop-arrow-true.svg");
        this.imageArrowFalse = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/hop-arrow-false.svg");
        this.imageArrowError = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/hop-arrow-error.svg");
        this.imageArrowDisabled = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/hop-arrow-disabled.svg");
        this.imageArrowCandidate = SwtSvgImageUtil.getImageAsResource(this.display, "ui/images/hop-arrow-candidate.svg");
    }

    public Image getImageLabel() {
        return this.imageLabel;
    }

    public Image getImageDuplicate() {
        return this.imageDuplicate;
    }

    public Image getImageCopy() {
        return this.imageCopy;
    }

    public Image getImageFunction() {
        return this.imageFunction;
    }

    public Image getImageEmpty() {
        return this.imageEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWorkflowActionImages() {
        this.imagesActions = new Hashtable<String, SwtUniversalImage>();
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(ActionPluginType.class);
        for (int i = 0; i < plugins.size(); ++i) {
            IPlugin plugin = (IPlugin)plugins.get(i);
            SwtUniversalImage image = null;
            String filename = plugin.getImageFile();
            try {
                ClassLoader classLoader = registry.getClassLoader(plugin);
                image = SwtSvgImageUtil.getUniversalImage(this.display, classLoader, filename);
            }
            catch (Throwable t) {
                log.logError("Error occurred loading image [" + filename + "] for plugin " + plugin.getIds()[0], t);
            }
            finally {
                if (image == null) {
                    log.logError("Unable to load image [" + filename + "] for plugin " + plugin.getIds()[0]);
                    image = SwtSvgImageUtil.getMissingImage(this.display);
                }
            }
            this.imagesActions.put(plugin.getIds()[0], image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValueMetaImages() {
        this.imagesValueMeta = new HashMap<String, Image>();
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(ValueMetaPluginType.class);
        for (IPlugin plugin : plugins) {
            Image image = null;
            try {
                ClassLoader classLoader = registry.getClassLoader(plugin);
                image = this.getImage(plugin.getImageFile(), classLoader, 16, 16);
            }
            catch (Throwable t) {
                log.logError("Error occurred loading image [" + plugin.getImageFile() + "] for plugin " + plugin.getIds()[0], t);
            }
            finally {
                if (image == null) {
                    log.logError("Unable to load image [" + plugin.getImageFile() + "] for plugin " + plugin.getIds()[0]);
                    image = this.imageLabel;
                }
            }
            this.imagesValueMeta.put(plugin.getIds()[0], image);
        }
    }

    public Color getColorBackground() {
        return this.colorBackground.getColor();
    }

    public Color getColorBlack() {
        return this.colorBlack.getColor();
    }

    public Color getColorBlue() {
        return this.colorBlue.getColor();
    }

    public Color getColorDarkGray() {
        return this.colorDarkGray.getColor();
    }

    public Color getColorDemoGray() {
        return this.colorDemoGray.getColor();
    }

    public Color getColorDirectory() {
        return this.colorDirectory.getColor();
    }

    public Color getColorGraph() {
        return this.colorGraph.getColor();
    }

    public Color getColorGray() {
        return this.colorGray.getColor();
    }

    public Color getColorGreen() {
        return this.colorGreen.getColor();
    }

    public Color getColorLightGray() {
        return this.colorLightGray.getColor();
    }

    public Color getColorLightBlue() {
        return this.colorLightBlue.getColor();
    }

    public Color getColorMagenta() {
        return this.colorMagenta.getColor();
    }

    public Color getColorPurpule() {
        return this.colorPurpule.getColor();
    }

    public Color getColorIndigo() {
        return this.colorIndigo.getColor();
    }

    public Color getColorOrange() {
        return this.colorOrange.getColor();
    }

    public Color getColorSuccessGreen() {
        return this.colorSuccessGreen.getColor();
    }

    public Color getColorRed() {
        return this.colorRed.getColor();
    }

    public Color getColorBlueCustomGrid() {
        return this.colorBlueCustomGrid.getColor();
    }

    public Color getColorTab() {
        return this.colorTab.getColor();
    }

    public Color getColorWhite() {
        return this.colorWhite.getColor();
    }

    public Color getColorYellow() {
        return this.colorYellow.getColor();
    }

    public Font getFontFixed() {
        return this.fontFixed.getFont();
    }

    public Font getFontGraph() {
        return this.fontGraph.getFont();
    }

    public Font getFontNote() {
        return this.fontNote.getFont();
    }

    public Image getImageBol() {
        return this.imageBol.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageCalendar() {
        return this.imageCalendar;
    }

    public Image getImageServer() {
        return this.imageServer.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageDatabase() {
        return this.imageDatabase.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageData() {
        return this.imageData.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageDatabase() {
        return this.imageDatabase;
    }

    public SwtUniversalImage getSwtImageData() {
        return this.imageData;
    }

    public Image getImageAdd() {
        return this.imageAdd;
    }

    public Image getImageTable() {
        return this.imageTable;
    }

    public Image getImagePreview() {
        return this.imagePreview.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageSchema() {
        return this.imageSchema;
    }

    public Image getImageSynonym() {
        return this.imageSynonym;
    }

    public Image getImageNote() {
        return this.imageNote;
    }

    public Image getImageColor() {
        return this.imageColor;
    }

    public Image getImageMissing() {
        return this.imageMissing.getAsBitmapForSize((Device)this.display, 32, 32);
    }

    public SwtUniversalImage getSwtImageMissing() {
        return this.imageMissing;
    }

    public Image getImageHop() {
        return this.imageLogo.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Image getImageDisabledHop() {
        return this.imageDisabledHop.getAsBitmapForSize((Device)this.display, 16, 16);
    }

    public Map<String, SwtUniversalImage> getImagesTransforms() {
        return this.imagesTransforms;
    }

    public Map<String, SwtUniversalImage> getImagesActions() {
        return this.imagesActions;
    }

    public Image getImage(IValueMeta valueMeta) {
        if (valueMeta == null) {
            return this.imageLabel;
        }
        return this.imagesValueMeta.get(String.valueOf(valueMeta.getType()));
    }

    public Font getFontLarge() {
        return this.fontLarge.getFont();
    }

    public Font getFontTiny() {
        return this.fontTiny.getFont();
    }

    public Font getFontSmall() {
        return this.fontSmall.getFont();
    }

    public Clipboard getNewClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.clipboard = new Clipboard(this.display);
        return this.clipboard;
    }

    public void toClipboard(String cliptext) {
        if (cliptext == null) {
            return;
        }
        this.getNewClipboard();
        TextTransfer tran = TextTransfer.getInstance();
        this.clipboard.setContents((Object[])new String[]{cliptext}, new Transfer[]{tran});
    }

    public String fromClipboard() {
        this.getNewClipboard();
        TextTransfer tran = TextTransfer.getInstance();
        return (String)this.clipboard.getContents((Transfer)tran);
    }

    public Font getFontBold() {
        return this.fontBold.getFont();
    }

    private Image getZoomedImaged(SwtUniversalImage universalImage, Device device, int width, int height) {
        return universalImage.getAsBitmapForSize(device, (int)(this.zoomFactor * (double)width), (int)(this.zoomFactor * (double)height));
    }

    public Image getImageVariable() {
        return this.getZoomedImaged(this.imageVariable, (Device)this.display, 10, 10);
    }

    public Image getImagePipeline() {
        return this.getZoomedImaged(this.imagePipeline, (Device)this.display, 16, 16);
    }

    public Image getImageUser() {
        return this.imageUser;
    }

    public Image getImageFolderConnections() {
        return this.getZoomedImaged(this.imagePipeline, (Device)this.display, 16, 16);
    }

    public Image getImagePartitionSchema() {
        return this.getZoomedImaged(this.imagePartitionSchema, (Device)this.display, 24, 24);
    }

    public Image getImageWorkflow() {
        return this.getZoomedImaged(this.imageWorkflow, (Device)this.display, 16, 16);
    }

    public Image getEditOptionButton() {
        return this.imageEditOption;
    }

    public Image getImageResetOption() {
        return this.imageResetOption;
    }

    public Image getImageArrow() {
        return this.getZoomedImaged(this.imageArrow, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageArrow() {
        return this.imageArrow;
    }

    public Image getImageFolder() {
        return this.getZoomedImaged(this.imageFolder, (Device)this.display, 16, 16);
    }

    public Image getImageFile() {
        return this.getZoomedImaged(this.imageFile, (Device)this.display, 16, 16);
    }

    public Color getColorHop() {
        return this.colorHop.getColor();
    }

    public Image getImageHopUi() {
        return this.getZoomedImaged(this.imageLogo, (Device)this.display, 16, 16);
    }

    public Image getImageHopUiTaskbar() {
        if (OsHelper.isMac()) {
            return this.getZoomedImaged(this.imageLogo, (Device)this.display, 512, 512);
        }
        return this.getZoomedImaged(this.imageLogo, (Device)this.display, 16, 16);
    }

    public Color getColorLight() {
        return this.colorLight.getColor();
    }

    public Color getColorCream() {
        return this.colorCream.getColor();
    }

    public Color getColorCrystalText() {
        return this.colorCrystalText.getColor();
    }

    public Color getColorHopDefault() {
        return this.colorHopDefault.getColor();
    }

    public Color getColorHopTrue() {
        return this.colorHopTrue.getColor();
    }

    public Color getColorDeprecated() {
        return this.colorDeprecated.getColor();
    }

    public void drawGradient(Display display, GC gc, Rectangle rect, boolean vertical) {
        if (!vertical) {
            gc.setForeground(display.getSystemColor(22));
            gc.setBackground(GuiResource.getInstance().getColorHop());
            gc.fillGradientRectangle(rect.x, rect.y, 2 * rect.width / 3, rect.height, vertical);
            gc.setForeground(GuiResource.getInstance().getColorHop());
            gc.setBackground(display.getSystemColor(22));
            gc.fillGradientRectangle(rect.x + 2 * rect.width / 3, rect.y, rect.width / 3 + 1, rect.height, vertical);
        } else {
            gc.setForeground(display.getSystemColor(22));
            gc.setBackground(GuiResource.getInstance().getColorHop());
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, 2 * rect.height / 3, vertical);
            gc.setForeground(GuiResource.getInstance().getColorHop());
            gc.setBackground(display.getSystemColor(22));
            gc.fillGradientRectangle(rect.x, rect.y + 2 * rect.height / 3, rect.width, rect.height / 3 + 1, vertical);
        }
    }

    public static Point calculateControlPosition(Control control) {
        Rectangle r = control.getBounds();
        Point p = control.getParent().toDisplay(r.x, r.y);
        return p;
    }

    public Font getFontMedium() {
        return this.fontMedium.getFont();
    }

    public Font getFontMediumBold() {
        return this.fontMediumBold.getFont();
    }

    public Image getImageShowLog() {
        return this.imageShowLog;
    }

    public Image getImageShowGrid() {
        return this.imageShowGrid;
    }

    public Image getImageShowHistory() {
        return this.imageShowHistory;
    }

    public Image getImageShowPerf() {
        return this.imageShowPerf;
    }

    public Image getImageHide() {
        return this.imageHide;
    }

    public Image getImageShow() {
        return this.imageShow;
    }

    public Image getImageShowSelected() {
        return this.imageShowSelected;
    }

    public Image getImageShowAll() {
        return this.imageShowAll;
    }

    public Image getImageClosePanel() {
        return this.imageClosePanel;
    }

    public Image getImageMaximizePanel() {
        return this.imageMaximizePanel;
    }

    public Image getImageMinimizePanel() {
        return this.imageMinimizePanel;
    }

    public Image getImageShowErrorLines() {
        return this.imageShowErrorLines;
    }

    public Image getImageShowResults() {
        return this.imageShowResults;
    }

    public Image getImageHideResults() {
        return this.imageHideResults;
    }

    public Image getImageClearText() {
        return this.getZoomedImaged(this.imageClearText, (Device)this.display, 16, 16);
    }

    public Image getImageExpandAll() {
        return this.imageExpandAll;
    }

    public Image getImageRegex() {
        return this.imageRegEx;
    }

    public Image getImageCollapseAll() {
        return this.imageCollapseAll;
    }

    public Image getImageCopyHop() {
        return this.getZoomedImaged(this.imageCopyRows, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageCopyRows() {
        return this.imageCopyRows;
    }

    public SwtUniversalImage getSwtImageCopyRowsDisabled() {
        return this.imageCopyRowsDisabled;
    }

    public Image getImageError() {
        return this.getZoomedImaged(this.imageError, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageError() {
        return this.imageError;
    }

    public SwtUniversalImage getSwtImageErrorDisabled() {
        return this.imageErrorDisabled;
    }

    public Image getImageInfo() {
        return this.getZoomedImaged(this.imageInfo, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageInfo() {
        return this.imageInfo;
    }

    public SwtUniversalImage getSwtImageInfoDisabled() {
        return this.imageInfoDisabled;
    }

    public Image getImageWarning() {
        return this.getZoomedImaged(this.imageWarning, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageWarning() {
        return this.imageWarning;
    }

    public SwtUniversalImage getSwtImageDeprecated() {
        return this.imageDeprecated;
    }

    public Image getImageDeprecated() {
        return this.getZoomedImaged(this.imageDeprecated, (Device)this.display, 16, 16);
    }

    public Image getImageNew() {
        return this.imageNew;
    }

    public Image getImageEdit() {
        return this.getZoomedImaged(this.imageEdit, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageEdit() {
        return this.imageEdit;
    }

    public Image getImageDelete() {
        return this.imageDelete;
    }

    public Image getImageCancel() {
        return this.imageCancel;
    }

    public Image getImageCut() {
        return this.imageCut;
    }

    public Image getImageInput() {
        return this.getZoomedImaged(this.imageInput, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageInput() {
        return this.imageInput;
    }

    public Image getImageOutput() {
        return this.getZoomedImaged(this.imageOutput, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageOutput() {
        return this.imageOutput;
    }

    public Image getImageTarget() {
        return this.getZoomedImaged(this.imageTarget, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageTarget() {
        return this.imageTarget;
    }

    public SwtUniversalImage getSwtImageTargetDisabled() {
        return this.imageTargetDisabled;
    }

    public Image getImageLocked() {
        return this.getZoomedImaged(this.imageLocked, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageLocked() {
        return this.imageLocked;
    }

    public Image getImage(String location) {
        return this.getImage(location, 16, 16);
    }

    public Image getImage(String location, int width, int height) {
        StringBuilder builder = new StringBuilder(location);
        builder.append('|');
        builder.append(width);
        builder.append('|');
        builder.append(height);
        String key = builder.toString();
        Image image = this.imageMap.get(key);
        if (image == null) {
            SwtUniversalImage svg = SwtSvgImageUtil.getImage(this.display, location);
            int realWidth = (int)Math.round(this.zoomFactor * (double)width);
            int realHeight = (int)Math.round(this.zoomFactor * (double)height);
            image = new Image((Device)this.display, svg.getAsBitmapForSize((Device)this.display, realWidth, realHeight), 0);
            svg.dispose();
            this.imageMap.put(key, image);
        }
        return image;
    }

    public Image getImage(String location, ClassLoader classLoader, int width, int height) {
        return this.getImage(location, classLoader, width, height, false);
    }

    public Image getImage(String location, ClassLoader classLoader, int width, int height, boolean disabled) {
        StringBuilder builder = new StringBuilder(location);
        builder.append('|').append(width).append('|').append(height).append('|').append(disabled);
        String key = builder.toString();
        Image image = this.imageMap.get(key);
        if (image == null) {
            SwtUniversalImage svg = SwtSvgImageUtil.getUniversalImage(this.display, classLoader, location);
            Image zoomedImaged = this.getZoomedImaged(svg, (Device)this.display, width, height);
            if (disabled) {
                image = new Image((Device)this.display, zoomedImaged, 2);
                float factor = PropsUi.getInstance().isDarkMode() ? 0.4f : 2.5f;
                ImageData data = image.getImageData();
                for (int x = 0; x < data.width; ++x) {
                    for (int y = 0; y < data.height; ++y) {
                        int pixel = data.getPixel(x, y);
                        int a = pixel >> 24 & 0xFF;
                        int b = pixel >> 16 & 0xFF;
                        int g = pixel >> 8 & 0xFF;
                        int r = pixel & 0xFF;
                        a = (int)((float)a * factor);
                        b = (int)((float)b * factor);
                        g = (int)((float)g * factor);
                        r = (int)((float)r * factor);
                        data.setPixel(x, y, r + (g << 8) + (b << 16) + (a << 25));
                    }
                    image.dispose();
                    image = new Image((Device)this.display, data);
                }
            } else {
                image = new Image((Device)this.display, zoomedImaged, 0);
            }
            svg.dispose();
            this.imageMap.put(location, image);
        }
        return image;
    }

    public Color getColor(int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        Color color = this.colorMap.get(rgb);
        if (color == null) {
            color = new Color((Device)this.display, rgb);
            this.colorMap.put(rgb, color);
        }
        return color;
    }

    public Map<String, Image> getImageMap() {
        return this.imageMap;
    }

    public Image getImageTrue() {
        return this.getZoomedImaged(this.imageTrue, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageTrue() {
        return this.imageTrue;
    }

    public SwtUniversalImage getSwtImageTrueDisabled() {
        return this.imageTrueDisabled;
    }

    public Image getImageFalse() {
        return this.getZoomedImaged(this.imageFalse, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageFalse() {
        return this.imageFalse;
    }

    public SwtUniversalImage getSwtImageFalseDisabled() {
        return this.imageFalseDisabled;
    }

    public Image getImageFailure() {
        return this.getZoomedImaged(this.imageFailure, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageFailure() {
        return this.imageFailure;
    }

    public Image getImageSuccess() {
        return this.getZoomedImaged(this.imageSuccess, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageSuccess() {
        return this.imageSuccess;
    }

    public Image getImageContextMenu() {
        return this.getZoomedImaged(this.imageContextMenu, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageContextMenu() {
        return this.imageContextMenu;
    }

    public Image getImageParallelHop() {
        return this.getZoomedImaged(this.imageParallel, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageParallel() {
        return this.imageParallel;
    }

    public SwtUniversalImage getSwtImageParallelDisabled() {
        return this.imageParallelDisabled;
    }

    public Image getImageUnconditionalHop() {
        return this.getZoomedImaged(this.imageUnconditional, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageUnconditional() {
        return this.imageUnconditional;
    }

    public SwtUniversalImage getSwtImageUnconditionalDisabled() {
        return this.imageUnconditionalDisabled;
    }

    public Image getImageBusy() {
        return this.getZoomedImaged(this.imageBusy, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageBusy() {
        return this.imageBusy;
    }

    public Image getImageInject() {
        return this.getZoomedImaged(this.imageInject, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageInject() {
        return this.imageInject;
    }

    public Image getImageBalance() {
        return this.getZoomedImaged(this.imageBalance, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageBalance() {
        return this.imageBalance;
    }

    public Image getImageCheckpoint() {
        return this.getZoomedImaged(this.imageCheckpoint, (Device)this.display, 16, 16);
    }

    public SwtUniversalImage getSwtImageCheckpoint() {
        return this.imageCheckpoint;
    }

    public Image getImageHelpWeb() {
        return this.imageHelp;
    }

    public Image getImageDown() {
        return this.imageDown;
    }

    public Image getImageUp() {
        return this.imageUp;
    }

    public Image getImageAddAll() {
        return this.imageAddAll;
    }

    public Image getImageAddSingle() {
        return this.imageAddSingle;
    }

    public Image getImageRemoveAll() {
        return this.imageRemoveAll;
    }

    public Image getImageRemoveSingle() {
        return this.imageRemoveSingle;
    }

    public Image getImageNavigateBack() {
        return this.imageNavigateBack;
    }

    public Image getImageNavigateForward() {
        return this.imageNavigateForward;
    }

    public Image getImageNavigateUp() {
        return this.imageNavigateUp;
    }

    public Image getImageRefresh() {
        return this.imageRefresh;
    }

    public Image getImageHome() {
        return this.imageHome;
    }

    public Image getImagePrint() {
        return this.imagePrint;
    }

    public SwtUniversalImage getSwtImageArrowDefault() {
        return this.imageArrowDefault;
    }

    public SwtUniversalImage getSwtImageArrowTrue() {
        return this.imageArrowTrue;
    }

    public SwtUniversalImage getSwtImageArrowFalse() {
        return this.imageArrowFalse;
    }

    public SwtUniversalImage getSwtImageArrowError() {
        return this.imageArrowError;
    }

    public SwtUniversalImage getSwtImageArrowDisabled() {
        return this.imageArrowDisabled;
    }

    public SwtUniversalImage getSwtImageArrowCandidate() {
        return this.imageArrowCandidate;
    }

    public Image getImageClose() {
        return this.imageClose;
    }

    public Image getImagePause() {
        return this.imagePause;
    }

    public Image getImageRun() {
        return this.imageRun;
    }

    public Image getImageStop() {
        return this.imageStop;
    }

    public Image getImageView() {
        return this.imageView;
    }

    public Image getImageSearch() {
        return this.imageSearch;
    }
}

