/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import org.apache.hop.core.util.Assert;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PluginWidgetFactory {
    public static final int DEFAULT_MARGIN = PropsUi.getInstance().getMargin();
    public static final int DEFAULT_MIDDLE = 35;
    public static final int DEFAULT_RIGHT_OFFSET = 100;
    private final Shell shell;
    private final IVariables varSpace;
    private int margin = DEFAULT_MARGIN;
    private int middle = 35;
    private int rightOffset = 100;

    public PluginWidgetFactory(Shell shell, IVariables varSpace) throws IllegalArgumentException {
        Assert.assertNotNull((Object)shell, (String)"Shell cannot be null");
        Assert.assertNotNull((Object)varSpace, (String)"pipelineMeta cannot be null");
        this.shell = shell;
        this.varSpace = varSpace;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public int getMiddle() {
        return this.middle;
    }

    public void setMiddle(int middle) {
        this.middle = middle;
    }

    public Label createRightLabel(String text) {
        return this.createLabel(131072, text);
    }

    public Label createLabel(int style, String text) {
        Label label = new Label((Composite)this.shell, style);
        label.setText(text);
        return label;
    }

    public FormData createLabelLayoutData(Control topControl) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(this.middle, -this.margin);
        formData.top = topControl != null ? new FormAttachment(topControl, this.margin) : new FormAttachment(0, this.margin);
        return formData;
    }

    public FormData createControlLayoutData(Control topControl) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(this.middle, 0);
        formData.top = topControl != null ? new FormAttachment(topControl, this.margin) : new FormAttachment(0, this.margin);
        formData.right = new FormAttachment(this.rightOffset, 0);
        return formData;
    }

    public FormData createButtonLayoutData(Control labelControl) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(this.middle, 0);
        formData.top = new FormAttachment(labelControl, 0, 0x1000000);
        formData.right = new FormAttachment(this.rightOffset, 0);
        return formData;
    }

    public Text createSingleTextLeft(String text) {
        return this.createText(18436, text);
    }

    public Text createText(int style, String text) {
        Text textWidget = new Text((Composite)this.shell, style);
        textWidget.setText(text);
        return textWidget;
    }

    public TextVar createSingleTextVarLeft() {
        return new TextVar(this.varSpace, (Composite)this.shell, 18436);
    }

    public Button createButton(int style, String text) {
        Button button = new Button((Composite)this.shell, style);
        button.setText(text);
        return button;
    }

    public Button createPushButton(String text) {
        return this.createButton(8, text);
    }
}

