/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.search;

import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableCallback;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.json.JsonMetadataSerializer;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;

public class HopGuiMetadataSearchable
implements ISearchable<IHopMetadata> {
    private IHopMetadataProvider metadataProvider;
    private IHopMetadataSerializer<IHopMetadata> serializer;
    private IHopMetadata searchableObject;
    private Class<IHopMetadata> managedClass;

    public HopGuiMetadataSearchable(IHopMetadataProvider metadataProvider, IHopMetadataSerializer<IHopMetadata> serializer, IHopMetadata searchableObject, Class<IHopMetadata> managedClass) {
        this.metadataProvider = metadataProvider;
        this.serializer = serializer;
        this.searchableObject = searchableObject;
        this.managedClass = managedClass;
    }

    public String getLocation() {
        return this.metadataProvider.getDescription();
    }

    public String getName() {
        return this.searchableObject.getName();
    }

    public String getType() {
        return this.serializer.getDescription();
    }

    public String getFilename() {
        if (this.serializer instanceof JsonMetadataSerializer) {
            return ((JsonMetadataSerializer)this.serializer).calculateFilename(this.getName());
        }
        return null;
    }

    public ISearchableCallback getSearchCallback() {
        return (searchable, searchResult) -> new MetadataManager<IHopMetadata>(HopGui.getInstance().getVariables(), this.metadataProvider, this.managedClass).editMetadata(searchable.getName());
    }

    public IHopMetadata getSearchableObject() {
        return this.searchableObject;
    }

    public void setSearchableObject(IHopMetadata searchableObject) {
        this.searchableObject = searchableObject;
    }

    public Class<IHopMetadata> getManagedClass() {
        return this.managedClass;
    }

    public void setManagedClass(Class<IHopMetadata> managedClass) {
        this.managedClass = managedClass;
    }
}

