/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.workflow.actions;

import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class ActionBaseDialog
extends ActionDialog {
    public static final Class<?> PKG = ActionBaseDialog.class;
    protected Label wlPath;
    protected TextVar wPath;
    protected Button wbBrowse;
    protected Label wlRunConfiguration;
    protected ComboVar wRunConfiguration;
    protected Group gLogFile;
    protected Composite wOptions;
    protected Label wlName;
    protected Text wName;
    protected FormData fdlName;
    protected FormData fdName;
    protected Button wSetLogfile;
    protected Label wlLogfile;
    protected TextVar wLogfile;
    protected Button wbLogFilename;
    protected FormData fdbLogFilename;
    protected Button wCreateParentFolder;
    protected Label wlLogext;
    protected TextVar wLogext;
    protected Label wlAddDate;
    protected Button wAddDate;
    protected Label wlAddTime;
    protected Button wAddTime;
    protected Label wlLoglevel;
    protected CCombo wLoglevel;
    protected Button wPrevToParams;
    protected Button wEveryRow;
    protected Button wClearRows;
    protected Button wClearFiles;
    protected TableView wParameters;
    protected Button wWaitingToFinish;
    protected Group gExecution;
    protected Button wOk;
    protected Button wCancel;
    protected Listener lsOk;
    protected Listener lsCancel;
    protected Shell shell;
    protected boolean backupChanged;
    protected Button wAppendLogfile;
    protected Button wPassParams;
    protected Button wbGetParams;
    protected Display display;
    protected FormData fdgExecution;
    protected LogChannel log;

    public ActionBaseDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.log = new LogChannel((Object)workflowMeta);
    }

    protected void createElements() {
        ModifyListener lsMod = e -> this.getAction().setChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlName = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlName);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.ActionName.Label", (String[])new String[0]));
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.top = new FormAttachment(0, 0);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.fdName = new FormData();
        this.fdName.right = new FormAttachment((Control)wicon, -5);
        this.fdName.top = new FormAttachment((Control)this.wlName, 5);
        this.fdName.left = new FormAttachment(0, 0);
        this.wName.setLayoutData((Object)this.fdName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        FormData fdlPath = new FormData();
        fdlPath.left = new FormAttachment(0, 0);
        fdlPath.top = new FormAttachment((Control)spacer, 20);
        fdlPath.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlPath);
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, 0);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, Const.isOSX() ? 0 : 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wPath = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdPath = new FormData();
        fdPath.left = new FormAttachment(0, 0);
        fdPath.top = new FormAttachment((Control)this.wlPath, 5);
        fdPath.right = new FormAttachment((Control)this.wbBrowse, -5);
        this.wPath.setLayoutData(fdPath);
        this.wlRunConfiguration = new Label((Composite)this.shell, 16384);
        this.wlRunConfiguration.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.RunConfiguration.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRunConfiguration);
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.left = new FormAttachment(0, 0);
        fdlRunConfiguration.top = new FormAttachment((Control)this.wPath, Const.isOSX() ? 0 : 5);
        fdlRunConfiguration.right = new FormAttachment(50, 0);
        this.wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new ComboVar(this.variables, (Composite)this.shell, 18432);
        this.props.setLook((Control)this.wRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.left = new FormAttachment(0, 0);
        fdRunConfiguration.top = new FormAttachment((Control)this.wlRunConfiguration, Const.isOSX() ? 0 : 5);
        fdRunConfiguration.right = new FormAttachment(100, 0);
        this.wRunConfiguration.setLayoutData(fdRunConfiguration);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wOptionsTab = new CTabItem(wTabFolder, 0);
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Options.Group.Label", (String[])new String[0]));
        this.wOptions = new Composite((Composite)wTabFolder, 32);
        this.props.setLook((Control)this.wOptions);
        FormLayout specLayout = new FormLayout();
        specLayout.marginWidth = 15;
        specLayout.marginHeight = 15;
        this.wOptions.setLayout((Layout)specLayout);
        this.gExecution = new Group(this.wOptions, 16);
        this.props.setLook((Control)this.gExecution);
        this.gExecution.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Execution.Group.Label", (String[])new String[0]));
        FormLayout gExecutionLayout = new FormLayout();
        gExecutionLayout.marginWidth = 15;
        gExecutionLayout.marginHeight = 15;
        this.gExecution.setLayout((Layout)gExecutionLayout);
        this.fdgExecution = new FormData();
        this.fdgExecution.top = new FormAttachment(0, 10);
        this.fdgExecution.left = new FormAttachment(0, 0);
        this.fdgExecution.right = new FormAttachment(100, 0);
        this.gExecution.setLayoutData((Object)this.fdgExecution);
        this.wEveryRow = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wEveryRow);
        this.wEveryRow.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.ExecForEveryInputRow.Label", (String[])new String[0]));
        FormData fdbExecute = new FormData();
        fdbExecute.left = new FormAttachment(0, 0);
        fdbExecute.top = new FormAttachment(0, 0);
        this.wEveryRow.setLayoutData((Object)fdbExecute);
        wOptionsTab.setControl((Control)this.wOptions);
        FormData fdOptions = new FormData();
        fdOptions.left = new FormAttachment(0, 0);
        fdOptions.top = new FormAttachment(0, 0);
        fdOptions.right = new FormAttachment(100, 0);
        fdOptions.bottom = new FormAttachment(100, 0);
        this.wOptions.setLayoutData((Object)fdOptions);
        CTabItem wLoggingTab = new CTabItem(wTabFolder, 0);
        wLoggingTab.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.LogSettings.Group.Label", (String[])new String[0]));
        Composite wLogging = new Composite((Composite)wTabFolder, 32);
        this.props.setLook((Control)wLogging);
        FormLayout loggingLayout = new FormLayout();
        loggingLayout.marginWidth = 15;
        loggingLayout.marginHeight = 15;
        wLogging.setLayout((Layout)loggingLayout);
        this.wSetLogfile = new Button(wLogging, 32);
        this.props.setLook((Control)this.wSetLogfile);
        this.wSetLogfile.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Specify.Logfile.Label", (String[])new String[0]));
        FormData fdSpecifyLogFile = new FormData();
        fdSpecifyLogFile.left = new FormAttachment(0, 0);
        fdSpecifyLogFile.top = new FormAttachment(0, 0);
        this.wSetLogfile.setLayoutData((Object)fdSpecifyLogFile);
        this.gLogFile = new Group(wLogging, 16);
        this.props.setLook((Control)this.gLogFile);
        this.gLogFile.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Logfile.Group.Label", (String[])new String[0]));
        FormLayout gLogFileLayout = new FormLayout();
        gLogFileLayout.marginWidth = 15;
        gLogFileLayout.marginHeight = 15;
        this.gLogFile.setLayout((Layout)gLogFileLayout);
        FormData fdgLogFile = new FormData();
        fdgLogFile.top = new FormAttachment((Control)this.wSetLogfile, 10);
        fdgLogFile.left = new FormAttachment(0, 0);
        fdgLogFile.right = new FormAttachment(100, 0);
        this.gLogFile.setLayoutData((Object)fdgLogFile);
        this.wlLogfile = new Label((Composite)this.gLogFile, 16384);
        this.props.setLook((Control)this.wlLogfile);
        this.wlLogfile.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.NameOfLogfile.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.top = new FormAttachment(0, 0);
        this.wlLogfile.setLayoutData((Object)fdlName);
        this.wLogfile = new TextVar(this.variables, (Composite)this.gLogFile, 18436);
        this.props.setLook((Control)this.wLogfile);
        FormData fdName = new FormData();
        fdName.width = 250;
        fdName.left = new FormAttachment(0, 0);
        fdName.top = new FormAttachment((Control)this.wlLogfile, 5);
        this.wLogfile.setLayoutData(fdName);
        this.wbLogFilename = new Button((Composite)this.gLogFile, 0x1000008);
        this.props.setLook((Control)this.wbLogFilename);
        this.wbLogFilename.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Browse.Label", (String[])new String[0]));
        this.fdbLogFilename = new FormData();
        this.fdbLogFilename.top = new FormAttachment((Control)this.wlLogfile, Const.isOSX() ? 0 : 5);
        this.fdbLogFilename.left = new FormAttachment((Control)this.wLogfile, 5);
        this.wbLogFilename.setLayoutData((Object)this.fdbLogFilename);
        this.wlLogext = new Label((Composite)this.gLogFile, 16384);
        this.props.setLook((Control)this.wlLogext);
        this.wlLogext.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.LogfileExtension.Label", (String[])new String[0]));
        FormData fdlExtension = new FormData();
        fdlExtension.left = new FormAttachment(0, 0);
        fdlExtension.top = new FormAttachment((Control)this.wLogfile, 10);
        this.wlLogext.setLayoutData((Object)fdlExtension);
        this.wLogext = new TextVar(this.variables, (Composite)this.gLogFile, 18436);
        this.props.setLook((Control)this.wLogext);
        FormData fdExtension = new FormData();
        fdExtension.width = 250;
        fdExtension.left = new FormAttachment(0, 0);
        fdExtension.top = new FormAttachment((Control)this.wlLogext, 5);
        this.wLogext.setLayoutData(fdExtension);
        this.wlLoglevel = new Label((Composite)this.gLogFile, 16384);
        this.props.setLook((Control)this.wlLoglevel);
        this.wlLoglevel.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Loglevel.Label", (String[])new String[0]));
        FormData fdlLogLevel = new FormData();
        fdlLogLevel.left = new FormAttachment(0, 0);
        fdlLogLevel.top = new FormAttachment((Control)this.wLogext, 10);
        this.wlLoglevel.setLayoutData((Object)fdlLogLevel);
        this.wLoglevel = new CCombo((Composite)this.gLogFile, 18436);
        this.wLoglevel.setItems(LogLevel.getLogLevelDescriptions());
        this.props.setLook((Control)this.wLoglevel);
        FormData fdLogLevel = new FormData();
        fdLogLevel.width = 250;
        fdLogLevel.left = new FormAttachment(0, 0);
        fdLogLevel.top = new FormAttachment((Control)this.wlLoglevel, 5);
        this.wLoglevel.setLayoutData((Object)fdLogLevel);
        this.wAppendLogfile = new Button((Composite)this.gLogFile, 32);
        this.props.setLook((Control)this.wAppendLogfile);
        this.wAppendLogfile.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Append.Logfile.Label", (String[])new String[0]));
        FormData fdLogFile = new FormData();
        fdLogFile.left = new FormAttachment(0, 0);
        fdLogFile.top = new FormAttachment((Control)this.wLoglevel, 10);
        this.wAppendLogfile.setLayoutData((Object)fdLogFile);
        this.wCreateParentFolder = new Button((Composite)this.gLogFile, 32);
        this.props.setLook((Control)this.wCreateParentFolder);
        this.wCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Logfile.CreateParentFolder.Label", (String[])new String[0]));
        FormData fdCreateParent = new FormData();
        fdCreateParent.left = new FormAttachment(0, 0);
        fdCreateParent.top = new FormAttachment((Control)this.wAppendLogfile, 10);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParent);
        this.wAddDate = new Button((Composite)this.gLogFile, 32);
        this.props.setLook((Control)this.wAddDate);
        this.wAddDate.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Logfile.IncludeDate.Label", (String[])new String[0]));
        FormData fdIncludeDate = new FormData();
        fdIncludeDate.left = new FormAttachment(0, 0);
        fdIncludeDate.top = new FormAttachment((Control)this.wCreateParentFolder, 10);
        this.wAddDate.setLayoutData((Object)fdIncludeDate);
        this.wAddTime = new Button((Composite)this.gLogFile, 32);
        this.props.setLook((Control)this.wAddTime);
        this.wAddTime.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Logfile.IncludeTime.Label", (String[])new String[0]));
        FormData fdIncludeTime = new FormData();
        fdIncludeTime.left = new FormAttachment(0, 0);
        fdIncludeTime.top = new FormAttachment((Control)this.wAddDate, 10);
        this.wAddTime.setLayoutData((Object)fdIncludeTime);
        this.wSetLogfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ActionBaseDialog.this.setActive();
            }
        });
        wLoggingTab.setControl((Control)wLogging);
        FormData fdLogging = new FormData();
        fdLogging.left = new FormAttachment(0, 0);
        fdLogging.top = new FormAttachment(0, 0);
        fdLogging.right = new FormAttachment(100, 0);
        fdLogging.bottom = new FormAttachment(100, 0);
        this.wOptions.setLayoutData((Object)fdLogging);
        CTabItem wParametersTab = new CTabItem(wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Fields.Parameters.Label", (String[])new String[0]));
        FormLayout fieldLayout = new FormLayout();
        fieldLayout.marginWidth = 15;
        fieldLayout.marginHeight = 15;
        Composite wParameterComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wParameterComp);
        wParameterComp.setLayout((Layout)fieldLayout);
        this.wPrevToParams = new Button(wParameterComp, 32);
        this.props.setLook((Control)this.wPrevToParams);
        this.wPrevToParams.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.PrevToParams.Label", (String[])new String[0]));
        FormData fdCopyResultsParams = new FormData();
        fdCopyResultsParams.left = new FormAttachment(0, 0);
        fdCopyResultsParams.top = new FormAttachment(0, 0);
        this.wPrevToParams.setLayoutData((Object)fdCopyResultsParams);
        this.wPrevToParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionBaseDialog.this.getAction().setChanged();
            }
        });
        this.wPassParams = new Button(wParameterComp, 32);
        this.props.setLook((Control)this.wPassParams);
        FormData fdPassParams = new FormData();
        fdPassParams.left = new FormAttachment(0, 0);
        fdPassParams.top = new FormAttachment((Control)this.wPrevToParams, 10);
        this.wPassParams.setLayoutData((Object)fdPassParams);
        this.wbGetParams = new Button(wParameterComp, 8);
        this.wbGetParams.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.GetParameters.Button.Label", (String[])new String[0]));
        FormData fdGetParams = new FormData();
        fdGetParams.bottom = new FormAttachment(100, 0);
        fdGetParams.right = new FormAttachment(100, 0);
        this.wbGetParams.setLayoutData((Object)fdGetParams);
        int parameterRows = this.getParameters() != null ? this.getParameters().length : 0;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionPipeline.Parameters.Parameter.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionPipeline.Parameters.ColumnName.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionPipeline.Parameters.Value.Label", (String[])new String[0]), 1, false)};
        colinf[2].setUsingVariables(true);
        this.wParameters = new TableView(this.variables, wParameterComp, 67586, colinf, parameterRows, false, lsMod, this.props, false);
        this.props.setLook((Control)this.wParameters);
        FormData fdParameters = new FormData();
        fdParameters.left = new FormAttachment(0, 0);
        fdParameters.top = new FormAttachment((Control)this.wPassParams, 10);
        fdParameters.right = new FormAttachment(100);
        fdParameters.bottom = new FormAttachment((Control)this.wbGetParams, -10);
        this.wParameters.setLayoutData(fdParameters);
        this.wParameters.getTable().addListener(11, (Listener)new ColumnsResizer(0, 33, 33, 33));
        FormData fdParametersComp = new FormData();
        fdParametersComp.left = new FormAttachment(0, 0);
        fdParametersComp.top = new FormAttachment(0, 0);
        fdParametersComp.right = new FormAttachment(100, 0);
        fdParametersComp.bottom = new FormAttachment(100, 0);
        wParameterComp.setLayoutData((Object)fdParametersComp);
        wParameterComp.layout();
        wParametersTab.setControl((Control)wParameterComp);
        wTabFolder.setSelection(0);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOk, this.wCancel}, 4, null);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wRunConfiguration, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        wTabFolder.setLayoutData((Object)fdTabFolder);
    }

    protected void selectLogFile(String[] filters) {
        String filename = BaseDialog.presentFileDialog(this.shell, this.wLogfile, this.variables, new String[]{"*.txt", "*.log", "*"}, filters, true);
        if (filename != null) {
            FileObject file = null;
            try {
                file = HopVfs.getFileObject((String)filename);
                this.wLogext.setText(file.getName().getExtension());
                this.wLogfile.setText(this.wLogfile.getText().substring(0, this.wLogfile.getText().length() - this.wLogext.getText().length() - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected void setActive() {
        this.gLogFile.setEnabled(this.wSetLogfile.getSelection());
        this.wbLogFilename.setEnabled(this.wSetLogfile.getSelection());
        this.wlLogfile.setEnabled(this.wSetLogfile.getSelection());
        this.wLogfile.setEnabled(this.wSetLogfile.getSelection());
        this.wlLogext.setEnabled(this.wSetLogfile.getSelection());
        this.wLogext.setEnabled(this.wSetLogfile.getSelection());
        this.wCreateParentFolder.setEnabled(this.wSetLogfile.getSelection());
        this.wAddDate.setEnabled(this.wSetLogfile.getSelection());
        this.wAddTime.setEnabled(this.wSetLogfile.getSelection());
        this.wlLoglevel.setEnabled(this.wSetLogfile.getSelection());
        this.wLoglevel.setEnabled(this.wSetLogfile.getSelection());
        this.wAppendLogfile.setEnabled(this.wSetLogfile.getSelection());
    }

    protected void replaceNameWithBaseFilename(String filename) {
        MessageBox box = new MessageBox(this.shell, 196);
        box.setText("Change name?");
        box.setMessage("Do you want to change the name of the action to match the filename?");
        int answer = box.open();
        if ((answer & 0x40) != 0) {
            try {
                String baseName = HopVfs.getFileObject((String)this.variables.resolve(filename)).getName().getBaseName();
                this.wName.setText(baseName);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error extracting name from filename '" + filename + "'", e);
            }
        }
    }

    protected abstract void ok();

    protected abstract void cancel();

    protected abstract ActionBase getAction();

    protected abstract Image getImage();

    protected abstract String[] getParameters();
}

