/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.synthetic.BundleSplitter;
import org.apache.beam.sdk.io.synthetic.SyntheticRecordsCheckpoint;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.io.synthetic.SyntheticWatermark;
import org.apache.beam.sdk.io.synthetic.delay.ReaderDelay;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SyntheticUnboundedSource
extends UnboundedSource<KV<byte[], byte[]>, SyntheticRecordsCheckpoint> {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(SyntheticUnboundedSource.class);
    private final SyntheticSourceOptions sourceOptions;
    private final BundleSplitter bundleSplitter;
    private final long startOffset;
    private final long endOffset;

    public SyntheticUnboundedSource(SyntheticSourceOptions sourceOptions) {
        this(0L, sourceOptions.numRecords, sourceOptions);
    }

    private SyntheticUnboundedSource(long startOffset, long endOffset, SyntheticSourceOptions sourceOptions) {
        this.sourceOptions = sourceOptions;
        this.bundleSplitter = new BundleSplitter(sourceOptions);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public Coder<KV<byte[], byte[]>> getOutputCoder() {
        return KvCoder.of((Coder)ByteArrayCoder.of(), (Coder)ByteArrayCoder.of());
    }

    public void validate() {
        super.validate();
        this.sourceOptions.validate();
    }

    public Coder<SyntheticRecordsCheckpoint> getCheckpointMarkCoder() {
        return SyntheticRecordsCheckpoint.CODER;
    }

    public UnboundedSource.UnboundedReader<KV<byte[], byte[]>> createReader(PipelineOptions options, @Nullable SyntheticRecordsCheckpoint checkpoint) {
        if (checkpoint == null) {
            return new SyntheticUnboundedReader(this);
        }
        return new SyntheticUnboundedReader(new SyntheticUnboundedSource(checkpoint.getStartPosition(), checkpoint.getEndPosition(), this.sourceOptions));
    }

    public List<SyntheticUnboundedSource> split(int desiredNumSplits, PipelineOptions options) {
        int desiredNumBundles = this.sourceOptions.forceNumInitialBundles != null ? this.sourceOptions.forceNumInitialBundles : desiredNumSplits;
        List<SyntheticUnboundedSource> splits = this.bundleSplitter.getBundleSizes(desiredNumBundles, this.startOffset, this.endOffset).stream().map(offsetRange -> new SyntheticUnboundedSource(offsetRange.getFrom(), offsetRange.getTo(), this.sourceOptions)).collect(Collectors.toList());
        LOG.info("Split into {} bundles of sizes: {}", (Object)splits.size(), splits);
        return splits;
    }

    private class SyntheticUnboundedReader
    extends UnboundedSource.UnboundedReader<KV<byte[], byte[]>> {
        private final SyntheticUnboundedSource source;
        private KV<byte[], byte[]> currentKVPair = null;
        private long currentOffset;
        private Instant processingTime;
        private Instant eventTime;
        private SyntheticWatermark syntheticWatermark;
        private ReaderDelay delay;

        public SyntheticUnboundedReader(SyntheticUnboundedSource source) {
            this.delay = new ReaderDelay(SyntheticUnboundedSource.this.sourceOptions);
            this.source = source;
            this.currentOffset = 0L;
            this.syntheticWatermark = new SyntheticWatermark(SyntheticUnboundedSource.this.sourceOptions, source.endOffset);
        }

        public SyntheticUnboundedSource getCurrentSource() {
            return this.source;
        }

        public KV<byte[], byte[]> getCurrent() throws NoSuchElementException {
            if (this.currentKVPair == null) {
                throw new NoSuchElementException("Current record is unavailable because either the reader is at the beginning of the input and start() or advance() wasn't called, or the last start() or advance() returned false.");
            }
            return this.currentKVPair;
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            if (this.eventTime == null) {
                throw new NoSuchElementException("Current timestamp is unavailable because either the reader is at the beginning of the input and start() or advance() wasn't called, or the last start() or advance() returned false.");
            }
            return this.eventTime;
        }

        public boolean start() {
            this.currentOffset = SyntheticUnboundedSource.this.startOffset;
            this.delay.delayStart(this.currentOffset);
            return this.advance();
        }

        public boolean advance() {
            ++this.currentOffset;
            this.processingTime = new Instant();
            this.eventTime = this.processingTime.minus((ReadableDuration)SyntheticUnboundedSource.this.sourceOptions.nextProcessingTimeDelay(this.currentOffset));
            SyntheticSourceOptions.Record record = this.getCurrentSource().sourceOptions.genRecord(this.currentOffset);
            this.currentKVPair = record.kv;
            this.delay.delayRecord(record);
            return this.currentOffset < this.source.endOffset;
        }

        public Instant getWatermark() {
            return this.syntheticWatermark.calculateNew(this.currentOffset, this.processingTime);
        }

        public UnboundedSource.CheckpointMark getCheckpointMark() {
            return new SyntheticRecordsCheckpoint(this.source.startOffset, this.source.endOffset);
        }

        public void close() {
        }
    }
}

