/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.propertyinput;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInputData;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInputField;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInputMeta;
import org.ini4j.Profile;
import org.ini4j.Wini;

public class PropertyInput
extends BaseTransform<PropertyInputMeta, PropertyInputData> {
    private static final Class<?> PKG = PropertyInputMeta.class;

    public PropertyInput(TransformMeta transformMeta, PropertyInputMeta meta, PropertyInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block7: {
            if (this.first && !((PropertyInputMeta)this.meta).isFileField()) {
                ((PropertyInputData)this.data).files = ((PropertyInputMeta)this.meta).getFiles((IVariables)this);
                if (((PropertyInputData)this.data).files == null || ((PropertyInputData)this.data).files.nrOfFiles() == 0) {
                    this.setOutputDone();
                    return false;
                }
                this.handleMissingFiles();
                ((PropertyInputData)this.data).outputRowMeta = new RowMeta();
                ((PropertyInputMeta)this.meta).getFields(((PropertyInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((PropertyInputData)this.data).convertRowMeta = ((PropertyInputData)this.data).outputRowMeta.cloneToType(2);
            }
            Object[] r = null;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                Object[] outputRowData = this.getOneRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(((PropertyInputData)this.data).outputRowMeta, outputRowData);
                if (((PropertyInputMeta)this.meta).getRowLimit() > 0L && ((PropertyInputData)this.data).rownr > ((PropertyInputMeta)this.meta).getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.ErrorInTransformRunning", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block7;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "PropertyInput001");
            }
        }
        return true;
    }

    private void handleMissingFiles() throws HopException {
        List nonExistantFiles = ((PropertyInputData)this.data).files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = ((PropertyInputData)this.data).files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private Object[] getOneRow() throws HopException {
        try {
            if (((PropertyInputMeta)this.meta).isFileField()) {
                while (((PropertyInputData)this.data).readrow == null || ((PropertyInputData)this.data).propfiles && !((PropertyInputData)this.data).it.hasNext() || !((PropertyInputData)this.data).propfiles && !((PropertyInputData)this.data).iniIt.hasNext()) {
                    if (!((PropertyInputData)this.data).propfiles && ((PropertyInputData)this.data).realSection == null && ((PropertyInputData)this.data).readrow != null && ((PropertyInputData)this.data).itSection.hasNext()) {
                        ((PropertyInputData)this.data).iniSection = (Profile.Section)((PropertyInputData)this.data).wini.get((Object)((PropertyInputData)this.data).itSection.next().toString());
                        ((PropertyInputData)this.data).iniIt = ((PropertyInputData)this.data).iniSection.keySet().iterator();
                        continue;
                    }
                    if (this.openNextFile()) continue;
                    return null;
                }
            } else {
                while (((PropertyInputData)this.data).file == null || ((PropertyInputData)this.data).propfiles && !((PropertyInputData)this.data).it.hasNext() || !((PropertyInputData)this.data).propfiles && !((PropertyInputData)this.data).iniIt.hasNext()) {
                    if (!((PropertyInputData)this.data).propfiles && ((PropertyInputData)this.data).realSection == null && ((PropertyInputData)this.data).file != null && ((PropertyInputData)this.data).itSection.hasNext()) {
                        ((PropertyInputData)this.data).iniSection = (Profile.Section)((PropertyInputData)this.data).wini.get((Object)((PropertyInputData)this.data).itSection.next().toString());
                        ((PropertyInputData)this.data).iniIt = ((PropertyInputData)this.data).iniSection.keySet().iterator();
                        continue;
                    }
                    if (this.openNextFile()) continue;
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.logError("Unable to read row from file : " + e.getMessage());
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (((PropertyInputMeta)this.meta).isFileField()) {
            r = (Object[])((PropertyInputData)this.data).readrow.clone();
        }
        try {
            String key = null;
            key = ((PropertyInputData)this.data).propfiles ? ((PropertyInputData)this.data).it.next().toString() : ((PropertyInputData)this.data).iniIt.next().toString();
            for (int i = 0; i < ((PropertyInputMeta)this.meta).getInputFields().length; ++i) {
                String value = null;
                value = ((PropertyInputMeta)this.meta).getInputFields()[i].getColumnCode().equals(PropertyInputField.ColumnCode[0]) ? key : (((PropertyInputMeta)this.meta).isResolveValueVariable() ? (((PropertyInputData)this.data).propfiles ? this.resolve(((PropertyInputData)this.data).pro.getProperty(key)) : this.resolve(((PropertyInputData)this.data).iniSection.fetch((Object)key))) : (((PropertyInputData)this.data).propfiles ? ((PropertyInputData)this.data).pro.getProperty(key) : ((PropertyInputData)this.data).iniSection.fetch((Object)key)));
                switch (((PropertyInputMeta)this.meta).getInputFields()[i].getTrimType()) {
                    case 1: {
                        value = Const.ltrim((String)value);
                        break;
                    }
                    case 2: {
                        value = Const.rtrim((String)value);
                        break;
                    }
                    case 3: {
                        value = Const.trim((String)value);
                        break;
                    }
                }
                if (((PropertyInputMeta)this.meta).isFileField()) {
                    r = RowDataUtil.addValueData((Object[])r, (int)(((PropertyInputData)this.data).totalpreviousfields + i), (Object)value);
                }
                IValueMeta targetValueMeta = ((PropertyInputData)this.data).outputRowMeta.getValueMeta(((PropertyInputData)this.data).totalpreviousfields + i);
                IValueMeta sourceValueMeta = ((PropertyInputData)this.data).convertRowMeta.getValueMeta(((PropertyInputData)this.data).totalpreviousfields + i);
                r[((PropertyInputData)this.data).totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
                if (!((PropertyInputMeta)this.meta).getInputFields()[i].isRepeated() || ((PropertyInputData)this.data).previousRow == null || !Utils.isEmpty((CharSequence)value)) continue;
                r[((PropertyInputData)this.data).totalpreviousfields + i] = ((PropertyInputData)this.data).previousRow[((PropertyInputData)this.data).totalpreviousfields + i];
            }
            int rowIndex = ((PropertyInputMeta)this.meta).getInputFields().length;
            if (((PropertyInputMeta)this.meta).includeFilename() && !Utils.isEmpty((CharSequence)((PropertyInputMeta)this.meta).getFilenameField())) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).filename;
            }
            if (((PropertyInputMeta)this.meta).includeRowNumber() && !Utils.isEmpty((CharSequence)((PropertyInputMeta)this.meta).getRowNumberField())) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).rownr;
            }
            if (((PropertyInputMeta)this.meta).includeIniSection() && !Utils.isEmpty((CharSequence)((PropertyInputMeta)this.meta).getINISectionField())) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = this.resolve(((PropertyInputData)this.data).iniSection.getName());
            }
            if (((PropertyInputMeta)this.meta).getShortFileNameField() != null && ((PropertyInputMeta)this.meta).getShortFileNameField().length() > 0) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).shortFilename;
            }
            if (((PropertyInputMeta)this.meta).getExtensionField() != null && ((PropertyInputMeta)this.meta).getExtensionField().length() > 0) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).extension;
            }
            if (((PropertyInputMeta)this.meta).getPathField() != null && ((PropertyInputMeta)this.meta).getPathField().length() > 0) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).path;
            }
            if (((PropertyInputMeta)this.meta).getSizeField() != null && ((PropertyInputMeta)this.meta).getSizeField().length() > 0) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).size;
            }
            if (((PropertyInputMeta)this.meta).isHiddenField() != null && ((PropertyInputMeta)this.meta).isHiddenField().length() > 0) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).hidden;
            }
            if (((PropertyInputMeta)this.meta).getLastModificationDateField() != null && ((PropertyInputMeta)this.meta).getLastModificationDateField().length() > 0) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).lastModificationDateTime;
            }
            if (((PropertyInputMeta)this.meta).getUriField() != null && ((PropertyInputMeta)this.meta).getUriField().length() > 0) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).uriName;
            }
            if (((PropertyInputMeta)this.meta).getRootUriField() != null && ((PropertyInputMeta)this.meta).getRootUriField().length() > 0) {
                r[((PropertyInputData)this.data).totalpreviousfields + rowIndex++] = ((PropertyInputData)this.data).rootUriName;
            }
            IRowMeta irow = this.getInputRowMeta();
            ((PropertyInputData)this.data).previousRow = irow == null ? r : irow.cloneRow(r);
            this.incrementLinesInput();
            ++((PropertyInputData)this.data).rownr;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Error.CanNotReadFromFile", (String[])new String[]{((PropertyInputData)this.data).file.toString()}), (Throwable)e);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openNextFile() {
        InputStream fis = null;
        try {
            if (!((PropertyInputMeta)this.meta).isFileField()) {
                if (((PropertyInputData)this.data).filenr >= ((PropertyInputData)this.data).files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    boolean bl = false;
                    return bl;
                }
                ((PropertyInputData)this.data).last_file = ((PropertyInputData)this.data).filenr == ((PropertyInputData)this.data).files.nrOfFiles() - 1;
                ((PropertyInputData)this.data).file = ((PropertyInputData)this.data).files.getFile(((PropertyInputData)this.data).filenr);
                ++((PropertyInputData)this.data).filenr;
            } else {
                ((PropertyInputData)this.data).readrow = this.getRow();
                if (((PropertyInputData)this.data).readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    boolean bl = false;
                    return bl;
                }
                if (this.first) {
                    this.first = false;
                    ((PropertyInputData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((PropertyInputData)this.data).outputRowMeta = ((PropertyInputData)this.data).inputRowMeta.clone();
                    ((PropertyInputMeta)this.meta).getFields(((PropertyInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((PropertyInputData)this.data).totalpreviousfields = ((PropertyInputData)this.data).inputRowMeta.size();
                    ((PropertyInputData)this.data).convertRowMeta = ((PropertyInputData)this.data).outputRowMeta.cloneToType(2);
                    if (Utils.isEmpty((CharSequence)((PropertyInputMeta)this.meta).getDynamicFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Log.NoField", (String[])new String[0]));
                    }
                    if (((PropertyInputData)this.data).indexOfFilenameField < 0) {
                        ((PropertyInputData)this.data).indexOfFilenameField = this.getInputRowMeta().indexOfValue(((PropertyInputMeta)this.meta).getDynamicFilenameField());
                        if (((PropertyInputData)this.data).indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((PropertyInputMeta)this.meta).getDynamicFilenameField() + "]");
                            throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Exception.CouldnotFindField", (String[])new String[]{((PropertyInputMeta)this.meta).getDynamicFilenameField()}));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(((PropertyInputData)this.data).readrow, ((PropertyInputData)this.data).indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FilenameInStream", (String[])new String[]{((PropertyInputMeta)this.meta).getDynamicFilenameField(), filename}));
                }
                ((PropertyInputData)this.data).file = HopVfs.getFileObject((String)filename);
            }
            ((PropertyInputData)this.data).filename = HopVfs.getFilename((FileObject)((PropertyInputData)this.data).file);
            if (((PropertyInputMeta)this.meta).getShortFileNameField() != null && ((PropertyInputMeta)this.meta).getShortFileNameField().length() > 0) {
                ((PropertyInputData)this.data).shortFilename = ((PropertyInputData)this.data).file.getName().getBaseName();
            }
            if (((PropertyInputMeta)this.meta).getPathField() != null && ((PropertyInputMeta)this.meta).getPathField().length() > 0) {
                ((PropertyInputData)this.data).path = HopVfs.getFilename((FileObject)((PropertyInputData)this.data).file.getParent());
            }
            if (((PropertyInputMeta)this.meta).isHiddenField() != null && ((PropertyInputMeta)this.meta).isHiddenField().length() > 0) {
                ((PropertyInputData)this.data).hidden = ((PropertyInputData)this.data).file.isHidden();
            }
            if (((PropertyInputMeta)this.meta).getExtensionField() != null && ((PropertyInputMeta)this.meta).getExtensionField().length() > 0) {
                ((PropertyInputData)this.data).extension = ((PropertyInputData)this.data).file.getName().getExtension();
            }
            if (((PropertyInputMeta)this.meta).getLastModificationDateField() != null && ((PropertyInputMeta)this.meta).getLastModificationDateField().length() > 0) {
                ((PropertyInputData)this.data).lastModificationDateTime = new Date(((PropertyInputData)this.data).file.getContent().getLastModifiedTime());
            }
            if (((PropertyInputMeta)this.meta).getUriField() != null && ((PropertyInputMeta)this.meta).getUriField().length() > 0) {
                ((PropertyInputData)this.data).uriName = ((PropertyInputData)this.data).file.getName().getURI();
            }
            if (((PropertyInputMeta)this.meta).getRootUriField() != null && ((PropertyInputMeta)this.meta).getRootUriField().length() > 0) {
                ((PropertyInputData)this.data).rootUriName = ((PropertyInputData)this.data).file.getName().getRootURI();
            }
            if (((PropertyInputMeta)this.meta).getSizeField() != null && ((PropertyInputMeta)this.meta).getSizeField().length() > 0) {
                ((PropertyInputData)this.data).size = ((PropertyInputData)this.data).file.getContent().getSize();
            }
            if (((PropertyInputMeta)this.meta).resetRowNumber()) {
                ((PropertyInputData)this.data).rownr = 0L;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.OpeningFile", (String[])new String[]{((PropertyInputData)this.data).file.toString()}));
            }
            if (((PropertyInputMeta)this.meta).isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, ((PropertyInputData)this.data).file, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            fis = ((PropertyInputData)this.data).file.getContent().getInputStream();
            if (((PropertyInputData)this.data).propfiles) {
                ((PropertyInputData)this.data).pro = new Properties();
                ((PropertyInputData)this.data).pro.load(fis);
                ((PropertyInputData)this.data).it = ((PropertyInputData)this.data).pro.keySet().iterator();
            } else {
                ((PropertyInputData)this.data).wini = new Wini();
                if (!Utils.isEmpty((CharSequence)((PropertyInputData)this.data).realEncoding)) {
                    ((PropertyInputData)this.data).wini.getConfig().setFileEncoding(Charset.forName(((PropertyInputData)this.data).realEncoding));
                }
                ((PropertyInputData)this.data).wini.load(fis);
                if (((PropertyInputData)this.data).realSection != null) {
                    ((PropertyInputData)this.data).iniSection = (Profile.Section)((PropertyInputData)this.data).wini.get((Object)((PropertyInputData)this.data).realSection);
                    if (((PropertyInputData)this.data).iniSection == null) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"PropertyInput.Error.CanNotFindSection", (String[])new String[]{((PropertyInputData)this.data).realSection, "" + ((PropertyInputData)this.data).file.getName()}));
                    }
                } else {
                    ((PropertyInputData)this.data).itSection = ((PropertyInputData)this.data).wini.keySet().iterator();
                    ((PropertyInputData)this.data).iniSection = (Profile.Section)((PropertyInputData)this.data).wini.get((Object)((PropertyInputData)this.data).itSection.next().toString());
                }
                ((PropertyInputData)this.data).iniIt = ((PropertyInputData)this.data).iniSection.keySet().iterator();
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.Log.FileOpened", (String[])new String[]{((PropertyInputData)this.data).file.toString()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"PropertyInput.log.TotalKey", (String[])new String[]{"" + (((PropertyInputData)this.data).propfiles ? ((PropertyInputData)this.data).pro.size() : ((PropertyInputData)this.data).iniSection.size()), HopVfs.getFilename((FileObject)((PropertyInputData)this.data).file)}));
            }
            BaseTransform.closeQuietly((Closeable)fis);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"PropertyInput.Log.UnableToOpenFile", (String[])new String[]{"" + ((PropertyInputData)this.data).filenr, ((PropertyInputData)this.data).file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            boolean bl = false;
            return bl;
        }
        finally {
            BaseTransform.closeQuietly(fis);
        }
        return true;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)((PropertyInputData)this.data).outputRowMeta.size());
        return rowData;
    }

    public boolean init() {
        if (super.init()) {
            String realSection;
            String realEncoding = this.resolve(((PropertyInputMeta)this.meta).getEncoding());
            if (!Utils.isEmpty((CharSequence)realEncoding)) {
                ((PropertyInputData)this.data).realEncoding = realEncoding;
            }
            if (!Utils.isEmpty((CharSequence)(realSection = this.resolve(((PropertyInputMeta)this.meta).getSection())))) {
                ((PropertyInputData)this.data).realSection = realSection;
            }
            ((PropertyInputData)this.data).propfiles = PropertyInputMeta.getFileTypeByDesc(((PropertyInputMeta)this.meta).getFileType()) == 0;
            ((PropertyInputData)this.data).rownr = 1L;
            ((PropertyInputData)this.data).totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((PropertyInputData)this.data).readrow != null) {
            ((PropertyInputData)this.data).readrow = null;
        }
        if (((PropertyInputData)this.data).iniSection != null) {
            ((PropertyInputData)this.data).iniSection.clear();
        }
        ((PropertyInputData)this.data).iniSection = null;
        if (((PropertyInputData)this.data).itSection != null) {
            ((PropertyInputData)this.data).itSection = null;
        }
        if (((PropertyInputData)this.data).file != null) {
            try {
                ((PropertyInputData)this.data).file.close();
                ((PropertyInputData)this.data).file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

