/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class DynamicDestinations<T, DestinationT>
implements Serializable {
    private transient @Nullable SideInputAccessor sideInputAccessor;
    private transient @Nullable PipelineOptions options;

    @Nullable PipelineOptions getPipelineOptions() {
        return this.options;
    }

    public List<PCollectionView<?>> getSideInputs() {
        return Lists.newArrayList();
    }

    protected final <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> view) {
        Preconditions.checkState((boolean)this.getSideInputs().contains(view), (String)"View %s not declared in getSideInputs() (%s)", view, this.getSideInputs());
        return this.sideInputAccessor.sideInput(view);
    }

    void setSideInputAccessorFromProcessContext(DoFn.ProcessContext context) {
        this.sideInputAccessor = new SideInputAccessorViaProcessContext(context);
        this.options = context.getPipelineOptions();
    }

    public abstract DestinationT getDestination(ValueInSingleWindow<T> var1);

    public @Nullable Coder<DestinationT> getDestinationCoder() {
        return null;
    }

    public abstract TableDestination getTable(DestinationT var1);

    public abstract TableSchema getSchema(DestinationT var1);

    Coder<DestinationT> getDestinationCoderWithDefault(CoderRegistry registry) throws CannotProvideCoderException {
        Coder<DestinationT> destinationCoder = this.getDestinationCoder();
        if (destinationCoder != null) {
            return destinationCoder;
        }
        TypeDescriptor descriptor = TypeDescriptors.extractFromTypeParameters((Object)this, DynamicDestinations.class, (TypeDescriptors.TypeVariableExtractor)new TypeDescriptors.TypeVariableExtractor<DynamicDestinations<T, DestinationT>, DestinationT>(){});
        try {
            return registry.getCoder(descriptor);
        }
        catch (CannotProvideCoderException e) {
            throw new CannotProvideCoderException("Failed to infer coder for DestinationT from type " + descriptor + ", please provide it explicitly by overriding getDestinationCoder()", (Throwable)e);
        }
    }

    static class SideInputAccessorViaProcessContext
    implements SideInputAccessor {
        private DoFn.ProcessContext processContext;

        SideInputAccessorViaProcessContext(DoFn.ProcessContext processContext) {
            this.processContext = processContext;
        }

        @Override
        public <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> view) {
            return (SideInputT)this.processContext.sideInput(view);
        }
    }

    static interface SideInputAccessor {
        public <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> var1);
    }
}

