/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TwoLevelMessageConverterCache;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class StorageApiConvertMessages<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollection<KV<DestinationT, byte[]>>> {
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryServices bqServices;

    public StorageApiConvertMessages(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryServices bqServices) {
        this.dynamicDestinations = dynamicDestinations;
        this.bqServices = bqServices;
    }

    public PCollection<KV<DestinationT, byte[]>> expand(PCollection<KV<DestinationT, ElementT>> input) {
        String operationName = input.getName() + "/" + this.getName();
        return (PCollection)input.apply("Convert to message", (PTransform)ParDo.of(new ConvertMessagesDoFn<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, operationName)).withSideInputs(this.dynamicDestinations.getSideInputs()));
    }

    public static class ConvertMessagesDoFn<DestinationT, ElementT>
    extends DoFn<KV<DestinationT, ElementT>, KV<DestinationT, byte[]>> {
        private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
        private TwoLevelMessageConverterCache<DestinationT, ElementT> messageConverters;
        private final BigQueryServices bqServices;
        @Nullable
        private transient BigQueryServices.DatasetService datasetServiceInternal = null;

        ConvertMessagesDoFn(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryServices bqServices, String operationName) {
            this.dynamicDestinations = dynamicDestinations;
            this.messageConverters = new TwoLevelMessageConverterCache(operationName);
            this.bqServices = bqServices;
        }

        private BigQueryServices.DatasetService getDatasetService(PipelineOptions pipelineOptions) throws IOException {
            if (this.datasetServiceInternal == null) {
                this.datasetServiceInternal = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
            return this.datasetServiceInternal;
        }

        @DoFn.Teardown
        public void onTeardown() {
            try {
                if (this.datasetServiceInternal != null) {
                    this.datasetServiceInternal.close();
                    this.datasetServiceInternal = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, PipelineOptions pipelineOptions, @DoFn.Element KV<DestinationT, ElementT> element, DoFn.OutputReceiver<KV<DestinationT, byte[]>> o) throws Exception {
            this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter = this.messageConverters.get(element.getKey(), this.dynamicDestinations, this.getDatasetService(pipelineOptions));
            o.output((Object)KV.of((Object)element.getKey(), (Object)messageConverter.toMessage(element.getValue()).toByteArray()));
        }
    }
}

