/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteUnshardedRecords;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class StorageApiWriteRecordsInconsistent<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, byte[]>>, PCollection<Void>> {
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final String kmsKey;
    private final BigQueryServices bqServices;
    private final Coder<DestinationT> destinationCoder;

    public StorageApiWriteRecordsInconsistent(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryIO.Write.CreateDisposition createDisposition, String kmsKey, BigQueryServices bqServices, Coder<DestinationT> destinationCoder) {
        this.dynamicDestinations = dynamicDestinations;
        this.createDisposition = createDisposition;
        this.kmsKey = kmsKey;
        this.bqServices = bqServices;
        this.destinationCoder = destinationCoder;
    }

    public PCollection<Void> expand(PCollection<KV<DestinationT, byte[]>> input) {
        String operationName = input.getName() + "/" + this.getName();
        input.apply("Write Records", (PTransform)ParDo.of(new StorageApiWriteUnshardedRecords.WriteRecordsDoFn<DestinationT, ElementT>(operationName, this.dynamicDestinations, this.bqServices, this.destinationCoder, this.createDisposition, this.kmsKey, true)).withSideInputs(this.dynamicDestinations.getSideInputs()));
        return (PCollection)input.getPipeline().apply("voids", (PTransform)Create.empty((Coder)VoidCoder.of()));
    }
}

