/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1.model.Message;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.AutoValue_HL7v2IO_Write;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2MessageCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOErrorCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7v2IO {
    private static Write.Builder write(String hl7v2Store) {
        return new AutoValue_HL7v2IO_Write.Builder().setHL7v2Store((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)hl7v2Store));
    }

    public static Read getAll() {
        return new Read();
    }

    public static ListHL7v2Messages readAll(List<String> hl7v2Stores) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hl7v2Stores), (ValueProvider<String>)ValueProvider.StaticValueProvider.of(null));
    }

    public static ListHL7v2Messages readAll(ValueProvider<List<String>> hl7v2Stores) {
        return new ListHL7v2Messages(hl7v2Stores, (ValueProvider<String>)ValueProvider.StaticValueProvider.of(null));
    }

    public static ListHL7v2Messages read(String hl7v2Store) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(Collections.singletonList(hl7v2Store)), (ValueProvider<String>)ValueProvider.StaticValueProvider.of(null));
    }

    public static ListHL7v2Messages read(ValueProvider<String> hl7v2Store) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(Collections.singletonList((String)hl7v2Store.get())), (ValueProvider<String>)ValueProvider.StaticValueProvider.of(null));
    }

    public static ListHL7v2Messages readWithFilter(String hl7v2Store, String filter) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(Collections.singletonList(hl7v2Store)), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filter));
    }

    public static ListHL7v2Messages readWithFilter(ValueProvider<String> hl7v2Store, ValueProvider<String> filter) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(Collections.singletonList((String)hl7v2Store.get())), filter);
    }

    public static ListHL7v2Messages readAllWithFilter(List<String> hl7v2Stores, String filter) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hl7v2Stores), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filter));
    }

    public static ListHL7v2Messages readAllWithFilter(ValueProvider<List<String>> hl7v2Stores, ValueProvider<String> filter) {
        return new ListHL7v2Messages(hl7v2Stores, filter);
    }

    public static Write ingestMessages(String hl7v2Store) {
        return HL7v2IO.write(hl7v2Store).setWriteMethod(Write.WriteMethod.INGEST).build();
    }

    static class WriteHL7v2
    extends PTransform<PCollection<HL7v2Message>, Write.Result> {
        private final ValueProvider<String> hl7v2Store;
        private final Write.WriteMethod writeMethod;

        WriteHL7v2(ValueProvider<String> hl7v2Store, Write.WriteMethod writeMethod) {
            this.hl7v2Store = hl7v2Store;
            this.writeMethod = writeMethod;
        }

        public Write.Result expand(PCollection<HL7v2Message> input) {
            PCollection failedInserts = ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new WriteHL7v2Fn(this.hl7v2Store, this.writeMethod)))).setCoder(HealthcareIOErrorCoder.of(HL7v2MessageCoder.of()));
            return Write.Result.in(input.getPipeline(), (PCollection<HealthcareIOError<HL7v2Message>>)failedInserts);
        }

        static class WriteHL7v2Fn
        extends DoFn<HL7v2Message, HealthcareIOError<HL7v2Message>> {
            private Distribution messageIngestLatencyMs = Metrics.distribution(WriteHL7v2Fn.class, (String)"hl7v2-message-ingest-latency-ms");
            private Counter failedMessageWrites = Metrics.counter(WriteHL7v2Fn.class, (String)"failed-hl7v2-message-writes");
            private final Counter successfulHL7v2MessageWrites = Metrics.counter(WriteHL7v2Fn.class, (String)"successful-hl7v2-message-writes");
            private final ValueProvider<String> hl7v2Store;
            private final Write.WriteMethod writeMethod;
            private static final Logger LOG = LoggerFactory.getLogger(WriteHL7v2Fn.class);
            private transient HealthcareApiClient client;

            WriteHL7v2Fn(ValueProvider<String> hl7v2Store, Write.WriteMethod writeMethod) {
                this.hl7v2Store = hl7v2Store;
                this.writeMethod = writeMethod;
            }

            @DoFn.Setup
            public void initClient() throws IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.ProcessElement
            public void writeMessages(DoFn.ProcessContext context) {
                HL7v2Message msg = (HL7v2Message)context.element();
                Message model = new Message();
                model.setData(msg.getData());
                model.setLabels(msg.getLabels());
                switch (this.writeMethod) {
                    case BATCH_IMPORT: {
                        throw new UnsupportedOperationException("The batch import API is not supported yet");
                    }
                }
                try {
                    long requestTimestamp = Instant.now().getMillis();
                    this.client.ingestHL7v2Message((String)this.hl7v2Store.get(), model);
                    this.successfulHL7v2MessageWrites.inc();
                    this.messageIngestLatencyMs.update(Instant.now().getMillis() - requestTimestamp);
                }
                catch (Exception e) {
                    this.failedMessageWrites.inc();
                    LOG.warn(String.format("Failed to ingest message Error: %s Stacktrace: %s", e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                    HealthcareIOError<HL7v2Message> err = HealthcareIOError.of(msg, e);
                    LOG.warn(String.format("%s %s", err.getErrorMessage(), err.getStackTrace()));
                    context.output(err);
                }
            }
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<HL7v2Message>, Result> {
        public static final TupleTag<HealthcareIOError<HL7v2Message>> SUCCESS = new TupleTag<HealthcareIOError<HL7v2Message>>(){};
        public static final TupleTag<HealthcareIOError<HL7v2Message>> FAILED = new TupleTag<HealthcareIOError<HL7v2Message>>(){};

        abstract ValueProvider<String> getHL7v2Store();

        abstract WriteMethod getWriteMethod();

        public Result expand(PCollection<HL7v2Message> messages) {
            CoderRegistry coderRegistry = messages.getPipeline().getCoderRegistry();
            coderRegistry.registerCoderForClass(HL7v2Message.class, (Coder)HL7v2MessageCoder.of());
            return (Result)messages.apply((PTransform)new WriteHL7v2(this.getHL7v2Store(), this.getWriteMethod()));
        }

        public static class Result
        implements POutput {
            private final Pipeline pipeline;
            private final PCollection<HealthcareIOError<HL7v2Message>> failedInsertsWithErr;

            static Result in(Pipeline pipeline, PCollection<HealthcareIOError<HL7v2Message>> failedInserts) {
                return new Result(pipeline, failedInserts);
            }

            public PCollection<HealthcareIOError<HL7v2Message>> getFailedInsertsWithErr() {
                return this.failedInsertsWithErr;
            }

            public Pipeline getPipeline() {
                return this.pipeline;
            }

            public Map<TupleTag<?>, PValue> expand() {
                this.failedInsertsWithErr.setCoder(HealthcareIOErrorCoder.of(HL7v2MessageCoder.of()));
                return ImmutableMap.of(FAILED, this.failedInsertsWithErr);
            }

            public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
            }

            private Result(Pipeline pipeline, PCollection<HealthcareIOError<HL7v2Message>> failedInsertsWithErr) {
                this.pipeline = pipeline;
                this.failedInsertsWithErr = failedInsertsWithErr;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setHL7v2Store(ValueProvider<String> var1);

            abstract Builder setWriteMethod(WriteMethod var1);

            abstract Write build();
        }

        public static enum WriteMethod {
            INGEST,
            BATCH_IMPORT;

        }
    }

    @DoFn.BoundedPerElement
    @VisibleForTesting
    static class ListHL7v2MessagesFn
    extends DoFn<String, HL7v2Message> {
        private static final Duration DEFAULT_DESIRED_SPLIT_DURATION = Duration.standardDays((long)1L);
        private static final Duration DEFAULT_MIN_SPLIT_DURATION = Duration.standardHours((long)1L);
        private static final Logger LOG = LoggerFactory.getLogger(ListHL7v2MessagesFn.class);
        private ValueProvider<String> filter;
        private Duration initialSplitDuration;
        private transient HealthcareApiClient client;

        ListHL7v2MessagesFn(String filter) {
            this((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filter), null);
        }

        ListHL7v2MessagesFn(ValueProvider<String> filter, @Nullable Duration initialSplitDuration) {
            this.filter = filter;
            this.initialSplitDuration = initialSplitDuration == null ? DEFAULT_DESIRED_SPLIT_DURATION : initialSplitDuration;
        }

        @DoFn.Setup
        public void initClient() throws IOException {
            this.client = new HttpHealthcareApiClient();
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getEarliestToLatestRestriction(@DoFn.Element String hl7v2Store) throws IOException {
            Instant from = this.client.getEarliestHL7v2SendTime(hl7v2Store, (String)this.filter.get());
            Instant to = this.client.getLatestHL7v2SendTime(hl7v2Store, (String)this.filter.get()).plus((ReadableDuration)Duration.millis((long)1L));
            return new OffsetRange(from.getMillis(), to.getMillis());
        }

        @DoFn.SplitRestriction
        public void split(@DoFn.Restriction OffsetRange timeRange, DoFn.OutputReceiver<OffsetRange> out) {
            List splits = timeRange.split(this.initialSplitDuration.getMillis(), DEFAULT_MIN_SPLIT_DURATION.getMillis());
            Instant from = Instant.ofEpochMilli((long)timeRange.getFrom());
            Instant to = Instant.ofEpochMilli((long)timeRange.getTo());
            Duration totalDuration = new Duration((ReadableInstant)from, (ReadableInstant)to);
            LOG.info(String.format("splitting initial sendTime restriction of [minSendTime, now): [%s,%s), or [%s, %s). \ntotal days: %s \ninto %s splits. \nLast split: %s", from, to, timeRange.getFrom(), timeRange.getTo(), totalDuration.getStandardDays(), splits.size(), ((OffsetRange)splits.get(splits.size() - 1)).toString()));
            for (OffsetRange s : splits) {
                out.output((Object)s);
            }
        }

        @DoFn.ProcessElement
        public void listMessages(@DoFn.Element String hl7v2Store, RestrictionTracker<OffsetRange, Long> tracker, DoFn.OutputReceiver<HL7v2Message> outputReceiver) throws IOException {
            OffsetRange currentRestriction = (OffsetRange)tracker.currentRestriction();
            Instant startRestriction = Instant.ofEpochMilli((long)currentRestriction.getFrom());
            Instant endRestriction = Instant.ofEpochMilli((long)currentRestriction.getTo());
            HttpHealthcareApiClient.HL7v2MessagePages pages = new HttpHealthcareApiClient.HL7v2MessagePages(this.client, hl7v2Store, startRestriction, endRestriction, (String)this.filter.get(), "sendTime");
            long lastClaimedMilliSecond = startRestriction.getMillis() - 1L;
            for (HL7v2Message msg : FluentIterable.concat((Iterable)pages)) {
                Instant cursor = Instant.parse((String)msg.getSendTime());
                if (cursor.getMillis() > lastClaimedMilliSecond) {
                    if (!tracker.tryClaim((Object)cursor.getMillis())) {
                        return;
                    }
                    lastClaimedMilliSecond = cursor.getMillis();
                }
                outputReceiver.output((Object)msg);
            }
            tracker.tryClaim((Object)currentRestriction.getTo());
        }
    }

    public static class ListHL7v2Messages
    extends PTransform<PBegin, PCollection<HL7v2Message>> {
        private final ValueProvider<List<String>> hl7v2Stores;
        private final ValueProvider<String> filter;
        private Duration initialSplitDuration;

        ListHL7v2Messages(ValueProvider<List<String>> hl7v2Stores, ValueProvider<String> filter) {
            this.hl7v2Stores = hl7v2Stores;
            this.filter = filter;
            this.initialSplitDuration = null;
        }

        public ListHL7v2Messages withInitialSplitDuration(Duration initialSplitDuration) {
            this.initialSplitDuration = initialSplitDuration;
            return this;
        }

        public PCollection<HL7v2Message> expand(PBegin input) {
            CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
            coderRegistry.registerCoderForClass(HL7v2Message.class, (Coder)HL7v2MessageCoder.of());
            return (PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)Create.ofProvider(this.hl7v2Stores, (Coder)ListCoder.of((Coder)StringUtf8Coder.of())))).apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x))).apply((PTransform)ParDo.of((DoFn)new ListHL7v2MessagesFn(this.filter, this.initialSplitDuration)))).setCoder((Coder)HL7v2MessageCoder.of()).apply((PTransform)Reshuffle.viaRandomKey());
        }
    }

    public static class Read
    extends PTransform<PCollection<String>, Result> {
        public static final TupleTag<HL7v2Message> OUT = new TupleTag<HL7v2Message>(){};
        public static final TupleTag<HealthcareIOError<String>> DEAD_LETTER = new TupleTag<HealthcareIOError<String>>(){};

        public Result expand(PCollection<String> input) {
            CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
            coderRegistry.registerCoderForClass(HL7v2Message.class, (Coder)HL7v2MessageCoder.of());
            return (Result)input.apply("Fetch HL7v2 messages", (PTransform)new FetchHL7v2Message());
        }

        public static class FetchHL7v2Message
        extends PTransform<PCollection<String>, Result> {
            public Result expand(PCollection<String> msgIds) {
                CoderRegistry coderRegistry = msgIds.getPipeline().getCoderRegistry();
                coderRegistry.registerCoderForClass(HL7v2Message.class, (Coder)HL7v2MessageCoder.of());
                return new Result((PCollectionTuple)msgIds.apply((PTransform)ParDo.of((DoFn)new HL7v2MessageGetFn()).withOutputTags(OUT, TupleTagList.of(DEAD_LETTER))));
            }

            public static class HL7v2MessageGetFn
            extends DoFn<String, HL7v2Message> {
                private Counter failedMessageGets = Metrics.counter(HL7v2MessageGetFn.class, (String)"failed-message-reads");
                private static final Logger LOG = LoggerFactory.getLogger(HL7v2MessageGetFn.class);
                private final Counter successfulHL7v2MessageGets = Metrics.counter(HL7v2MessageGetFn.class, (String)"successful-hl7v2-message-gets");
                private HealthcareApiClient client;

                HL7v2MessageGetFn() {
                }

                @DoFn.Setup
                public void instantiateHealthcareClient() throws IOException {
                    this.client = new HttpHealthcareApiClient();
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    String msgId = (String)context.element();
                    try {
                        context.output((Object)HL7v2Message.fromModel(this.fetchMessage(this.client, msgId)));
                    }
                    catch (Exception e) {
                        this.failedMessageGets.inc();
                        LOG.warn(String.format("Error fetching HL7v2 message with ID %s writing to Dead Letter Queue. Cause: %s Stack Trace: %s", msgId, e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                        context.output(DEAD_LETTER, HealthcareIOError.of(msgId, e));
                    }
                }

                private Message fetchMessage(HealthcareApiClient client, String msgId) throws IOException, ParseException, IllegalArgumentException {
                    Message msg = client.getHL7v2Message(msgId);
                    if (msg == null) {
                        throw new IOException(String.format("GET request for %s returned null", msgId));
                    }
                    this.successfulHL7v2MessageGets.inc();
                    return msg;
                }
            }
        }

        public static class Result
        implements POutput,
        PInput {
            private PCollection<HL7v2Message> messages;
            private PCollection<HealthcareIOError<String>> failedReads;
            PCollectionTuple pct;

            public static Result of(PCollectionTuple pct) throws IllegalArgumentException {
                if (pct.getAll().keySet().containsAll(TupleTagList.of(OUT).and(DEAD_LETTER).getAll())) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the HL7v2IO.Read.OUT and HL7v2IO.Read.DEAD_LETTER tuple tags");
            }

            private Result(PCollectionTuple pct) {
                this.pct = pct;
                this.messages = pct.get(OUT).setCoder((Coder)HL7v2MessageCoder.of());
                this.failedReads = pct.get(DEAD_LETTER).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            }

            public PCollection<HealthcareIOError<String>> getFailedReads() {
                return this.failedReads;
            }

            public PCollection<HL7v2Message> getMessages() {
                return this.messages;
            }

            public Pipeline getPipeline() {
                return this.pct.getPipeline();
            }

            public Map<TupleTag<?>, PValue> expand() {
                return ImmutableMap.of(OUT, this.messages);
            }

            public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
            }
        }
    }
}

