/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class PubsubMessagePayloadOnlyCoder
extends CustomCoder<PubsubMessage> {
    private static final Coder<byte[]> PAYLOAD_CODER = ByteArrayCoder.of();

    public static PubsubMessagePayloadOnlyCoder of() {
        return new PubsubMessagePayloadOnlyCoder();
    }

    public void encode(PubsubMessage value, OutputStream outStream) throws IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(PubsubMessage value, OutputStream outStream, Coder.Context context) throws IOException {
        PAYLOAD_CODER.encode((Object)value.getPayload(), outStream, context);
    }

    public PubsubMessage decode(InputStream inStream) throws IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public PubsubMessage decode(InputStream inStream, Coder.Context context) throws IOException {
        return new PubsubMessage((byte[])PAYLOAD_CODER.decode(inStream, context), (Map<String, String>)ImmutableMap.of());
    }
}

