/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeRecordAction {
    private static final Logger LOG = LoggerFactory.getLogger(DataChangeRecordAction.class);
    private static final Tracer TRACER = Tracing.getTracer();

    @VisibleForTesting
    public Optional<DoFn.ProcessContinuation> run(PartitionMetadata partition, DataChangeRecord record, RestrictionTracker<TimestampRange, Timestamp> tracker, DoFn.OutputReceiver<DataChangeRecord> outputReceiver, ManualWatermarkEstimator<Instant> watermarkEstimator) {
        try (Scope scope = TRACER.spanBuilder("DataChangeRecordAction").setRecordEvents(true).startScopedSpan();){
            TRACER.getCurrentSpan().putAttribute("PartitionID", AttributeValue.stringAttributeValue((String)partition.getPartitionToken()));
            String token = partition.getPartitionToken();
            LOG.debug("[" + token + "] Processing data record " + record.getCommitTimestamp());
            Timestamp commitTimestamp = record.getCommitTimestamp();
            Instant commitInstant = new Instant(commitTimestamp.toSqlTimestamp().getTime());
            if (!tracker.tryClaim((Object)commitTimestamp)) {
                LOG.debug("[" + token + "] Could not claim queryChangeStream(" + commitTimestamp + "), stopping");
                Optional<DoFn.ProcessContinuation> optional = Optional.of(DoFn.ProcessContinuation.stop());
                return optional;
            }
            outputReceiver.outputWithTimestamp((Object)record, commitInstant);
            watermarkEstimator.setWatermark(commitInstant);
            LOG.debug("[" + token + "] Data record action completed successfully");
            Optional<DoFn.ProcessContinuation> optional = Optional.empty();
            return optional;
        }
    }
}

